/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal.validation;

import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.dsl.MacOSSigningSettings;
import org.jetbrains.compose.desktop.application.internal.validation.ValidateBundleIDKt;
import org.jetbrains.compose.desktop.application.internal.validation.ValidatedMacOSSigningSettings;
import org.jetbrains.compose.internal.utils.OS;
import org.jetbrains.compose.internal.utils.OsUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a4\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\tH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"ERR_PREFIX", "", "ERR_UNKNOWN_PREFIX", "ERR_UNKNOWN_SIGN_ID", "ERR_WRONG_OS", "validate", "Lorg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSSigningSettings;", "Lorg/jetbrains/compose/desktop/application/dsl/MacOSSigningSettings;", "bundleIDProvider", "Lorg/gradle/api/provider/Provider;", "project", "Lorg/gradle/api/Project;", "appStoreProvider", "", "compose"})
@SourceDebugExtension(value={"SMAP\nValidatedMacOSSigningSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValidatedMacOSSigningSettings.kt\norg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSSigningSettingsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1#2:83\n288#3,2:84\n*S KotlinDebug\n*F\n+ 1 ValidatedMacOSSigningSettings.kt\norg/jetbrains/compose/desktop/application/internal/validation/ValidatedMacOSSigningSettingsKt\n*L\n51#1:84,2\n*E\n"})
public final class ValidatedMacOSSigningSettingsKt {
    @NotNull
    private static final String ERR_PREFIX = "Signing settings error:";
    @NotNull
    private static final String ERR_WRONG_OS = "Signing settings error: macOS was expected, actual OS is " + OsUtilsKt.getCurrentOS();
    @NotNull
    private static final String ERR_UNKNOWN_PREFIX = "Signing settings error: Could not infer signing prefix. To specify:\n  * Set bundleID to reverse DNS notation (e.g. \"com.mycompany.myapp\");\n  * Use 'compose.desktop.mac.signing.prefix' Gradle property;\n  * Use 'nativeDistributions.macOS.signing.prefix' DSL property;";
    @NotNull
    private static final String ERR_UNKNOWN_SIGN_ID = "Signing settings error: signing identity is null or empty. To specify:\n  * Use 'compose.desktop.mac.signing.identity' Gradle property;\n  * Use 'nativeDistributions.macOS.signing.identity' DSL property;";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ValidatedMacOSSigningSettings validate(@NotNull MacOSSigningSettings $this$validate, @NotNull Provider<String> bundleIDProvider, @NotNull Project project, @NotNull Provider<Boolean> appStoreProvider) {
        File file2;
        Object it;
        Intrinsics.checkNotNullParameter((Object)$this$validate, (String)"<this>");
        Intrinsics.checkNotNullParameter(bundleIDProvider, (String)"bundleIDProvider");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(appStoreProvider, (String)"appStoreProvider");
        if (!(OsUtilsKt.getCurrentOS() == OS.MacOS)) {
            boolean $i$a$-check-ValidatedMacOSSigningSettingsKt$validate$22 = false;
            String $i$a$-check-ValidatedMacOSSigningSettingsKt$validate$22 = ERR_WRONG_OS;
            throw new IllegalStateException($i$a$-check-ValidatedMacOSSigningSettingsKt$validate$22.toString());
        }
        String bundleID = ValidateBundleIDKt.validateBundleID(bundleIDProvider);
        Object object = (String)$this$validate.getPrefix().getOrNull();
        if (object == null) {
            String string;
            it = string = StringsKt.substringBeforeLast$default((String)bundleID, (String)".", null, (int)2, null) + ".";
            boolean bl = false;
            object = StringsKt.contains$default((CharSequence)bundleID, (char)'.', (boolean)false, (int)2, null) ? string : null;
            if (object == null) {
                throw new IllegalStateException(ERR_UNKNOWN_PREFIX.toString());
            }
        }
        String signPrefix = object;
        String string = (String)$this$validate.getIdentity().getOrNull();
        if (string == null) {
            throw new IllegalStateException(ERR_UNKNOWN_SIGN_ID.toString());
        }
        String signIdentity = string;
        String keychainPath = (String)$this$validate.getKeychain().getOrNull();
        if (keychainPath != null) {
            Object v2;
            block8: {
                void $this$firstOrNull$iv;
                it = new File[]{project.file((Object)keychainPath), project.getRootProject().file((Object)keychainPath)};
                it = CollectionsKt.listOf((Object[])it);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    File it2 = (File)element$iv;
                    boolean bl = false;
                    if (!it2.exists()) continue;
                    v2 = element$iv;
                    break block8;
                }
                v2 = null;
            }
            File keychainFile = v2;
            if (!(keychainFile != null)) {
                boolean bl = false;
                String string2 = "Signing settings error: could not find the specified keychain: " + keychainPath;
                throw new IllegalStateException(string2.toString());
            }
            file2 = keychainFile;
        } else {
            file2 = null;
        }
        File keychainFile = file2;
        boolean appStore = Intrinsics.areEqual((Object)appStoreProvider.getOrNull(), (Object)true);
        return new ValidatedMacOSSigningSettings(bundleID, signIdentity, keychainFile, signPrefix, appStore);
    }
}

