/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.tasks;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.LocalState;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.application.internal.CliArgUtilsKt;
import org.jetbrains.compose.desktop.application.internal.ExternalToolRunner;
import org.jetbrains.compose.desktop.application.internal.files.FileUtilsKt;
import org.jetbrains.compose.desktop.application.tasks.AbstractProguardTask;
import org.jetbrains.compose.desktop.tasks.AbstractComposeDesktopTask;
import org.jetbrains.compose.internal.utils.OsUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00102\u001a\u000203H\u0007J\u0014\u00104\u001a\u000203*\u0002052\u0006\u00106\u001a\u00020\u001dH\u0002R\u0013\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00020\f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0013\u0010\u0016\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0006R2\u0010\u0018\u001a&\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a \u001b*\u0012\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u001b\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0013R\u0019\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0013R\u0013\u0010#\u001a\u00020\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\nR\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198AX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001b\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0013R\u0013\u0010*\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0006R\u0019\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0013R2\u0010.\u001a&\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a \u001b*\u0012\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a\u0018\u00010\u00190\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u00198EX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010'\u00a8\u00067"}, d2={"Lorg/jetbrains/compose/desktop/application/tasks/AbstractProguardTask;", "Lorg/jetbrains/compose/desktop/tasks/AbstractComposeDesktopTask;", "()V", "configurationFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getConfigurationFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "defaultComposeRulesFile", "Lorg/gradle/api/file/RegularFileProperty;", "getDefaultComposeRulesFile", "()Lorg/gradle/api/file/RegularFileProperty;", "destinationDir", "Lorg/gradle/api/file/DirectoryProperty;", "getDestinationDir", "()Lorg/gradle/api/file/DirectoryProperty;", "dontobfuscate", "Lorg/gradle/api/provider/Property;", "", "getDontobfuscate", "()Lorg/gradle/api/provider/Property;", "dontoptimize", "getDontoptimize", "inputFiles", "getInputFiles", "jarsConfigurationFile", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "kotlin.jvm.PlatformType", "javaHome", "", "getJavaHome", "joinOutputJars", "getJoinOutputJars", "mainClass", "getMainClass", "mainJar", "getMainJar", "mainJarInDestinationDir", "getMainJarInDestinationDir$compose", "()Lorg/gradle/api/provider/Provider;", "maxHeapSize", "getMaxHeapSize", "proguardFiles", "getProguardFiles", "proguardVersion", "getProguardVersion", "rootConfigurationFile", "workingDir", "Lorg/gradle/api/file/Directory;", "getWorkingDir", "execute", "", "writeLn", "Ljava/io/Writer;", "s", "compose"})
@SourceDebugExtension(value={"SMAP\nAbstractProguardTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractProguardTask.kt\norg/jetbrains/compose/desktop/application/tasks/AbstractProguardTask\n+ 2 providerUtils.kt\norg/jetbrains/compose/internal/utils/ProviderUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,168:1\n22#2:169\n22#2:170\n22#2:171\n25#2:172\n28#2:173\n25#2:174\n22#2:175\n1549#3:176\n1620#3,3:177\n*S KotlinDebug\n*F\n+ 1 AbstractProguardTask.kt\norg/jetbrains/compose/desktop/application/tasks/AbstractProguardTask\n*L\n39#1:169\n43#1:170\n47#1:171\n57#1:172\n63#1:173\n66#1:174\n69#1:175\n149#1:176\n149#1:177,3\n*E\n"})
public abstract class AbstractProguardTask
extends AbstractComposeDesktopTask {
    @NotNull
    private final ConfigurableFileCollection inputFiles;
    @NotNull
    private final RegularFileProperty mainJar;
    @NotNull
    private final Provider<RegularFile> mainJarInDestinationDir;
    @NotNull
    private final ConfigurableFileCollection configurationFiles;
    @NotNull
    private final Property<Boolean> dontobfuscate;
    @NotNull
    private final Property<Boolean> dontoptimize;
    @NotNull
    private final Property<Boolean> joinOutputJars;
    @NotNull
    private final RegularFileProperty defaultComposeRulesFile;
    @NotNull
    private final Property<String> proguardVersion;
    @NotNull
    private final ConfigurableFileCollection proguardFiles;
    @NotNull
    private final Property<String> javaHome;
    @NotNull
    private final Property<String> mainClass;
    @NotNull
    private final Property<String> maxHeapSize;
    @NotNull
    private final DirectoryProperty destinationDir;
    @NotNull
    private final Provider<Directory> workingDir;
    private final Provider<RegularFile> rootConfigurationFile;
    private final Provider<RegularFile> jarsConfigurationFile;

    public AbstractProguardTask() {
        ConfigurableFileCollection configurableFileCollection = this.getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"objects.fileCollection()");
        this.inputFiles = configurableFileCollection;
        RegularFileProperty regularFileProperty = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"objects.fileProperty()");
        this.mainJar = regularFileProperty;
        Provider provider = this.mainJar.flatMap(arg_0 -> AbstractProguardTask.mainJarInDestinationDir$lambda$0((Function1)new Function1<RegularFile, Provider<? extends RegularFile>>(this){
            final /* synthetic */ AbstractProguardTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Provider<? extends RegularFile> invoke(RegularFile it) {
                return this.this$0.getDestinationDir().file(it.getAsFile().getName());
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"mainJar.flatMap {\n      \u2026ile(it.asFile.name)\n    }");
        this.mainJarInDestinationDir = provider;
        ConfigurableFileCollection configurableFileCollection2 = this.getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection2, (String)"objects.fileCollection()");
        this.configurationFiles = configurableFileCollection2;
        ObjectFactory $this$nullableProperty$iv = this.getObjects();
        boolean $i$f$nullableProperty = false;
        Property property = $this$nullableProperty$iv.property(Boolean.class);
        Intrinsics.checkNotNull((Object)property, (String)"null cannot be cast to non-null type org.gradle.api.provider.Property<T of org.jetbrains.compose.internal.utils.ProviderUtilsKt.nullableProperty?>");
        this.dontobfuscate = property;
        $this$nullableProperty$iv = this.getObjects();
        $i$f$nullableProperty = false;
        Property property2 = $this$nullableProperty$iv.property(Boolean.class);
        Intrinsics.checkNotNull((Object)property2, (String)"null cannot be cast to non-null type org.gradle.api.provider.Property<T of org.jetbrains.compose.internal.utils.ProviderUtilsKt.nullableProperty?>");
        this.dontoptimize = property2;
        $this$nullableProperty$iv = this.getObjects();
        $i$f$nullableProperty = false;
        Property property3 = $this$nullableProperty$iv.property(Boolean.class);
        Intrinsics.checkNotNull((Object)property3, (String)"null cannot be cast to non-null type org.gradle.api.provider.Property<T of org.jetbrains.compose.internal.utils.ProviderUtilsKt.nullableProperty?>");
        this.joinOutputJars = property3;
        RegularFileProperty regularFileProperty2 = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty2, (String)"objects.fileProperty()");
        this.defaultComposeRulesFile = regularFileProperty2;
        ObjectFactory $this$notNullProperty$iv = this.getObjects();
        boolean $i$f$notNullProperty = false;
        Property property4 = $this$notNullProperty$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"property(T::class.java)");
        this.proguardVersion = property4;
        ConfigurableFileCollection configurableFileCollection3 = this.getObjects().fileCollection();
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection3, (String)"objects.fileCollection()");
        this.proguardFiles = configurableFileCollection3;
        $this$notNullProperty$iv = this.getObjects();
        String string = System.getProperty("java.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"java.home\")");
        String defaultValue$iv = string;
        boolean $i$f$notNullProperty2 = false;
        Property property5 = $this$notNullProperty$iv.property(String.class).value((Object)defaultValue$iv);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"property(T::class.java).value(defaultValue)");
        this.javaHome = property5;
        $this$notNullProperty$iv = this.getObjects();
        $i$f$notNullProperty = false;
        Property property6 = $this$notNullProperty$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property6, (String)"property(T::class.java)");
        this.mainClass = property6;
        $this$nullableProperty$iv = this.getObjects();
        $i$f$nullableProperty = false;
        Property property7 = $this$nullableProperty$iv.property(String.class);
        Intrinsics.checkNotNull((Object)property7, (String)"null cannot be cast to non-null type org.gradle.api.provider.Property<T of org.jetbrains.compose.internal.utils.ProviderUtilsKt.nullableProperty?>");
        this.maxHeapSize = property7;
        DirectoryProperty directoryProperty = this.getObjects().directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objects.directoryProperty()");
        this.destinationDir = directoryProperty;
        Provider provider2 = this.getProject().getLayout().getBuildDirectory().dir("compose/tmp/" + this.getName());
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.layout.buildDire\u2026.dir(\"compose/tmp/$name\")");
        this.workingDir = provider2;
        this.rootConfigurationFile = this.workingDir.map(arg_0 -> AbstractProguardTask.rootConfigurationFile$lambda$1(rootConfigurationFile.1.INSTANCE, arg_0));
        this.jarsConfigurationFile = this.workingDir.map(arg_0 -> AbstractProguardTask.jarsConfigurationFile$lambda$2(jarsConfigurationFile.1.INSTANCE, arg_0));
    }

    @InputFiles
    @NotNull
    public final ConfigurableFileCollection getInputFiles() {
        return this.inputFiles;
    }

    @InputFile
    @NotNull
    public final RegularFileProperty getMainJar() {
        return this.mainJar;
    }

    @Internal
    @NotNull
    public final Provider<RegularFile> getMainJarInDestinationDir$compose() {
        return this.mainJarInDestinationDir;
    }

    @InputFiles
    @NotNull
    public final ConfigurableFileCollection getConfigurationFiles() {
        return this.configurationFiles;
    }

    @Optional
    @Input
    @NotNull
    public final Property<Boolean> getDontobfuscate() {
        return this.dontobfuscate;
    }

    @Optional
    @Input
    @NotNull
    public final Property<Boolean> getDontoptimize() {
        return this.dontoptimize;
    }

    @Optional
    @Input
    @NotNull
    public final Property<Boolean> getJoinOutputJars() {
        return this.joinOutputJars;
    }

    @Optional
    @InputFile
    @NotNull
    public final RegularFileProperty getDefaultComposeRulesFile() {
        return this.defaultComposeRulesFile;
    }

    @Input
    @NotNull
    public final Property<String> getProguardVersion() {
        return this.proguardVersion;
    }

    @InputFiles
    @NotNull
    public final ConfigurableFileCollection getProguardFiles() {
        return this.proguardFiles;
    }

    @Input
    @NotNull
    public final Property<String> getJavaHome() {
        return this.javaHome;
    }

    @Input
    @NotNull
    public final Property<String> getMainClass() {
        return this.mainClass;
    }

    @Internal
    @NotNull
    public final Property<String> getMaxHeapSize() {
        return this.maxHeapSize;
    }

    @OutputDirectory
    @NotNull
    public final DirectoryProperty getDestinationDir() {
        return this.destinationDir;
    }

    @LocalState
    @NotNull
    protected final Provider<Directory> getWorkingDir() {
        return this.workingDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @TaskAction
    public final void execute() {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Object configFile2;
        Object inputFile2;
        File javaHome = new File((String)this.javaHome.get());
        Provider[] providerArray = new Provider[]{this.destinationDir, this.workingDir};
        org.jetbrains.compose.internal.utils.FileUtilsKt.clearDirs(this.getFileOperations(), providerArray);
        File destinationDir = org.jetbrains.compose.internal.utils.FileUtilsKt.getIoFile((Provider)this.destinationDir).getAbsoluteFile();
        List jmods2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)FilesKt.resolve((File)javaHome, (String)"jmods"), null, (int)1, null)), (Function1)execute.jmods.1.INSTANCE));
        LinkedHashMap<Comparable<File>, File> inputToOutputJars = new LinkedHashMap<Comparable<File>, File>();
        ((Map)inputToOutputJars).put(org.jetbrains.compose.internal.utils.FileUtilsKt.getIoFile((Provider)this.mainJar), org.jetbrains.compose.internal.utils.FileUtilsKt.getIoFile(this.mainJarInDestinationDir));
        for (Object inputFile2 : this.inputFiles) {
            String string = ((File)inputFile2).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"inputFile.name");
            if (StringsKt.endsWith((String)string, (String)".jar", (boolean)true)) {
                Intrinsics.checkNotNullExpressionValue((Object)destinationDir, (String)"destinationDir");
                Intrinsics.checkNotNullExpressionValue((Object)inputFile2, (String)"inputFile");
                inputToOutputJars.putIfAbsent((Comparable<File>)inputFile2, FilesKt.resolve((File)destinationDir, (String)FileUtilsKt.mangledName(inputFile2)));
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)inputFile2, (String)"inputFile");
            Intrinsics.checkNotNullExpressionValue((Object)destinationDir, (String)"destinationDir");
            String string2 = ((File)inputFile2).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"inputFile.name");
            FilesKt.copyTo$default(inputFile2, (File)FilesKt.resolve((File)destinationDir, (String)string2), (boolean)false, (int)0, (int)6, null);
        }
        Provider<RegularFile> provider = this.jarsConfigurationFile;
        Intrinsics.checkNotNullExpressionValue(provider, (String)"jarsConfigurationFile");
        Object object2 = org.jetbrains.compose.internal.utils.FileUtilsKt.getIoFile(provider);
        inputFile2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object2;
        object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)inputFile2);
        object2 = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
        inputFile2 = null;
        try {
            BufferedWriter writer4 = (BufferedWriter)object2;
            boolean bl = false;
            boolean toSingleOutputJar = Intrinsics.areEqual((Object)this.joinOutputJars.getOrNull(), (Object)true);
            for (Map.Entry entry : inputToOutputJars.entrySet()) {
                Intrinsics.checkNotNullExpressionValue(entry, (String)"inputToOutputJars.entries");
                File input = (File)entry.getKey();
                File output = (File)entry.getValue();
                Writer writer2 = writer4;
                Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
                this.writeLn(writer2, "-injars '" + FileUtilsKt.normalizedPath$default(input, null, 1, null) + "'");
                if (toSingleOutputJar) continue;
                Writer writer3 = writer4;
                Intrinsics.checkNotNullExpressionValue((Object)output, (String)"output");
                this.writeLn(writer3, "-outjars '" + FileUtilsKt.normalizedPath$default(output, null, 1, null) + "'");
            }
            if (toSingleOutputJar) {
                this.writeLn(writer4, "-outjars '" + FileUtilsKt.normalizedPath$default(org.jetbrains.compose.internal.utils.FileUtilsKt.getIoFile(this.mainJarInDestinationDir), null, 1, null) + "'");
            }
            for (File jmod : jmods2) {
                this.writeLn(writer4, "-libraryjars '" + FileUtilsKt.normalizedPath$default(jmod, null, 1, null) + "'(!**.jar;!module-info.class)");
            }
            writer4 = Unit.INSTANCE;
        }
        catch (Throwable writer4) {
            try {
                inputFile2 = writer4;
                throw writer4;
            }
            catch (Throwable writer4) {
                CloseableKt.closeFinally((Closeable)object2, inputFile2);
                throw writer4;
            }
        }
        CloseableKt.closeFinally((Closeable)object2, (Throwable)inputFile2);
        Provider<RegularFile> provider2 = this.rootConfigurationFile;
        Intrinsics.checkNotNullExpressionValue(provider2, (String)"rootConfigurationFile");
        object2 = org.jetbrains.compose.internal.utils.FileUtilsKt.getIoFile(provider2);
        inputFile2 = Charsets.UTF_8;
        int writer4 = 8192;
        Object bl = object2;
        bl = new OutputStreamWriter((OutputStream)new FileOutputStream((File)bl), (Charset)inputFile2);
        object2 = bl instanceof BufferedWriter ? (BufferedWriter)bl : new BufferedWriter((Writer)bl, writer4);
        inputFile2 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object2;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)this.dontobfuscate.getOrNull(), (Object)true)) {
                this.writeLn(writer, "-dontobfuscate");
            }
            if (Intrinsics.areEqual((Object)this.dontoptimize.getOrNull(), (Object)true)) {
                this.writeLn(writer, "-dontoptimize");
            }
            this.writeLn(writer, StringsKt.trimIndent((String)("\n                -keep public class " + this.mainClass.get() + " {\n                    public static void main(java.lang.String[]);\n                }\n            ")));
            File[] toSingleOutputJar = new File[2];
            Provider<RegularFile> provider3 = this.jarsConfigurationFile;
            Intrinsics.checkNotNullExpressionValue(provider3, (String)"jarsConfigurationFile");
            toSingleOutputJar[0] = org.jetbrains.compose.internal.utils.FileUtilsKt.getIoFile(provider3);
            toSingleOutputJar[1] = org.jetbrains.compose.internal.utils.FileUtilsKt.getIoFile((Provider)this.defaultComposeRulesFile);
            Sequence sequence = SequencesKt.sequenceOf((Object[])toSingleOutputJar);
            Set set = this.configurationFiles.getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"configurationFiles.files");
            Sequence includeFiles = SequencesKt.plus((Sequence)sequence, (Sequence)CollectionsKt.asSequence((Iterable)set));
            for (Object configFile2 : SequencesKt.filterNotNull((Sequence)includeFiles)) {
                this.writeLn(writer, "-include '" + FileUtilsKt.normalizedPath$default((File)configFile2, null, 1, null) + "'");
            }
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            inputFile2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)inputFile2);
        }
        File javaBinary = OsUtilsKt.jvmToolFile("java", javaHome);
        Object $this$execute_u24lambda_u246 = object = new ArrayList();
        boolean bl3 = false;
        String maxHeapSize = (String)this.maxHeapSize.getOrNull();
        if (maxHeapSize != null) {
            ((ArrayList)$this$execute_u24lambda_u246).add("-Xmx:" + maxHeapSize);
        }
        configFile2 = (Iterable)this.proguardFiles;
        String string = "-cp";
        Collection collection2 = (Collection)$this$execute_u24lambda_u246;
        boolean $i$f$map = false;
        void var15_28 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            collection.add(FileUtilsKt.normalizedPath$default((File)it, null, 1, null));
        }
        collection = (List)destination$iv$iv;
        Iterable iterable = collection;
        String string3 = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"pathSeparator");
        CliArgUtilsKt.cliArg$default(collection2, string, CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string3, null, null, (int)0, null, null, (int)62, null), null, 4, null);
        ((ArrayList)$this$execute_u24lambda_u246).add("proguard.ProGuard");
        CliArgUtilsKt.cliArg$default((Collection)$this$execute_u24lambda_u246, "-verbose", (Provider)this.getVerbose(), null, 4, null);
        Collection collection3 = (Collection)$this$execute_u24lambda_u246;
        Provider<RegularFile> provider4 = this.rootConfigurationFile;
        Intrinsics.checkNotNullExpressionValue(provider4, (String)"rootConfigurationFile");
        CliArgUtilsKt.cliArg$default(collection3, "-include", provider4, null, 4, null);
        Object args2 = object;
        ExternalToolRunner.invoke$default(this.getRunExternalTool$compose(), javaBinary, (Collection)args2, MapsKt.emptyMap(), null, false, null, ExternalToolRunner.LogToConsole.Always, null, 184, null).assertNormalExitValue();
    }

    private final void writeLn(Writer $this$writeLn, String s) {
        $this$writeLn.write(s);
        $this$writeLn.write("\n");
    }

    private static final Provider mainJarInDestinationDir$lambda$0(Function1 $tmp0, Object in) {
        return (Provider)$tmp0.invoke(in);
    }

    private static final RegularFile rootConfigurationFile$lambda$1(Function1 $tmp0, Object in) {
        return (RegularFile)$tmp0.invoke(in);
    }

    private static final RegularFile jarsConfigurationFile$lambda$2(Function1 $tmp0, Object in) {
        return (RegularFile)$tmp0.invoke(in);
    }
}

