/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.ui.tooling.preview.rpc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.CommandsKt;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.ConfigFromGradle;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.FrameConfig;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.FrameRequest;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewHostConfig;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewListener;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewLogger;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewManager;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PreviewManagerImpl;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.PrintStreamLogger;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RemoteConnection;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RemoteConnectionImpl;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RemotePreviewHostKt;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RenderedFrame;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RunningPreview;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.UtilsKt;
import org.jetbrains.compose.desktop.ui.tooling.preview.rpc.utils.RingBuffer;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010(\u001a\u00020)H\u0016J\u001f\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u00172\f\u0010,\u001a\b\u0012\u0004\u0012\u00020)0-H\u0082\bJ\u0010\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020\u0017H\u0002J\u0010\u0010.\u001a\u00020)2\u0006\u00100\u001a\u000201H\u0002J+\u00102\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020\u00172\b\b\u0002\u00103\u001a\u0002042\u000e\b\u0004\u00105\u001a\b\u0012\u0004\u0012\u00020)0-H\u0082\bJ\u001a\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020\u0017H\u0002J\u0010\u0010:\u001a\u00020)2\u0006\u0010;\u001a\u00020\u001aH\u0016J\"\u0010<\u001a\u00020)2\u0017\u00105\u001a\u0013\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020)0=\u00a2\u0006\u0002\b>H\u0082\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010$\u001a\u0012\u0012\u0004\u0012\u00020\u000e0%j\b\u0012\u0004\u0012\u00020\u000e`&X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewManagerImpl;", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewManager;", "previewListener", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewListener;", "(Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewListener;)V", "connectionNumber", "Ljava/util/concurrent/atomic/AtomicLong;", "gradleCallbackPort", "", "getGradleCallbackPort", "()I", "gradleCallbackSocket", "Ljava/net/ServerSocket;", "gradleCallbackThread", "Ljava/lang/Thread;", "inProcessRequest", "Ljava/util/concurrent/atomic/AtomicReference;", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/FrameRequest;", "isAlive", "Ljava/util/concurrent/atomic/AtomicBoolean;", "log", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PrintStreamLogger;", "previewClasspath", "", "previewFqName", "previewFrameConfig", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/FrameConfig;", "previewHostConfig", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewHostConfig;", "previewSocket", "processedRequest", "receivePreviewResponseThread", "runPreviewThread", "runningPreview", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/RunningPreview;", "sendPreviewRequestThread", "threads", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "userRequestCount", "close", "", "closeService", "name", "doClose", "Lkotlin/Function0;", "onError", "error", "e", "", "repeatWhileAliveThread", "sleepDelayMs", "", "fn", "tryAcceptConnection", "Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/RemoteConnection;", "serverSocket", "socketType", "updateFrameConfig", "frameConfig", "withLivePreviewConnection", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "preview-rpc"})
@SourceDebugExtension(value={"SMAP\nPreviewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewManager.kt\norg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewManagerImpl\n+ 2 PreviewLogger.kt\norg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewLogger\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,309:1\n279#1,20:310\n279#1,20:330\n279#1,20:350\n279#1,20:370\n228#1,2:390\n230#1:396\n231#1:399\n228#1,2:402\n230#1:408\n231#1,2:411\n233#1,3:414\n237#1:419\n228#1,2:420\n230#1:426\n231#1,2:429\n233#1,3:432\n237#1:444\n228#1,2:445\n230#1:451\n231#1,2:454\n233#1,3:457\n237#1:469\n228#1,2:470\n230#1:476\n231#1:479\n232#1:483\n233#1,3:485\n237#1:497\n228#1,2:498\n230#1:504\n231#1:507\n232#1:512\n233#1:514\n234#1,2:519\n237#1:530\n232#1:531\n233#1,3:533\n237#1:538\n12#2,4:392\n12#2,4:404\n18#2,2:417\n12#2,4:422\n18#2:435\n12#2,8:436\n12#2,4:447\n18#2:460\n12#2,8:461\n12#2,4:472\n18#2:488\n12#2,8:489\n12#2,4:500\n12#2,4:508\n12#2,4:515\n18#2:521\n12#2,8:522\n18#2,2:536\n12#2,4:539\n12#2,4:546\n18#2:550\n12#2,8:551\n18#2:559\n12#2,8:560\n18#2:568\n12#2,8:569\n29#3,2:397\n29#3,2:409\n31#3:413\n29#3,2:427\n31#3:431\n29#3,2:452\n31#3:456\n29#3,2:477\n31#3:484\n29#3,2:505\n31#3:513\n31#3:532\n29#3,3:543\n1869#4,2:400\n774#4:480\n865#4,2:481\n*S KotlinDebug\n*F\n+ 1 PreviewManager.kt\norg/jetbrains/compose/desktop/ui/tooling/preview/rpc/PreviewManagerImpl\n*L\n73#1:310,20\n132#1:330,20\n151#1:350,20\n171#1:370,20\n189#1:390,2\n189#1:396\n189#1:399\n195#1:402,2\n195#1:408\n195#1:411,2\n195#1:414,3\n195#1:419\n196#1:420,2\n196#1:426\n196#1:429,2\n196#1:432,3\n196#1:444\n197#1:445,2\n197#1:451\n197#1:454,2\n197#1:457,3\n197#1:469\n198#1:470,2\n198#1:476\n198#1:479\n198#1:483\n198#1:485,3\n198#1:497\n215#1:498,2\n215#1:504\n215#1:507\n215#1:512\n215#1:514\n215#1:519,2\n215#1:530\n189#1:531\n189#1:533,3\n189#1:538\n189#1:392,4\n195#1:404,4\n195#1:417,2\n196#1:422,4\n196#1:435\n196#1:436,8\n197#1:447,4\n197#1:460\n197#1:461,8\n198#1:472,4\n198#1:488\n198#1:489,8\n215#1:500,4\n218#1:508,4\n215#1:515,4\n215#1:521\n215#1:522,8\n189#1:536,2\n229#1:539,4\n233#1:546,4\n235#1:550\n235#1:551,8\n263#1:559\n263#1:560,8\n305#1:568\n305#1:569,8\n189#1:397,2\n195#1:409,2\n195#1:413\n196#1:427,2\n196#1:431\n197#1:452,2\n197#1:456\n198#1:477,2\n198#1:484\n215#1:505,2\n215#1:513\n189#1:532\n230#1:543,3\n193#1:400,2\n210#1:480\n210#1:481,2\n*E\n"})
public final class PreviewManagerImpl
implements PreviewManager {
    @NotNull
    private final PreviewListener previewListener;
    @NotNull
    private final PrintStreamLogger log;
    @NotNull
    private final ServerSocket previewSocket;
    @NotNull
    private final ServerSocket gradleCallbackSocket;
    @NotNull
    private final AtomicLong connectionNumber;
    @NotNull
    private final AtomicBoolean isAlive;
    @NotNull
    private final AtomicReference<PreviewHostConfig> previewHostConfig;
    @NotNull
    private final AtomicReference<String> previewClasspath;
    @NotNull
    private final AtomicReference<String> previewFqName;
    @NotNull
    private final AtomicReference<FrameConfig> previewFrameConfig;
    @NotNull
    private final AtomicReference<FrameRequest> inProcessRequest;
    @NotNull
    private final AtomicReference<FrameRequest> processedRequest;
    @NotNull
    private final AtomicLong userRequestCount;
    @NotNull
    private final AtomicReference<RunningPreview> runningPreview;
    @NotNull
    private final ArrayList<Thread> threads;
    @NotNull
    private final Thread runPreviewThread;
    @NotNull
    private final Thread sendPreviewRequestThread;
    @NotNull
    private final Thread receivePreviewResponseThread;
    @NotNull
    private final Thread gradleCallbackThread;

    public PreviewManagerImpl(@NotNull PreviewListener previewListener) {
        Thread thread;
        Intrinsics.checkNotNullParameter((Object)previewListener, (String)"previewListener");
        this.previewListener = previewListener;
        this.log = new PrintStreamLogger("SERVER", null, 2, null);
        this.previewSocket = UtilsKt.newServerSocket();
        this.gradleCallbackSocket = UtilsKt.newServerSocket();
        this.connectionNumber = new AtomicLong(0L);
        this.isAlive = new AtomicBoolean(true);
        this.previewHostConfig = new AtomicReference<Object>(null);
        this.previewClasspath = new AtomicReference<Object>(null);
        this.previewFqName = new AtomicReference<Object>(null);
        this.previewFrameConfig = new AtomicReference<Object>(null);
        this.inProcessRequest = new AtomicReference<Object>(null);
        this.processedRequest = new AtomicReference<Object>(null);
        this.userRequestCount = new AtomicLong(0L);
        this.runningPreview = new AtomicReference<Object>(null);
        this.threads = new ArrayList();
        String name$iv = "runPreview";
        long sleepDelayMs$iv = 1000L;
        boolean $i$f$repeatWhileAliveThread = false;
        Thread it$iv = thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)name$iv, (int)0, (Function0)((Function0)new Function0<Unit>(this, sleepDelayMs$iv, this){
            final /* synthetic */ PreviewManagerImpl this$0$inline_fun;
            final /* synthetic */ long $sleepDelayMs;
            final /* synthetic */ PreviewManagerImpl this$0;
            {
                this.this$0$inline_fun = $receiver;
                this.$sleepDelayMs = $sleepDelayMs;
                this.this$0 = previewManagerImpl;
                super(0);
            }

            public final void invoke() {
                while (PreviewManagerImpl.access$isAlive$p(this.this$0$inline_fun).get()) {
                    try {
                        boolean bl = false;
                        RunningPreview runningPreview = (RunningPreview)PreviewManagerImpl.access$getRunningPreview$p(this.this$0).get();
                        PreviewHostConfig previewConfig = (PreviewHostConfig)PreviewManagerImpl.access$getPreviewHostConfig$p(this.this$0).get();
                        if (previewConfig != null) {
                            RunningPreview runningPreview2 = runningPreview;
                            if (!(runningPreview2 != null ? runningPreview2.isAlive() : false)) {
                                InputStream inputStream;
                                RemoteConnection connection2;
                                Process process = PreviewManagerImpl.access$runPreviewThread$lambda$2$startPreviewProcess(this.this$0, previewConfig);
                                RemoteConnection remoteConnection = connection2 = PreviewManagerImpl.access$tryAcceptConnection(this.this$0, PreviewManagerImpl.access$getPreviewSocket$p(this.this$0), "PREVIEW");
                                if (remoteConnection != null) {
                                    CommandsKt.receiveAttach(remoteConnection, PreviewManagerImpl.access$getPreviewListener$p(this.this$0), (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, connection2, process){
                                        final /* synthetic */ PreviewManagerImpl this$0;
                                        final /* synthetic */ RemoteConnection $connection;
                                        final /* synthetic */ Process $process;
                                        {
                                            this.this$0 = $receiver;
                                            this.$connection = $connection;
                                            this.$process = $process;
                                            super(0);
                                        }

                                        public final void invoke() {
                                            PreviewManagerImpl.access$getRunningPreview$p(this.this$0).set(new RunningPreview(this.$connection, this.$process));
                                        }
                                    }));
                                }
                                RingBuffer<String> processLogLines = new RingBuffer<String>(512);
                                StringBuilder exception = new StringBuilder();
                                Ref.BooleanRef exceptionMarker = new Ref.BooleanRef();
                                Intrinsics.checkNotNullExpressionValue((Object)process.getInputStream(), (String)"process.inputStream");
                                Charset charset = Charsets.UTF_8;
                                Object object = new InputStreamReader(inputStream, charset);
                                int n = 8192;
                                TextStreamsKt.forEachLine((Reader)(object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n)), (Function1)((Function1)new Function1<String, Unit>(exceptionMarker, exception, processLogLines){
                                    final /* synthetic */ Ref.BooleanRef $exceptionMarker;
                                    final /* synthetic */ StringBuilder $exception;
                                    final /* synthetic */ RingBuffer<String> $processLogLines;
                                    {
                                        this.$exceptionMarker = $exceptionMarker;
                                        this.$exception = $exception;
                                        this.$processLogLines = $processLogLines;
                                        super(1);
                                    }

                                    public final void invoke(String line) {
                                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                                        if (this.$exceptionMarker.element) {
                                            this.$exception.append(line).append('\n');
                                        } else if (StringsKt.startsWith$default((String)line, (String)"<!--START OF COMPOSE PREVIEW PROCESS FATAL EXCEPTION--!>", (boolean)false, (int)2, null)) {
                                            this.$exceptionMarker.element = true;
                                        } else {
                                            this.$processLogLines.add(line);
                                        }
                                    }
                                }));
                                while (process.isAlive()) {
                                    process.waitFor(5L, TimeUnit.SECONDS);
                                    if (!process.isAlive()) continue;
                                    process.destroyForcibly();
                                    process.waitFor(5L, TimeUnit.SECONDS);
                                }
                                if (process.isAlive()) {
                                    throw new IllegalStateException("Preview process does not finish!".toString());
                                }
                                int exitCode = process.exitValue();
                                if (exitCode != 0) {
                                    Object $this$runPreviewThread_u24lambda_u242_u24lambda_u241 = object = new StringBuilder();
                                    boolean bl2 = false;
                                    ((StringBuilder)$this$runPreviewThread_u24lambda_u242_u24lambda_u241).append("Preview process exited unexpectedly: exitCode=" + exitCode).append('\n');
                                    if (exceptionMarker.element) {
                                        StringBuilder stringBuilder = ((StringBuilder)$this$runPreviewThread_u24lambda_u242_u24lambda_u241).append((CharSequence)exception);
                                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
                                        stringBuilder.append('\n');
                                    }
                                    String errorMessage = ((StringBuilder)object).toString();
                                    PreviewManagerImpl.access$onError(this.this$0, errorMessage);
                                }
                            }
                        }
                        Thread.sleep(this.$sleepDelayMs);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }), (int)22, null);
        boolean bl = false;
        it$iv.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(this){
            final /* synthetic */ PreviewManagerImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final void uncaughtException(Thread thread, Throwable e) {
                Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
                PreviewManagerImpl.access$onError(this.this$0, e);
            }
        });
        this.threads.add(it$iv);
        it$iv.start();
        this.runPreviewThread = thread;
        name$iv = "sendPreviewRequest";
        sleepDelayMs$iv = 1000L;
        $i$f$repeatWhileAliveThread = false;
        it$iv = thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)name$iv, (int)0, (Function0)((Function0)new Function0<Unit>(this, sleepDelayMs$iv, this){
            final /* synthetic */ PreviewManagerImpl this$0$inline_fun;
            final /* synthetic */ long $sleepDelayMs;
            final /* synthetic */ PreviewManagerImpl this$0;
            {
                this.this$0$inline_fun = $receiver;
                this.$sleepDelayMs = $sleepDelayMs;
                this.this$0 = previewManagerImpl;
                super(0);
            }

            public final void invoke() {
                while (PreviewManagerImpl.access$isAlive$p(this.this$0$inline_fun).get()) {
                    try {
                        RunningPreview runningPreview;
                        boolean bl = false;
                        PreviewManagerImpl this_$iv = this.this$0;
                        boolean $i$f$withLivePreviewConnection = false;
                        RunningPreview runningPreview2 = runningPreview = (RunningPreview)PreviewManagerImpl.access$getRunningPreview$p(this_$iv).get();
                        if (runningPreview2 != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)runningPreview2, (String)"runningPreview.get() ?: return");
                            RunningPreview runningPreview$iv = runningPreview;
                            if (runningPreview$iv.isAlive()) {
                                RemoteConnection $this$sendPreviewRequestThread_u24lambda_u244_u24lambda_u243 = runningPreview$iv.getConnection();
                                boolean bl2 = false;
                                String classpath = (String)PreviewManagerImpl.access$getPreviewClasspath$p(this.this$0).get();
                                String fqName = (String)PreviewManagerImpl.access$getPreviewFqName$p(this.this$0).get();
                                FrameConfig frameConfig = (FrameConfig)PreviewManagerImpl.access$getPreviewFrameConfig$p(this.this$0).get();
                                if (classpath != null && frameConfig != null && fqName != null) {
                                    FrameRequest request = new FrameRequest(PreviewManagerImpl.access$getUserRequestCount$p(this.this$0).get(), fqName, frameConfig);
                                    FrameRequest prevRequest = (FrameRequest)PreviewManagerImpl.access$getProcessedRequest$p(this.this$0).get();
                                    if (PreviewManagerImpl.access$getInProcessRequest$p(this.this$0).get() == null && !Intrinsics.areEqual((Object)request, (Object)prevRequest) && PreviewManagerImpl.access$getInProcessRequest$p(this.this$0).compareAndSet(null, request)) {
                                        PreviewManagerImpl.access$getPreviewListener$p(this.this$0).onNewRenderRequest(request);
                                        CommandsKt.sendPreviewRequest($this$sendPreviewRequestThread_u24lambda_u244_u24lambda_u243, classpath, request);
                                    }
                                }
                            }
                        }
                        Thread.sleep(this.$sleepDelayMs);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }), (int)22, null);
        bl = false;
        it$iv.setUncaughtExceptionHandler(new /* invalid duplicate definition of identical inner class */);
        this.threads.add(it$iv);
        it$iv.start();
        this.sendPreviewRequestThread = thread;
        name$iv = "receivePreviewResponse";
        sleepDelayMs$iv = 1000L;
        $i$f$repeatWhileAliveThread = false;
        it$iv = thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)name$iv, (int)0, (Function0)((Function0)new Function0<Unit>(this, sleepDelayMs$iv, this){
            final /* synthetic */ PreviewManagerImpl this$0$inline_fun;
            final /* synthetic */ long $sleepDelayMs;
            final /* synthetic */ PreviewManagerImpl this$0;
            {
                this.this$0$inline_fun = $receiver;
                this.$sleepDelayMs = $sleepDelayMs;
                this.this$0 = previewManagerImpl;
                super(0);
            }

            public final void invoke() {
                while (PreviewManagerImpl.access$isAlive$p(this.this$0$inline_fun).get()) {
                    try {
                        RunningPreview runningPreview;
                        boolean bl = false;
                        PreviewManagerImpl this_$iv = this.this$0;
                        boolean $i$f$withLivePreviewConnection = false;
                        RunningPreview runningPreview2 = runningPreview = (RunningPreview)PreviewManagerImpl.access$getRunningPreview$p(this_$iv).get();
                        if (runningPreview2 != null) {
                            Intrinsics.checkNotNullExpressionValue((Object)runningPreview2, (String)"runningPreview.get() ?: return");
                            RunningPreview runningPreview$iv = runningPreview;
                            if (runningPreview$iv.isAlive()) {
                                RemoteConnection $this$receivePreviewResponseThread_u24lambda_u246_u24lambda_u245 = runningPreview$iv.getConnection();
                                boolean bl2 = false;
                                CommandsKt.receiveFrame($this$receivePreviewResponseThread_u24lambda_u246_u24lambda_u245, (Function1<? super RenderedFrame, Unit>)((Function1)new Function1<RenderedFrame, Unit>(this.this$0){
                                    final /* synthetic */ PreviewManagerImpl this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(RenderedFrame renderedFrame) {
                                        Intrinsics.checkNotNullParameter((Object)renderedFrame, (String)"renderedFrame");
                                        FrameRequest frameRequest = (FrameRequest)PreviewManagerImpl.access$getInProcessRequest$p(this.this$0).get();
                                        if (frameRequest != null) {
                                            FrameRequest frameRequest2 = frameRequest;
                                            PreviewManagerImpl previewManagerImpl = this.this$0;
                                            FrameRequest request = frameRequest2;
                                            boolean bl = false;
                                            PreviewManagerImpl.access$getProcessedRequest$p(previewManagerImpl).set(request);
                                            PreviewManagerImpl.access$getInProcessRequest$p(previewManagerImpl).compareAndSet(request, null);
                                        }
                                        PreviewManagerImpl.access$getPreviewListener$p(this.this$0).onRenderedFrame(renderedFrame);
                                    }
                                }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this.this$0){
                                    final /* synthetic */ PreviewManagerImpl this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(String error) {
                                        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                                        PreviewManagerImpl.access$getPreviewHostConfig$p(this.this$0).set(null);
                                        PreviewManagerImpl.access$getPreviewClasspath$p(this.this$0).set(null);
                                        PreviewManagerImpl.access$getInProcessRequest$p(this.this$0).set(null);
                                        PreviewManagerImpl.access$onError(this.this$0, error);
                                    }
                                }));
                            }
                        }
                        Thread.sleep(this.$sleepDelayMs);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }), (int)22, null);
        bl = false;
        it$iv.setUncaughtExceptionHandler(new /* invalid duplicate definition of identical inner class */);
        this.threads.add(it$iv);
        it$iv.start();
        this.receivePreviewResponseThread = thread;
        name$iv = "gradleCallback";
        sleepDelayMs$iv = 1000L;
        $i$f$repeatWhileAliveThread = false;
        it$iv = thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)name$iv, (int)0, (Function0)((Function0)new Function0<Unit>(this, sleepDelayMs$iv, this){
            final /* synthetic */ PreviewManagerImpl this$0$inline_fun;
            final /* synthetic */ long $sleepDelayMs;
            final /* synthetic */ PreviewManagerImpl this$0;
            {
                this.this$0$inline_fun = $receiver;
                this.$sleepDelayMs = $sleepDelayMs;
                this.this$0 = previewManagerImpl;
                super(0);
            }

            public final void invoke() {
                while (PreviewManagerImpl.access$isAlive$p(this.this$0$inline_fun).get()) {
                    try {
                        boolean bl = false;
                        if (PreviewManagerImpl.access$tryAcceptConnection(this.this$0, PreviewManagerImpl.access$getGradleCallbackSocket$p(this.this$0), "GRADLE_CALLBACK") != null) {
                            RemoteConnection connection2;
                            boolean bl2 = false;
                            while (PreviewManagerImpl.access$isAlive$p(this.this$0).get() && connection2.isAlive()) {
                                ConfigFromGradle config = CommandsKt.receiveConfigFromGradle(connection2);
                                if (config == null) continue;
                                PreviewManagerImpl.access$getPreviewClasspath$p(this.this$0).set(config.getPreviewClasspath());
                                PreviewManagerImpl.access$getPreviewFqName$p(this.this$0).set(config.getPreviewFqName());
                                PreviewManagerImpl.access$getPreviewHostConfig$p(this.this$0).set(config.getPreviewHostConfig());
                                PreviewManagerImpl.access$getUserRequestCount$p(this.this$0).incrementAndGet();
                                PreviewManagerImpl.access$getSendPreviewRequestThread$p(this.this$0).interrupt();
                            }
                        }
                        Thread.sleep(this.$sleepDelayMs);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }), (int)22, null);
        bl = false;
        it$iv.setUncaughtExceptionHandler(new /* invalid duplicate definition of identical inner class */);
        this.threads.add(it$iv);
        it$iv.start();
        this.gradleCallbackThread = thread;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        block39: {
            void this_$iv;
            if (!this.isAlive.compareAndSet(true, false)) {
                return;
            }
            PreviewManagerImpl previewManagerImpl = this;
            String name$iv = "PREVIEW MANAGER";
            boolean $i$f$closeService = false;
            try {
                long start$iv$iv;
                PreviewLogger previewLogger;
                block38: {
                    long start$iv$iv2;
                    PreviewLogger this_$iv$iv;
                    PreviewManagerImpl this_$iv2;
                    boolean $i$f$closeService2;
                    String name$iv2;
                    Process previewProcess;
                    block37: {
                        block36: {
                            boolean bl;
                            boolean bl2;
                            boolean $i$f$invoke;
                            boolean bl3;
                            long ms$iv;
                            block35: {
                                boolean $i$f$invoke2;
                                block34: {
                                    RunningPreview runningPreview;
                                    PreviewLogger this_$iv$iv2 = this_$iv.log;
                                    boolean $i$f$invoke3 = false;
                                    if (this_$iv$iv2.isEnabled()) {
                                        previewLogger = this_$iv$iv2;
                                        boolean bl4 = false;
                                        previewLogger.log("CLOSING " + name$iv);
                                    }
                                    boolean $i$f$measureTimeMillis = false;
                                    start$iv$iv = System.currentTimeMillis();
                                    boolean bl5 = false;
                                    boolean bl6 = false;
                                    RunningPreview runningPreview2 = runningPreview = (RunningPreview)this.runningPreview.getAndSet(null);
                                    RemoteConnection previewConnection = runningPreview2 != null ? runningPreview2.getConnection() : null;
                                    RunningPreview runningPreview3 = runningPreview;
                                    previewProcess = runningPreview3 != null ? runningPreview3.getProcess() : null;
                                    Object $this$forEach$iv = this.threads;
                                    boolean $i$f$forEach = false;
                                    Iterator iterator2 = $this$forEach$iv.iterator();
                                    while (iterator2.hasNext()) {
                                        Object element$iv = iterator2.next();
                                        Thread it = (Thread)element$iv;
                                        boolean bl7 = false;
                                        it.interrupt();
                                    }
                                    $this$forEach$iv = this;
                                    name$iv2 = "PREVIEW HOST CONNECTION";
                                    $i$f$closeService2 = false;
                                    try {
                                        this_$iv$iv = this_$iv2.log;
                                        boolean $i$f$invoke4 = false;
                                        if (this_$iv$iv.isEnabled()) {
                                            PreviewLogger previewLogger2 = this_$iv$iv;
                                            boolean bl8 = false;
                                            previewLogger2.log("CLOSING " + name$iv2);
                                        }
                                        boolean $i$f$measureTimeMillis2 = false;
                                        start$iv$iv2 = System.currentTimeMillis();
                                        previewLogger4 = false;
                                        boolean bl9 = false;
                                        RemoteConnection remoteConnection = previewConnection;
                                        if (remoteConnection != null) {
                                            remoteConnection.close();
                                        }
                                        ms$iv = System.currentTimeMillis() - start$iv$iv2;
                                        PreviewLogger this_$iv$iv3 = this_$iv2.log;
                                        $i$f$invoke2 = false;
                                        if (this_$iv$iv3.isEnabled()) {
                                            PreviewLogger previewLogger3 = this_$iv$iv3;
                                            bl3 = false;
                                            previewLogger3.log("CLOSED " + name$iv2 + " in " + ms$iv + " ms");
                                        }
                                    }
                                    catch (Exception e$iv) {
                                        PreviewLogger this_$iv$iv4 = this_$iv2.log;
                                        boolean $i$f$error = false;
                                        PreviewLogger this_$iv$iv$iv = this_$iv$iv4;
                                        $i$f$invoke = false;
                                        if (!this_$iv$iv$iv.isEnabled()) break block34;
                                        PreviewLogger previewLogger4 = this_$iv$iv$iv;
                                        bl2 = false;
                                        bl = false;
                                        previewLogger4.log("error: " + ("ERROR CLOSING " + name$iv2 + ": " + UtilsKt.getStackTraceString(e$iv)));
                                    }
                                }
                                this_$iv2 = this;
                                name$iv2 = "PREVIEW SOCKET";
                                $i$f$closeService2 = false;
                                try {
                                    this_$iv$iv = this_$iv2.log;
                                    boolean $i$f$invoke5 = false;
                                    if (this_$iv$iv.isEnabled()) {
                                        PreviewLogger previewLogger5 = this_$iv$iv;
                                        boolean bl10 = false;
                                        previewLogger5.log("CLOSING " + name$iv2);
                                    }
                                    boolean $i$f$measureTimeMillis = false;
                                    start$iv$iv2 = System.currentTimeMillis();
                                    boolean previewLogger4 = false;
                                    boolean bl11 = false;
                                    this.previewSocket.close();
                                    ms$iv = System.currentTimeMillis() - start$iv$iv2;
                                    PreviewLogger this_$iv$iv5 = this_$iv2.log;
                                    $i$f$invoke2 = false;
                                    if (this_$iv$iv5.isEnabled()) {
                                        PreviewLogger previewLogger6 = this_$iv$iv5;
                                        bl3 = false;
                                        previewLogger6.log("CLOSED " + name$iv2 + " in " + ms$iv + " ms");
                                    }
                                }
                                catch (Exception e$iv) {
                                    PreviewLogger this_$iv$iv6 = this_$iv2.log;
                                    boolean $i$f$error = false;
                                    PreviewLogger this_$iv$iv$iv = this_$iv$iv6;
                                    $i$f$invoke = false;
                                    if (!this_$iv$iv$iv.isEnabled()) break block35;
                                    PreviewLogger previewLogger7 = this_$iv$iv$iv;
                                    bl2 = false;
                                    bl = false;
                                    previewLogger7.log("error: " + ("ERROR CLOSING " + name$iv2 + ": " + UtilsKt.getStackTraceString(e$iv)));
                                }
                            }
                            this_$iv2 = this;
                            name$iv2 = "GRADLE SOCKET";
                            $i$f$closeService2 = false;
                            try {
                                this_$iv$iv = this_$iv2.log;
                                boolean $i$f$invoke6 = false;
                                if (this_$iv$iv.isEnabled()) {
                                    PreviewLogger previewLogger8 = this_$iv$iv;
                                    boolean bl12 = false;
                                    previewLogger8.log("CLOSING " + name$iv2);
                                }
                                boolean $i$f$measureTimeMillis = false;
                                start$iv$iv2 = System.currentTimeMillis();
                                boolean bl13 = false;
                                boolean bl14 = false;
                                this.gradleCallbackSocket.close();
                                ms$iv = System.currentTimeMillis() - start$iv$iv2;
                                PreviewLogger this_$iv$iv7 = this_$iv2.log;
                                boolean $i$f$invoke7 = false;
                                if (this_$iv$iv7.isEnabled()) {
                                    PreviewLogger previewLogger9 = this_$iv$iv7;
                                    bl3 = false;
                                    previewLogger9.log("CLOSED " + name$iv2 + " in " + ms$iv + " ms");
                                }
                            }
                            catch (Exception e$iv) {
                                PreviewLogger this_$iv$iv8 = this_$iv2.log;
                                boolean $i$f$error = false;
                                PreviewLogger this_$iv$iv$iv = this_$iv$iv8;
                                $i$f$invoke = false;
                                if (!this_$iv$iv$iv.isEnabled()) break block36;
                                PreviewLogger bl13 = this_$iv$iv$iv;
                                bl2 = false;
                                bl = false;
                                bl13.log("error: " + ("ERROR CLOSING " + name$iv2 + ": " + UtilsKt.getStackTraceString(e$iv)));
                            }
                        }
                        this_$iv2 = this;
                        name$iv2 = "THREADS";
                        $i$f$closeService2 = false;
                        try {
                            void $this$filterTo$iv$iv;
                            this_$iv$iv = this_$iv2.log;
                            boolean $i$f$invoke = false;
                            if (this_$iv$iv.isEnabled()) {
                                PreviewLogger previewLogger10 = this_$iv$iv;
                                boolean bl = false;
                                previewLogger10.log("CLOSING " + name$iv2);
                            }
                            boolean $i$f$measureTimeMillis = false;
                            start$iv$iv2 = System.currentTimeMillis();
                            boolean bl = false;
                            boolean bl15 = false;
                            for (int i2 = 0; i2 < 4; ++i2) {
                                int aliveThreads = 0;
                                for (Thread t : this.threads) {
                                    if (!t.isAlive()) continue;
                                    ++aliveThreads;
                                    t.interrupt();
                                }
                                if (aliveThreads == 0) break;
                                Thread.sleep(300L);
                            }
                            Iterable $this$filter$iv = this.threads;
                            boolean $i$f$filter = false;
                            Iterable t = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                Thread it = (Thread)element$iv$iv;
                                boolean bl16 = false;
                                if (!it.isAlive()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            List aliveThreads = (List)destination$iv$iv;
                            if (!((Collection)aliveThreads).isEmpty()) {
                                throw new IllegalStateException(("Could not stop threads: " + CollectionsKt.joinToString$default((Iterable)aliveThreads, (CharSequence)", ", null, null, (int)0, null, (Function1)close.1.5.1.INSTANCE, (int)30, null)).toString());
                            }
                            long ms$iv = System.currentTimeMillis() - start$iv$iv2;
                            PreviewLogger this_$iv$iv9 = this_$iv2.log;
                            boolean $i$f$invoke8 = false;
                            if (this_$iv$iv9.isEnabled()) {
                                PreviewLogger previewLogger11 = this_$iv$iv9;
                                boolean bl17 = false;
                                previewLogger11.log("CLOSED " + name$iv2 + " in " + ms$iv + " ms");
                            }
                        }
                        catch (Exception e$iv) {
                            PreviewLogger this_$iv$iv10 = this_$iv2.log;
                            boolean $i$f$error = false;
                            PreviewLogger this_$iv$iv$iv = this_$iv$iv10;
                            boolean $i$f$invoke = false;
                            if (!this_$iv$iv$iv.isEnabled()) break block37;
                            PreviewLogger bl = this_$iv$iv$iv;
                            boolean bl18 = false;
                            boolean bl19 = false;
                            bl.log("error: " + ("ERROR CLOSING " + name$iv2 + ": " + UtilsKt.getStackTraceString(e$iv)));
                        }
                    }
                    this_$iv2 = this;
                    name$iv2 = "PREVIEW HOST PROCESS";
                    $i$f$closeService2 = false;
                    try {
                        this_$iv$iv = this_$iv2.log;
                        boolean $i$f$invoke = false;
                        if (this_$iv$iv.isEnabled()) {
                            PreviewLogger previewLogger12 = this_$iv$iv;
                            boolean bl = false;
                            previewLogger12.log("CLOSING " + name$iv2);
                        }
                        boolean $i$f$measureTimeMillis = false;
                        start$iv$iv2 = System.currentTimeMillis();
                        boolean bl = false;
                        boolean bl20 = false;
                        Process process = previewProcess;
                        if (process != null) {
                            Process process2 = process;
                            boolean bl21 = false;
                            if (!process2.waitFor(5L, TimeUnit.SECONDS)) {
                                PreviewLogger this_$iv3 = this.log;
                                boolean $i$f$invoke9 = false;
                                if (this_$iv3.isEnabled()) {
                                    PreviewLogger previewLogger13 = this_$iv3;
                                    boolean bl22 = false;
                                    previewLogger13.log("FORCIBLY DESTROYING PREVIEW HOST PROCESS");
                                }
                                process2.destroyForcibly();
                            }
                        }
                        long ms$iv = System.currentTimeMillis() - start$iv$iv2;
                        PreviewLogger this_$iv$iv11 = this_$iv2.log;
                        boolean $i$f$invoke10 = false;
                        if (this_$iv$iv11.isEnabled()) {
                            PreviewLogger previewLogger14 = this_$iv$iv11;
                            boolean bl23 = false;
                            previewLogger14.log("CLOSED " + name$iv2 + " in " + ms$iv + " ms");
                        }
                    }
                    catch (Exception e$iv) {
                        PreviewLogger this_$iv$iv12 = this_$iv2.log;
                        boolean $i$f$error = false;
                        PreviewLogger this_$iv$iv$iv = this_$iv$iv12;
                        boolean $i$f$invoke = false;
                        if (!this_$iv$iv$iv.isEnabled()) break block38;
                        PreviewLogger previewLogger15 = this_$iv$iv$iv;
                        boolean bl = false;
                        boolean bl24 = false;
                        previewLogger15.log("error: " + ("ERROR CLOSING " + name$iv2 + ": " + UtilsKt.getStackTraceString(e$iv)));
                    }
                }
                long ms$iv = System.currentTimeMillis() - start$iv$iv;
                PreviewLogger this_$iv$iv = this_$iv.log;
                boolean $i$f$invoke = false;
                if (this_$iv$iv.isEnabled()) {
                    previewLogger = this_$iv$iv;
                    boolean bl = false;
                    previewLogger.log("CLOSED " + name$iv + " in " + ms$iv + " ms");
                }
            }
            catch (Exception e$iv) {
                PreviewLogger this_$iv$iv = this_$iv.log;
                boolean $i$f$error = false;
                PreviewLogger this_$iv$iv$iv = this_$iv$iv;
                boolean $i$f$invoke = false;
                if (!this_$iv$iv$iv.isEnabled()) break block39;
                PreviewLogger previewLogger = this_$iv$iv$iv;
                boolean bl = false;
                boolean bl25 = false;
                previewLogger.log("error: " + ("ERROR CLOSING " + name$iv + ": " + UtilsKt.getStackTraceString(e$iv)));
            }
        }
    }

    private final void closeService(String name, Function0<Unit> doClose) {
        block4: {
            boolean $i$f$closeService = false;
            try {
                PreviewLogger previewLogger;
                PreviewLogger this_$iv = this.log;
                boolean $i$f$invoke = false;
                if (this_$iv.isEnabled()) {
                    previewLogger = this_$iv;
                    boolean bl = false;
                    previewLogger.log("CLOSING " + name);
                }
                boolean $i$f$measureTimeMillis = false;
                long start$iv = System.currentTimeMillis();
                boolean bl = false;
                doClose.invoke();
                long ms = System.currentTimeMillis() - start$iv;
                PreviewLogger this_$iv2 = this.log;
                boolean $i$f$invoke2 = false;
                if (this_$iv2.isEnabled()) {
                    previewLogger = this_$iv2;
                    boolean bl2 = false;
                    previewLogger.log("CLOSED " + name + " in " + ms + " ms");
                }
            }
            catch (Exception e) {
                PreviewLogger this_$iv = this.log;
                boolean $i$f$error = false;
                PreviewLogger this_$iv$iv = this_$iv;
                boolean $i$f$invoke = false;
                if (!this_$iv$iv.isEnabled()) break block4;
                PreviewLogger previewLogger = this_$iv$iv;
                boolean bl = false;
                boolean bl3 = false;
                previewLogger.log("error: " + ("ERROR CLOSING " + name + ": " + UtilsKt.getStackTraceString(e)));
            }
        }
    }

    @Override
    public void updateFrameConfig(@NotNull FrameConfig frameConfig) {
        Intrinsics.checkNotNullParameter((Object)frameConfig, (String)"frameConfig");
        this.previewFrameConfig.set(frameConfig);
        this.sendPreviewRequestThread.interrupt();
    }

    @Override
    public int getGradleCallbackPort() {
        return this.gradleCallbackSocket.getLocalPort();
    }

    private final RemoteConnection tryAcceptConnection(ServerSocket serverSocket, String socketType) {
        while (this.isAlive.get()) {
            try {
                Socket socket = serverSocket.accept();
                Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"socket");
                return new RemoteConnectionImpl(socket, new PrintStreamLogger("CONNECTION (" + socketType + ") #" + this.connectionNumber.incrementAndGet(), null, 2, null), (Function0<Unit>)((Function0)tryAcceptConnection.1.INSTANCE));
            }
            catch (IOException e) {
                if (e instanceof SocketTimeoutException || !this.isAlive.get()) continue;
                PreviewLogger this_$iv = this.log;
                boolean $i$f$error = false;
                PreviewLogger this_$iv$iv = this_$iv;
                boolean $i$f$invoke = false;
                if (!this_$iv$iv.isEnabled()) continue;
                PreviewLogger previewLogger = this_$iv$iv;
                boolean bl = false;
                boolean bl2 = false;
                previewLogger.log("error: " + ExceptionsKt.stackTraceToString((Throwable)e));
            }
        }
        return null;
    }

    private final void withLivePreviewConnection(Function1<? super RemoteConnection, Unit> fn) {
        boolean $i$f$withLivePreviewConnection = false;
        RunningPreview runningPreview = (RunningPreview)this.runningPreview.get();
        if (runningPreview == null) {
            return;
        }
        RunningPreview runningPreview2 = runningPreview;
        if (runningPreview2.isAlive()) {
            fn.invoke((Object)runningPreview2.getConnection());
        }
    }

    private final Thread repeatWhileAliveThread(String name, long sleepDelayMs, Function0<Unit> fn) {
        Thread thread;
        boolean $i$f$repeatWhileAliveThread = false;
        Thread it = thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)name, (int)0, (Function0)((Function0)new Function0<Unit>(this, fn, sleepDelayMs){
            final /* synthetic */ PreviewManagerImpl this$0;
            final /* synthetic */ Function0<Unit> $fn;
            final /* synthetic */ long $sleepDelayMs;
            {
                this.this$0 = $receiver;
                this.$fn = $fn;
                this.$sleepDelayMs = $sleepDelayMs;
                super(0);
            }

            public final void invoke() {
                while (PreviewManagerImpl.access$isAlive$p(this.this$0).get()) {
                    try {
                        this.$fn.invoke();
                        Thread.sleep(this.$sleepDelayMs);
                    }
                    catch (InterruptedException e) {}
                }
            }
        }), (int)22, null);
        boolean bl = false;
        it.setUncaughtExceptionHandler(new /* invalid duplicate definition of identical inner class */);
        this.threads.add(it);
        it.start();
        return thread;
    }

    static /* synthetic */ Thread repeatWhileAliveThread$default(PreviewManagerImpl $this, String name, long sleepDelayMs, Function0 fn, int n, Object object) {
        if ((n & 2) != 0) {
            sleepDelayMs = 1000L;
        }
        boolean $i$f$repeatWhileAliveThread = false;
        Object it = object = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)name, (int)0, (Function0)((Function0)new /* invalid duplicate definition of identical inner class */), (int)22, null);
        boolean bl = false;
        ((Thread)it).setUncaughtExceptionHandler(new /* invalid duplicate definition of identical inner class */);
        $this.threads.add(it);
        ((Thread)it).start();
        return object;
    }

    private final void onError(Throwable e) {
        this.onError(UtilsKt.getStackTraceString(e));
    }

    private final void onError(String error) {
        PreviewLogger this_$iv = this.log;
        boolean $i$f$error = false;
        PreviewLogger this_$iv$iv = this_$iv;
        boolean $i$f$invoke = false;
        if (this_$iv$iv.isEnabled()) {
            PreviewLogger previewLogger = this_$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            previewLogger.log("error: " + error);
        }
        this.previewListener.onError(error);
    }

    private static final Process runPreviewThread$lambda$2$startPreviewProcess(PreviewManagerImpl this$0, PreviewHostConfig config) {
        Object object = new String[]{config.getJavaExecutable(), "-Djava.awt.headless=true", "-classpath", config.getHostClasspath(), RemotePreviewHostKt.getPREVIEW_HOST_CLASS_NAME(), String.valueOf(this$0.previewSocket.getLocalPort())};
        Object $this$runPreviewThread_u24lambda_u242_u24startPreviewProcess_u24lambda_u240 = object = new ProcessBuilder((String[])object);
        boolean bl = false;
        ((ProcessBuilder)$this$runPreviewThread_u24lambda_u242_u24startPreviewProcess_u24lambda_u240).redirectOutput(ProcessBuilder.Redirect.PIPE);
        ((ProcessBuilder)$this$runPreviewThread_u24lambda_u242_u24startPreviewProcess_u24lambda_u240).redirectError(ProcessBuilder.Redirect.PIPE);
        ((ProcessBuilder)$this$runPreviewThread_u24lambda_u242_u24startPreviewProcess_u24lambda_u240).redirectErrorStream(true);
        Process process = ((ProcessBuilder)object).start();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"ProcessBuilder(\n        \u2026ue)\n            }.start()");
        return process;
    }

    public static final /* synthetic */ AtomicBoolean access$isAlive$p(PreviewManagerImpl $this) {
        return $this.isAlive;
    }

    public static final /* synthetic */ AtomicReference access$getPreviewHostConfig$p(PreviewManagerImpl $this) {
        return $this.previewHostConfig;
    }

    public static final /* synthetic */ Process access$runPreviewThread$lambda$2$startPreviewProcess(PreviewManagerImpl this$0, PreviewHostConfig config) {
        return PreviewManagerImpl.runPreviewThread$lambda$2$startPreviewProcess(this$0, config);
    }

    public static final /* synthetic */ RemoteConnection access$tryAcceptConnection(PreviewManagerImpl $this, ServerSocket serverSocket, String socketType) {
        return $this.tryAcceptConnection(serverSocket, socketType);
    }

    public static final /* synthetic */ ServerSocket access$getPreviewSocket$p(PreviewManagerImpl $this) {
        return $this.previewSocket;
    }

    public static final /* synthetic */ PreviewListener access$getPreviewListener$p(PreviewManagerImpl $this) {
        return $this.previewListener;
    }

    public static final /* synthetic */ void access$onError(PreviewManagerImpl $this, String error) {
        $this.onError(error);
    }

    public static final /* synthetic */ AtomicReference access$getPreviewClasspath$p(PreviewManagerImpl $this) {
        return $this.previewClasspath;
    }

    public static final /* synthetic */ AtomicReference access$getPreviewFqName$p(PreviewManagerImpl $this) {
        return $this.previewFqName;
    }

    public static final /* synthetic */ AtomicReference access$getPreviewFrameConfig$p(PreviewManagerImpl $this) {
        return $this.previewFrameConfig;
    }

    public static final /* synthetic */ AtomicLong access$getUserRequestCount$p(PreviewManagerImpl $this) {
        return $this.userRequestCount;
    }

    public static final /* synthetic */ AtomicReference access$getProcessedRequest$p(PreviewManagerImpl $this) {
        return $this.processedRequest;
    }

    public static final /* synthetic */ AtomicReference access$getInProcessRequest$p(PreviewManagerImpl $this) {
        return $this.inProcessRequest;
    }

    public static final /* synthetic */ Thread access$getSendPreviewRequestThread$p(PreviewManagerImpl $this) {
        return $this.sendPreviewRequestThread;
    }

    public static final /* synthetic */ ServerSocket access$getGradleCallbackSocket$p(PreviewManagerImpl $this) {
        return $this.gradleCallbackSocket;
    }

    public static final /* synthetic */ void access$onError(PreviewManagerImpl $this, Throwable e) {
        $this.onError(e);
    }
}

