/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.internal;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import org.gradle.api.logging.Logger;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpRequest;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpResponse;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.protocol.HttpContext;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.TimeValue;

public class CustomHttpRequestRetryStrategy
extends DefaultHttpRequestRetryStrategy {
    private final Logger logger;
    private final boolean quiet;
    private final int maxRetries;

    public CustomHttpRequestRetryStrategy(int maxRetries, TimeValue defaultRetryInterval, Logger logger, boolean quiet) {
        super(maxRetries, defaultRetryInterval, Collections.singletonList(UnknownHostException.class), Arrays.asList(429, 503));
        this.logger = logger;
        this.quiet = quiet;
        this.maxRetries = maxRetries;
    }

    private void logRetry(int execCount) {
        if (!this.quiet) {
            this.logger.warn("Request attempt " + execCount + "/" + this.maxRetries + " failed. Retrying ...");
        }
    }

    @Override
    public boolean retryRequest(HttpResponse response, int execCount, HttpContext context) {
        boolean res = super.retryRequest(response, execCount, context);
        if (res) {
            this.logRetry(execCount);
            this.logger.debug("Status code: " + response.getCode());
            this.logger.debug("Status message: " + response.getReasonPhrase());
        }
        return res;
    }

    @Override
    public boolean retryRequest(HttpRequest request, IOException exception, int execCount, HttpContext context) {
        boolean res = super.retryRequest(request, exception, execCount, context);
        if (res) {
            this.logRetry(execCount);
            this.logger.debug("Request attempt failed", (Throwable)exception);
        }
        return res;
    }
}

