/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose;

import java.io.File;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.CheckComposeCompilerPluginKt;
import org.jetbrains.compose.ComposeExtension;
import org.jetbrains.compose.ComposePlugin;
import org.jetbrains.compose.ComposePluginKt;
import org.jetbrains.compose.ExperimentalComposeLibrary;
import org.jetbrains.compose.android.AndroidExtension;
import org.jetbrains.compose.desktop.DesktopExtension;
import org.jetbrains.compose.desktop.application.internal.ConfigureDesktopKt;
import org.jetbrains.compose.desktop.preview.internal.ConfigurePreviewKt;
import org.jetbrains.compose.experimental.dsl.ExperimentalExtension;
import org.jetbrains.compose.experimental.internal.CheckExperimentalTargetsKt;
import org.jetbrains.compose.internal.ProjectExtensionsKt;
import org.jetbrains.compose.resources.ComposeResourcesKt;
import org.jetbrains.compose.resources.ResourcesExtension;
import org.jetbrains.compose.web.WebExtension;
import org.jetbrains.compose.web.internal.ConfigureWebApplicationKt;
import org.jetbrains.kotlin.gradle.dsl.KotlinMultiplatformExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0006\u0007\b\t\n\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/compose/ComposePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "CommonComponentsDependencies", "Dependencies", "DesktopComponentsDependencies", "DesktopDependencies", "HtmlDependencies", "WebDependencies", "compose"})
public abstract class ComposePlugin
implements Plugin<Project> {
    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new Object[]{project};
        ComposeExtension composeExtension = (ComposeExtension)project.getExtensions().create("compose", ComposeExtension.class, objectArray);
        DesktopExtension desktopExtension = (DesktopExtension)composeExtension.getExtensions().create("desktop", DesktopExtension.class, new Object[0]);
        AndroidExtension androidExtension = (AndroidExtension)composeExtension.getExtensions().create("android", AndroidExtension.class, new Object[0]);
        ExperimentalExtension experimentalExtension = (ExperimentalExtension)composeExtension.getExtensions().create("experimental", ExperimentalExtension.class, new Object[0]);
        ResourcesExtension resourcesExtension = (ResourcesExtension)composeExtension.getExtensions().create("resources", ResourcesExtension.class, new Object[0]);
        project.getDependencies().getExtensions().add("compose", (Object)new Dependencies(project));
        File file2 = project.getBuildFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.buildFile");
        if (!FilesKt.endsWith((File)file2, (String)".gradle.kts")) {
            ComposePluginKt.access$setUpGroovyDslExtensions(project);
        }
        Intrinsics.checkNotNullExpressionValue((Object)desktopExtension, (String)"desktopExtension");
        ConfigurePreviewKt.initializePreview(project, desktopExtension);
        composeExtension.getExtensions().create("web", WebExtension.class, new Object[0]);
        CheckComposeCompilerPluginKt.checkComposeCompilerPlugin(project);
        Intrinsics.checkNotNullExpressionValue((Object)resourcesExtension, (String)"resourcesExtension");
        ComposeResourcesKt.configureComposeResources(project, resourcesExtension);
        project.afterEvaluate(arg_0 -> ComposePlugin.apply$lambda$0((Function1)new Function1<Project, Unit>(project, desktopExtension, composeExtension){
            final /* synthetic */ Project $project;
            final /* synthetic */ DesktopExtension $desktopExtension;
            final /* synthetic */ ComposeExtension $composeExtension;
            {
                this.$project = $project;
                this.$desktopExtension = $desktopExtension;
                this.$composeExtension = $composeExtension;
                super(1);
            }

            public final void invoke(Project it) {
                DesktopExtension desktopExtension = this.$desktopExtension;
                Intrinsics.checkNotNullExpressionValue((Object)desktopExtension, (String)"desktopExtension");
                ConfigureDesktopKt.configureDesktop(this.$project, desktopExtension);
                ComposeExtension composeExtension = this.$composeExtension;
                Intrinsics.checkNotNullExpressionValue((Object)composeExtension, (String)"composeExtension");
                ConfigureWebApplicationKt.configureWeb(this.$project, composeExtension);
                this.$project.getPlugins().withId("org.jetbrains.kotlin.multiplatform", arg_0 -> apply.1.invoke$lambda$0((Function1)new Function1<Plugin<?>, Unit>(this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(1);
                    }

                    public final void invoke(Plugin<?> it) {
                        KotlinMultiplatformExtension mppExt = ProjectExtensionsKt.getMppExt(this.$project);
                        CheckExperimentalTargetsKt.configureExperimentalTargetsFlagsCheck(this.$project, mppExt);
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/compose/ComposePlugin$CommonComponentsDependencies;", "", "()V", "resources", "", "getResources", "()Ljava/lang/String;", "uiToolingPreview", "getUiToolingPreview", "compose"})
    public static final class CommonComponentsDependencies {
        @NotNull
        public static final CommonComponentsDependencies INSTANCE = new CommonComponentsDependencies();
        @NotNull
        private static final String resources = ComposePluginKt.access$composeDependency("org.jetbrains.compose.components:components-resources");
        @NotNull
        private static final String uiToolingPreview = ComposePluginKt.access$composeDependency("org.jetbrains.compose.components:components-ui-tooling-preview");

        private CommonComponentsDependencies() {
        }

        @NotNull
        public final String getResources() {
            return resources;
        }

        @NotNull
        public final String getUiToolingPreview() {
            return uiToolingPreview;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\bR\u0011\u0010\u001b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\bR\u0011\u0010\u001d\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\bR\u0011\u0010\u001f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b \u0010\bR\u0011\u0010!\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\bR\u0011\u0010#\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\bR\u0011\u0010%\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\bR\u0011\u0010'\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\bR\u001a\u0010)\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b*\u0010+\u001a\u0004\b,\u0010\bR\u001a\u0010-\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b.\u0010+\u001a\u0004\b/\u0010\bR\u0011\u00100\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\bR\u0011\u00102\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\bR\u001a\u00104\u001a\u0002058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b6\u0010+\u001a\u0004\b7\u00108\u00a8\u00069"}, d2={"Lorg/jetbrains/compose/ComposePlugin$Dependencies;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "animation", "", "getAnimation", "()Ljava/lang/String;", "animationGraphics", "getAnimationGraphics", "components", "Lorg/jetbrains/compose/ComposePlugin$CommonComponentsDependencies;", "getComponents", "()Lorg/jetbrains/compose/ComposePlugin$CommonComponentsDependencies;", "desktop", "Lorg/jetbrains/compose/ComposePlugin$DesktopDependencies;", "getDesktop", "()Lorg/jetbrains/compose/ComposePlugin$DesktopDependencies;", "foundation", "getFoundation", "html", "Lorg/jetbrains/compose/ComposePlugin$HtmlDependencies;", "getHtml", "()Lorg/jetbrains/compose/ComposePlugin$HtmlDependencies;", "material", "getMaterial", "material3", "getMaterial3", "material3AdaptiveNavigationSuite", "getMaterial3AdaptiveNavigationSuite", "materialIconsExtended", "getMaterialIconsExtended", "preview", "getPreview", "runtime", "getRuntime", "runtimeSaveable", "getRuntimeSaveable", "ui", "getUi", "uiTest", "getUiTest$annotations", "()V", "getUiTest", "uiTestJUnit4", "getUiTestJUnit4$annotations", "getUiTestJUnit4", "uiTooling", "getUiTooling", "uiUtil", "getUiUtil", "web", "Lorg/jetbrains/compose/ComposePlugin$WebDependencies;", "getWeb$annotations", "getWeb", "()Lorg/jetbrains/compose/ComposePlugin$WebDependencies;", "compose"})
    public static final class Dependencies {
        @NotNull
        private final DesktopDependencies desktop;

        public Dependencies(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.desktop = DesktopDependencies.INSTANCE;
        }

        @NotNull
        public final DesktopDependencies getDesktop() {
            return this.desktop;
        }

        @NotNull
        public final String getAnimation() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.animation:animation");
        }

        @NotNull
        public final String getAnimationGraphics() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.animation:animation-graphics");
        }

        @NotNull
        public final String getFoundation() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.foundation:foundation");
        }

        @NotNull
        public final String getMaterial() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.material:material");
        }

        @NotNull
        public final String getMaterial3() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.material3:material3");
        }

        @NotNull
        public final String getMaterial3AdaptiveNavigationSuite() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.material3:material3-adaptive-navigation-suite");
        }

        @NotNull
        public final String getRuntime() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.runtime:runtime");
        }

        @NotNull
        public final String getRuntimeSaveable() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.runtime:runtime-saveable");
        }

        @NotNull
        public final String getUi() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.ui:ui");
        }

        @NotNull
        public final String getUiTestJUnit4() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.ui:ui-test-junit4");
        }

        @Deprecated(message="Use desktop.uiTestJUnit4", replaceWith=@ReplaceWith(expression="desktop.uiTestJUnit4", imports={}))
        @ExperimentalComposeLibrary
        public static /* synthetic */ void getUiTestJUnit4$annotations() {
        }

        @NotNull
        public final String getUiTest() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.ui:ui-test");
        }

        @ExperimentalComposeLibrary
        public static /* synthetic */ void getUiTest$annotations() {
        }

        @NotNull
        public final String getUiTooling() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.ui:ui-tooling");
        }

        @NotNull
        public final String getUiUtil() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.ui:ui-util");
        }

        @NotNull
        public final String getPreview() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.ui:ui-tooling-preview");
        }

        @NotNull
        public final String getMaterialIconsExtended() {
            return "org.jetbrains.compose.material:material-icons-extended:1.7.3";
        }

        @NotNull
        public final CommonComponentsDependencies getComponents() {
            return CommonComponentsDependencies.INSTANCE;
        }

        @NotNull
        public final WebDependencies getWeb() {
            return WebDependencies.INSTANCE;
        }

        @Deprecated(message="Use compose.html", replaceWith=@ReplaceWith(expression="html", imports={}))
        public static /* synthetic */ void getWeb$annotations() {
        }

        @NotNull
        public final HtmlDependencies getHtml() {
            return HtmlDependencies.INSTANCE;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/compose/ComposePlugin$DesktopComponentsDependencies;", "", "()V", "animatedImage", "", "getAnimatedImage$annotations", "getAnimatedImage", "()Ljava/lang/String;", "splitPane", "getSplitPane$annotations", "getSplitPane", "compose"})
    public static final class DesktopComponentsDependencies {
        @NotNull
        public static final DesktopComponentsDependencies INSTANCE = new DesktopComponentsDependencies();
        @NotNull
        private static final String splitPane = ComposePluginKt.access$composeDependency("org.jetbrains.compose.components:components-splitpane");
        @NotNull
        private static final String animatedImage = ComposePluginKt.access$composeDependency("org.jetbrains.compose.components:components-animatedimage");

        private DesktopComponentsDependencies() {
        }

        @NotNull
        public final String getSplitPane() {
            return splitPane;
        }

        @ExperimentalComposeLibrary
        public static /* synthetic */ void getSplitPane$annotations() {
        }

        @NotNull
        public final String getAnimatedImage() {
            return animatedImage;
        }

        @ExperimentalComposeLibrary
        public static /* synthetic */ void getAnimatedImage$annotations() {
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/compose/ComposePlugin$DesktopDependencies;", "", "()V", "common", "", "getCommon", "()Ljava/lang/String;", "components", "Lorg/jetbrains/compose/ComposePlugin$DesktopComponentsDependencies;", "getComponents", "()Lorg/jetbrains/compose/ComposePlugin$DesktopComponentsDependencies;", "currentOs", "getCurrentOs", "currentOs$delegate", "Lkotlin/Lazy;", "linux_arm64", "getLinux_arm64", "linux_x64", "getLinux_x64", "macos_arm64", "getMacos_arm64", "macos_x64", "getMacos_x64", "uiTestJUnit4", "getUiTestJUnit4", "windows_arm64", "getWindows_arm64", "windows_x64", "getWindows_x64", "compose"})
    public static final class DesktopDependencies {
        @NotNull
        public static final DesktopDependencies INSTANCE = new DesktopDependencies();
        @NotNull
        private static final DesktopComponentsDependencies components = DesktopComponentsDependencies.INSTANCE;
        @NotNull
        private static final String common = ComposePluginKt.access$composeDependency("org.jetbrains.compose.desktop:desktop");
        @NotNull
        private static final String linux_x64 = ComposePluginKt.access$composeDependency("org.jetbrains.compose.desktop:desktop-jvm-linux-x64");
        @NotNull
        private static final String linux_arm64 = ComposePluginKt.access$composeDependency("org.jetbrains.compose.desktop:desktop-jvm-linux-arm64");
        @NotNull
        private static final String windows_x64 = ComposePluginKt.access$composeDependency("org.jetbrains.compose.desktop:desktop-jvm-windows-x64");
        @NotNull
        private static final String windows_arm64 = ComposePluginKt.access$composeDependency("org.jetbrains.compose.desktop:desktop-jvm-windows-arm64");
        @NotNull
        private static final String macos_x64 = ComposePluginKt.access$composeDependency("org.jetbrains.compose.desktop:desktop-jvm-macos-x64");
        @NotNull
        private static final String macos_arm64 = ComposePluginKt.access$composeDependency("org.jetbrains.compose.desktop:desktop-jvm-macos-arm64");
        @NotNull
        private static final Lazy currentOs$delegate = LazyKt.lazy((Function0)currentOs.2.INSTANCE);

        private DesktopDependencies() {
        }

        @NotNull
        public final DesktopComponentsDependencies getComponents() {
            return components;
        }

        @NotNull
        public final String getCommon() {
            return common;
        }

        @NotNull
        public final String getLinux_x64() {
            return linux_x64;
        }

        @NotNull
        public final String getLinux_arm64() {
            return linux_arm64;
        }

        @NotNull
        public final String getWindows_x64() {
            return windows_x64;
        }

        @NotNull
        public final String getWindows_arm64() {
            return windows_arm64;
        }

        @NotNull
        public final String getMacos_x64() {
            return macos_x64;
        }

        @NotNull
        public final String getMacos_arm64() {
            return macos_arm64;
        }

        @NotNull
        public final String getUiTestJUnit4() {
            return ComposePluginKt.access$composeDependency("org.jetbrains.compose.ui:ui-test-junit4");
        }

        @NotNull
        public final String getCurrentOs() {
            Lazy lazy = currentOs$delegate;
            return (String)lazy.getValue();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006R\u001b\u0010\f\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\b\u001a\u0004\b\r\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/compose/ComposePlugin$HtmlDependencies;", "", "()V", "core", "", "getCore", "()Ljava/lang/String;", "core$delegate", "Lkotlin/Lazy;", "svg", "getSvg", "svg$delegate", "testUtils", "getTestUtils", "testUtils$delegate", "compose"})
    public static final class HtmlDependencies {
        @NotNull
        public static final HtmlDependencies INSTANCE = new HtmlDependencies();
        @NotNull
        private static final Lazy core$delegate = LazyKt.lazy((Function0)core.2.INSTANCE);
        @NotNull
        private static final Lazy svg$delegate = LazyKt.lazy((Function0)svg.2.INSTANCE);
        @NotNull
        private static final Lazy testUtils$delegate = LazyKt.lazy((Function0)testUtils.2.INSTANCE);

        private HtmlDependencies() {
        }

        @NotNull
        public final String getCore() {
            Lazy lazy = core$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getSvg() {
            Lazy lazy = svg$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getTestUtils() {
            Lazy lazy = testUtils$delegate;
            return (String)lazy.getValue();
        }
    }

    @Deprecated(message="Use compose.html")
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\t\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\b\u001a\u0004\b\n\u0010\u0006R\u001b\u0010\f\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\b\u001a\u0004\b\r\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/compose/ComposePlugin$WebDependencies;", "", "()V", "core", "", "getCore", "()Ljava/lang/String;", "core$delegate", "Lkotlin/Lazy;", "svg", "getSvg", "svg$delegate", "testUtils", "getTestUtils", "testUtils$delegate", "compose"})
    public static final class WebDependencies {
        @NotNull
        public static final WebDependencies INSTANCE = new WebDependencies();
        @NotNull
        private static final Lazy core$delegate = LazyKt.lazy((Function0)core.2.INSTANCE);
        @NotNull
        private static final Lazy svg$delegate = LazyKt.lazy((Function0)svg.2.INSTANCE);
        @NotNull
        private static final Lazy testUtils$delegate = LazyKt.lazy((Function0)testUtils.2.INSTANCE);

        private WebDependencies() {
        }

        @NotNull
        public final String getCore() {
            Lazy lazy = core$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getSvg() {
            Lazy lazy = svg$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final String getTestUtils() {
            Lazy lazy = testUtils$delegate;
            return (String)lazy.getValue();
        }
    }
}

