/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.ui.tooling.preview.rpc;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.util.Arrays;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/compose/desktop/ui/tooling/preview/rpc/RenderedFrame;", "", "bytes", "", "width", "", "height", "([BII)V", "getBytes", "()[B", "dimension", "Ljava/awt/Dimension;", "getDimension", "()Ljava/awt/Dimension;", "getHeight", "()I", "image", "Ljava/awt/image/BufferedImage;", "getImage", "()Ljava/awt/image/BufferedImage;", "getWidth", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "preview-rpc"})
@SourceDebugExtension(value={"SMAP\nRenderedFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderedFrame.kt\norg/jetbrains/compose/desktop/ui/tooling/preview/rpc/RenderedFrame\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class RenderedFrame {
    @NotNull
    private final byte[] bytes;
    private final int width;
    private final int height;

    public RenderedFrame(@NotNull byte[] bytes, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
        this.width = width;
        this.height = height;
    }

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.compose.desktop.ui.tooling.preview.rpc.RenderedFrame");
        RenderedFrame cfr_ignored_0 = (RenderedFrame)other;
        if (!Arrays.equals(this.bytes, ((RenderedFrame)other).bytes)) {
            return false;
        }
        if (this.width != ((RenderedFrame)other).width) {
            return false;
        }
        return this.height == ((RenderedFrame)other).height;
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.bytes);
        result2 = 31 * result2 + this.width;
        result2 = 31 * result2 + this.height;
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final BufferedImage getImage() {
        BufferedImage bufferedImage;
        Closeable closeable = new ByteArrayInputStream(this.bytes);
        Throwable throwable = null;
        try {
            ByteArrayInputStream it = (ByteArrayInputStream)closeable;
            boolean bl = false;
            BufferedImage bufferedImage2 = ImageIO.read(it);
            bufferedImage = bufferedImage2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ByteArrayInputStream(byt\u2026.use { ImageIO.read(it) }");
        return bufferedImage;
    }

    @NotNull
    public final Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    @NotNull
    public final byte[] component1() {
        return this.bytes;
    }

    public final int component2() {
        return this.width;
    }

    public final int component3() {
        return this.height;
    }

    @NotNull
    public final RenderedFrame copy(@NotNull byte[] bytes, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return new RenderedFrame(bytes, width, height);
    }

    public static /* synthetic */ RenderedFrame copy$default(RenderedFrame renderedFrame, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            byArray = renderedFrame.bytes;
        }
        if ((n3 & 2) != 0) {
            n = renderedFrame.width;
        }
        if ((n3 & 4) != 0) {
            n2 = renderedFrame.height;
        }
        return renderedFrame.copy(byArray, n, n2);
    }

    @NotNull
    public String toString() {
        return "RenderedFrame(bytes=" + Arrays.toString(this.bytes) + ", width=" + this.width + ", height=" + this.height + ")";
    }
}

