/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal;

import java.util.Collection;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.desktop.application.dsl.JvmApplicationBuildType;
import org.jetbrains.compose.desktop.application.internal.JvmApplicationData;
import org.jetbrains.compose.desktop.application.internal.JvmApplicationInternal;
import org.jetbrains.compose.desktop.application.internal.JvmApplicationRuntimeFiles;
import org.jetbrains.compose.desktop.application.internal.JvmApplicationRuntimeFilesProvider;
import org.jetbrains.compose.desktop.application.internal.JvmTasks;
import org.jetbrains.compose.internal.ProjectExtensionsKt;
import org.jetbrains.compose.internal.utils.StringUtilsKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinTarget;
import org.jetbrains.kotlin.gradle.targets.jvm.KotlinJvmTarget;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c2\u0003J\t\u0010#\u001a\u00020\u0007H\u00c6\u0003J\t\u0010$\u001a\u00020\tH\u00c2\u0003J\u0006\u0010%\u001a\u00020&J1\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J*\u0010-\u001a\b\u0012\u0004\u0012\u0002H.0\u0013\"\u0006\b\u0000\u0010.\u0018\u00012\u000e\b\b\u0010/\u001a\b\u0012\u0004\u0012\u0002H.00H\u0086\b\u00f8\u0001\u0000J\t\u00101\u001a\u00020\tH\u00d6\u0001J8\u00102\u001a\u00020&\"\b\b\u0000\u0010.*\u000203*\u0002H.2\u001d\u0010/\u001a\u0019\u0012\u0004\u0012\u0002H.\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u00020&04\u00a2\u0006\u0002\b6\u00a2\u0006\u0002\u00107R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\t0\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00068"}, d2={"Lorg/jetbrains/compose/desktop/application/internal/JvmApplicationContext;", "", "project", "Lorg/gradle/api/Project;", "appInternal", "Lorg/jetbrains/compose/desktop/application/internal/JvmApplicationInternal;", "buildType", "Lorg/jetbrains/compose/desktop/application/dsl/JvmApplicationBuildType;", "taskGroup", "", "(Lorg/gradle/api/Project;Lorg/jetbrains/compose/desktop/application/internal/JvmApplicationInternal;Lorg/jetbrains/compose/desktop/application/dsl/JvmApplicationBuildType;Ljava/lang/String;)V", "app", "Lorg/jetbrains/compose/desktop/application/internal/JvmApplicationData;", "getApp", "()Lorg/jetbrains/compose/desktop/application/internal/JvmApplicationData;", "appDirName", "getAppDirName", "()Ljava/lang/String;", "appTmpDir", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/Directory;", "getAppTmpDir", "()Lorg/gradle/api/provider/Provider;", "getBuildType", "()Lorg/jetbrains/compose/desktop/application/dsl/JvmApplicationBuildType;", "packageNameProvider", "getPackageNameProvider", "getProject", "()Lorg/gradle/api/Project;", "tasks", "Lorg/jetbrains/compose/desktop/application/internal/JvmTasks;", "getTasks", "()Lorg/jetbrains/compose/desktop/application/internal/JvmTasks;", "component1", "component2", "component3", "component4", "configureDefaultApp", "", "copy", "equals", "", "other", "hashCode", "", "provider", "T", "fn", "Lkotlin/Function0;", "toString", "useAppRuntimeFiles", "Lorg/gradle/api/Task;", "Lkotlin/Function2;", "Lorg/jetbrains/compose/desktop/application/internal/JvmApplicationRuntimeFiles;", "Lkotlin/ExtensionFunctionType;", "(Lorg/gradle/api/Task;Lkotlin/jvm/functions/Function2;)V", "compose"})
@SourceDebugExtension(value={"SMAP\nJvmApplicationContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmApplicationContext.kt\norg/jetbrains/compose/desktop/application/internal/JvmApplicationContext\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,76:1\n37#2,2:77\n*S KotlinDebug\n*F\n+ 1 JvmApplicationContext.kt\norg/jetbrains/compose/desktop/application/internal/JvmApplicationContext\n*L\n42#1:77,2\n*E\n"})
public final class JvmApplicationContext {
    @NotNull
    private final Project project;
    @NotNull
    private final JvmApplicationInternal appInternal;
    @NotNull
    private final JvmApplicationBuildType buildType;
    @NotNull
    private final String taskGroup;
    @NotNull
    private final JvmTasks tasks;

    public JvmApplicationContext(@NotNull Project project, @NotNull JvmApplicationInternal appInternal, @NotNull JvmApplicationBuildType buildType, @NotNull String taskGroup) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)appInternal, (String)"appInternal");
        Intrinsics.checkNotNullParameter((Object)buildType, (String)"buildType");
        Intrinsics.checkNotNullParameter((Object)taskGroup, (String)"taskGroup");
        this.project = project;
        this.appInternal = appInternal;
        this.buildType = buildType;
        this.taskGroup = taskGroup;
        this.tasks = new JvmTasks(this.project, this.buildType, this.taskGroup);
    }

    public /* synthetic */ JvmApplicationContext(Project project, JvmApplicationInternal jvmApplicationInternal, JvmApplicationBuildType jvmApplicationBuildType, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = "compose desktop";
        }
        this(project, jvmApplicationInternal, jvmApplicationBuildType, string);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final JvmApplicationBuildType getBuildType() {
        return this.buildType;
    }

    @NotNull
    public final JvmApplicationData getApp() {
        return this.appInternal.getData$compose();
    }

    @NotNull
    public final String getAppDirName() {
        String[] stringArray = new String[]{this.appInternal.getName(), this.buildType.getClassifier$compose()};
        return StringUtilsKt.joinDashLowercaseNonEmpty(stringArray);
    }

    @NotNull
    public final Provider<Directory> getAppTmpDir() {
        Provider provider = this.project.getLayout().getBuildDirectory().dir("compose/tmp/" + this.getAppDirName());
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.buildDire\u2026mp/$appDirName\"\n        )");
        return provider;
    }

    public final <T extends Task> void useAppRuntimeFiles(@NotNull T $this$useAppRuntimeFiles, @NotNull Function2<? super T, ? super JvmApplicationRuntimeFiles, Unit> fn) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter($this$useAppRuntimeFiles, (String)"<this>");
                Intrinsics.checkNotNullParameter(fn, (String)"fn");
                object = this.getApp().getJvmApplicationRuntimeFilesProvider();
                if (object == null) break block2;
                Project project = $this$useAppRuntimeFiles.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                if ((object = ((JvmApplicationRuntimeFilesProvider)object).jvmApplicationRuntimeFiles(project)) != null) break block3;
            }
            Collection $this$toTypedArray$iv = this.getApp().getDependenciesTaskNames();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            JvmApplicationRuntimeFiles jvmApplicationRuntimeFiles2 = new JvmApplicationRuntimeFiles((FileCollection)this.getApp().getFromFiles(), (Provider<RegularFile>)((Provider)this.getApp().getMainJar()), thisCollection$iv.toArray(new Object[0]));
            object = jvmApplicationRuntimeFiles2;
        }
        Object runtimeFiles = object;
        ((JvmApplicationRuntimeFiles)runtimeFiles).configureUsageBy($this$useAppRuntimeFiles, fn);
    }

    @NotNull
    public final JvmTasks getTasks() {
        return this.tasks;
    }

    @NotNull
    public final Provider<String> getPackageNameProvider() {
        Provider provider = this.project.provider(() -> JvmApplicationContext._get_packageNameProvider_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.provider { appIn\u2026ageName ?: project.name }");
        return provider;
    }

    public final /* synthetic */ <T> Provider<T> provider(Function0<? extends T> fn) {
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        boolean $i$f$provider = false;
        Provider provider = this.getProject().provider(new Callable(fn){
            private final /* synthetic */ Function0 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object call() {
                return this.function.invoke();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.provider(fn)");
        return provider;
    }

    public final void configureDefaultApp() {
        if (this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
            Ref.BooleanRef isJvmTargetConfigured = new Ref.BooleanRef();
            ProjectExtensionsKt.getMppExt(this.project).getTargets().all(arg_0 -> JvmApplicationContext.configureDefaultApp$lambda$1((Function1)new Function1<KotlinTarget, Unit>(isJvmTargetConfigured, this){
                final /* synthetic */ Ref.BooleanRef $isJvmTargetConfigured;
                final /* synthetic */ JvmApplicationContext this$0;
                {
                    this.$isJvmTargetConfigured = $isJvmTargetConfigured;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(KotlinTarget target) {
                    if (target instanceof KotlinJvmTarget) {
                        if (!this.$isJvmTargetConfigured.element) {
                            JvmApplicationContext.access$getAppInternal$p(this.this$0).from(target);
                            this.$isJvmTargetConfigured.element = true;
                        } else {
                            this.this$0.getProject().getLogger().error("w: Default configuration for Compose Desktop Application is disabled: multiple Kotlin JVM targets definitions are detected. Specify, which target to use by using `compose.desktop.application.from(kotlinMppTarget)`");
                            JvmApplicationContext.access$getAppInternal$p(this.this$0).disableDefaultConfiguration();
                        }
                    }
                }
            }, arg_0));
        } else if (this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.jvm")) {
            SourceSet mainSourceSet = (SourceSet)ProjectExtensionsKt.getJavaSourceSets(this.project).getByName("main");
            Intrinsics.checkNotNullExpressionValue((Object)mainSourceSet, (String)"mainSourceSet");
            this.appInternal.from(mainSourceSet);
        }
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    private final JvmApplicationInternal component2() {
        return this.appInternal;
    }

    @NotNull
    public final JvmApplicationBuildType component3() {
        return this.buildType;
    }

    private final String component4() {
        return this.taskGroup;
    }

    @NotNull
    public final JvmApplicationContext copy(@NotNull Project project, @NotNull JvmApplicationInternal appInternal, @NotNull JvmApplicationBuildType buildType, @NotNull String taskGroup) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)appInternal, (String)"appInternal");
        Intrinsics.checkNotNullParameter((Object)buildType, (String)"buildType");
        Intrinsics.checkNotNullParameter((Object)taskGroup, (String)"taskGroup");
        return new JvmApplicationContext(project, appInternal, buildType, taskGroup);
    }

    public static /* synthetic */ JvmApplicationContext copy$default(JvmApplicationContext jvmApplicationContext, Project project, JvmApplicationInternal jvmApplicationInternal, JvmApplicationBuildType jvmApplicationBuildType, String string, int n, Object object) {
        if ((n & 1) != 0) {
            project = jvmApplicationContext.project;
        }
        if ((n & 2) != 0) {
            jvmApplicationInternal = jvmApplicationContext.appInternal;
        }
        if ((n & 4) != 0) {
            jvmApplicationBuildType = jvmApplicationContext.buildType;
        }
        if ((n & 8) != 0) {
            string = jvmApplicationContext.taskGroup;
        }
        return jvmApplicationContext.copy(project, jvmApplicationInternal, jvmApplicationBuildType, string);
    }

    @NotNull
    public String toString() {
        return "JvmApplicationContext(project=" + this.project + ", appInternal=" + this.appInternal + ", buildType=" + this.buildType + ", taskGroup=" + this.taskGroup + ")";
    }

    public int hashCode() {
        int result2 = this.project.hashCode();
        result2 = result2 * 31 + this.appInternal.hashCode();
        result2 = result2 * 31 + this.buildType.hashCode();
        result2 = result2 * 31 + this.taskGroup.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JvmApplicationContext)) {
            return false;
        }
        JvmApplicationContext jvmApplicationContext = (JvmApplicationContext)other;
        if (!Intrinsics.areEqual((Object)this.project, (Object)jvmApplicationContext.project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.appInternal, (Object)jvmApplicationContext.appInternal)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.buildType, (Object)jvmApplicationContext.buildType)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.taskGroup, (Object)jvmApplicationContext.taskGroup);
    }

    private static final String _get_packageNameProvider_$lambda$0(JvmApplicationContext this$0) {
        String string = this$0.appInternal.getNativeDistributions().getPackageName();
        if (string == null) {
            string = this$0.project.getName();
        }
        return string;
    }

    private static final void configureDefaultApp$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ JvmApplicationInternal access$getAppInternal$p(JvmApplicationContext $this) {
        return $this.appInternal;
    }
}

