/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.resources.IosResourcesTasksKt;
import org.jetbrains.compose.resources.SyncComposeResourcesForIosTask;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0007J \u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160\u0010*\b\u0012\u0004\u0012\u00020\u00160\u00102\u0006\u0010!\u001a\u00020\u0016H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8eX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00110\u00158aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001f\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001a0\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0019\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00108G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013\u00a8\u0006\""}, d2={"Lorg/jetbrains/compose/resources/SyncComposeResourcesForIosTask;", "Lorg/gradle/api/DefaultTask;", "()V", "objects", "Lorg/gradle/api/model/ObjectFactory;", "getObjects", "()Lorg/gradle/api/model/ObjectFactory;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "resourceFiles", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileCollection;", "getResourceFiles", "()Lorg/gradle/api/provider/Provider;", "targetResources", "Lorg/gradle/api/provider/MapProperty;", "", "getTargetResources$compose", "()Lorg/gradle/api/provider/MapProperty;", "xcodeTargetArchs", "", "getXcodeTargetArchs", "xcodeTargetPlatform", "getXcodeTargetPlatform", "run", "", "orElseThrowMissingAttributeError", "attribute", "compose"})
@SourceDebugExtension(value={"SMAP\nIosResourcesTasks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IosResourcesTasks.kt\norg/jetbrains/compose/resources/SyncComposeResourcesForIosTask\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,165:1\n1855#2:166\n1856#2:169\n1313#3,2:167\n*S KotlinDebug\n*F\n+ 1 IosResourcesTasks.kt\norg/jetbrains/compose/resources/SyncComposeResourcesForIosTask\n*L\n77#1:166\n77#1:169\n80#1:167,2\n*E\n"})
public abstract class SyncComposeResourcesForIosTask
extends DefaultTask {
    @NotNull
    private final Provider<String> xcodeTargetPlatform;
    @NotNull
    private final Provider<List<String>> xcodeTargetArchs;
    @NotNull
    private final Provider<FileCollection> resourceFiles;

    public SyncComposeResourcesForIosTask() {
        Provider provider = this.getProviders().gradleProperty("compose.ios.resources.platform").orElse(this.getProviders().environmentVariable("PLATFORM_NAME"));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providers.gradleProperty\u2026ariable(\"PLATFORM_NAME\"))");
        this.xcodeTargetPlatform = this.orElseThrowMissingAttributeError((Provider<String>)provider, "platform");
        Provider provider2 = this.getProviders().gradleProperty("compose.ios.resources.archs").orElse(this.getProviders().environmentVariable("ARCHS"));
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"providers.gradleProperty\u2026ronmentVariable(\"ARCHS\"))");
        Provider provider3 = this.orElseThrowMissingAttributeError((Provider<String>)provider2, "architectures").map(arg_0 -> SyncComposeResourcesForIosTask.xcodeTargetArchs$lambda$1(xcodeTargetArchs.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"providers.gradleProperty\u2026ter { it.isNotBlank() } }");
        this.xcodeTargetArchs = provider3;
        Provider provider4 = this.xcodeTargetPlatform.zip(this.xcodeTargetArchs, (arg_0, arg_1) -> SyncComposeResourcesForIosTask.resourceFiles$lambda$2(resourceFiles.1.INSTANCE, arg_0, arg_1)).map(arg_0 -> SyncComposeResourcesForIosTask.resourceFiles$lambda$3((Function1)new Function1<Pair<? extends String, ? extends List<? extends String>>, FileCollection>(this){
            final /* synthetic */ SyncComposeResourcesForIosTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final FileCollection invoke(Pair<String, ? extends List<String>> pair) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                String xcodeTargetPlatform = (String)pair.component1();
                List xcodeTargetArchs2 = (List)pair.component2();
                Intrinsics.checkNotNullExpressionValue((Object)xcodeTargetPlatform, (String)"xcodeTargetPlatform");
                Intrinsics.checkNotNullExpressionValue((Object)xcodeTargetArchs2, (String)"xcodeTargetArchs");
                FileCollection[] fileCollectionArray = (FileCollection[])IosResourcesTasksKt.access$getRequestedKonanTargetsByXcode(xcodeTargetPlatform, xcodeTargetArchs2);
                SyncComposeResourcesForIosTask syncComposeResourcesForIosTask = this.this$0;
                boolean $i$f$mapNotNull = false;
                void var8_7 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    FileCollection it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    KonanTarget konanTarget = (KonanTarget)element$iv$iv;
                    boolean bl2 = false;
                    if ((FileCollection)syncComposeResourcesForIosTask.getTargetResources$compose().getting((Object)konanTarget.getName()).get() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List allResources = (List)destination$iv$iv;
                Collection $this$toTypedArray$iv = allResources;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                fileCollectionArray = thisCollection$iv.toArray(new FileCollection[0]);
                return (FileCollection)this.this$0.getObjects().fileCollection().from((Object[])Arrays.copyOf(fileCollectionArray, fileCollectionArray.length));
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"xcodeTargetPlatform.zip(\u2026toTypedArray())\n        }");
        this.resourceFiles = provider4;
    }

    private final Provider<String> orElseThrowMissingAttributeError(Provider<String> $this$orElseThrowMissingAttributeError, String attribute) {
        String noProvidedValue = "__NO_PROVIDED_VALUE__";
        Provider provider = $this$orElseThrowMissingAttributeError.orElse((Object)noProvidedValue).map(arg_0 -> SyncComposeResourcesForIosTask.orElseThrowMissingAttributeError$lambda$0((Function1)new Function1<String, String>(noProvidedValue, attribute){
            final /* synthetic */ String $noProvidedValue;
            final /* synthetic */ String $attribute;
            {
                this.$noProvidedValue = $noProvidedValue;
                this.$attribute = $attribute;
                super(1);
            }

            public final String invoke(String it) {
                if (Intrinsics.areEqual((Object)it, (Object)this.$noProvidedValue)) {
                    throw new IllegalStateException(("Could not infer iOS target " + this.$attribute + ". Make sure to build via XCode (directly or via Kotlin Multiplatform Mobile plugin for Android Studio)").toString());
                }
                return it;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"attribute: String): Prov\u2026\n            it\n        }");
        return provider;
    }

    @Inject
    @NotNull
    protected abstract ProviderFactory getProviders();

    @Inject
    @NotNull
    protected abstract ObjectFactory getObjects();

    @Input
    @NotNull
    public final Provider<String> getXcodeTargetPlatform() {
        return this.xcodeTargetPlatform;
    }

    @Input
    @NotNull
    public final Provider<List<String>> getXcodeTargetArchs() {
        return this.xcodeTargetArchs;
    }

    @Internal
    @NotNull
    public abstract MapProperty<String, FileCollection> getTargetResources$compose();

    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @InputFiles
    @NotNull
    public final Provider<FileCollection> getResourceFiles() {
        return this.resourceFiles;
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @TaskAction
    public final void run() {
        File outputDir = ((Directory)this.getOutputDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)outputDir, (String)"outputDir");
        FilesKt.deleteRecursively((File)outputDir);
        outputDir.mkdirs();
        this.getLogger().info("Clean " + outputDir.getPath());
        Object object = this.resourceFiles.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resourceFiles.get()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File dir2 = (File)element$iv;
            boolean bl = false;
            if (dir2.exists() && dir2.isDirectory()) {
                this.getLogger().info("Copy '" + dir2.getPath() + "' to '" + outputDir.getPath() + "'");
                Intrinsics.checkNotNullExpressionValue((Object)dir2, (String)"dir");
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)dir2)), (Function1)run.1.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File file2 = (File)element$iv2;
                    boolean bl2 = false;
                    File targetFile = FilesKt.resolve((File)outputDir, (File)FilesKt.relativeTo((File)file2, (File)dir2));
                    if (targetFile.exists()) {
                        this.getLogger().info("Skip [already exists] '" + file2.getPath() + "'");
                        continue;
                    }
                    this.getLogger().info(" -> '" + file2.getPath() + "'");
                    FilesKt.copyTo$default((File)file2, (File)targetFile, (boolean)false, (int)0, (int)6, null);
                }
                continue;
            }
            this.getLogger().info("File '" + dir2.getPath() + "' is not a dir or doesn't exist");
        }
    }

    private static final String orElseThrowMissingAttributeError$lambda$0(Function1 $tmp0, Object in) {
        return (String)$tmp0.invoke(in);
    }

    private static final List xcodeTargetArchs$lambda$1(Function1 $tmp0, Object in) {
        return (List)$tmp0.invoke(in);
    }

    private static final Pair resourceFiles$lambda$2(Function2 $tmp0, Object p0, Object p1) {
        return (Pair)$tmp0.invoke(p0, p1);
    }

    private static final FileCollection resourceFiles$lambda$3(Function1 $tmp0, Object in) {
        return (FileCollection)$tmp0.invoke(in);
    }
}

