/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.web.tasks;

import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.internal.utils.FileUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u00020\u00108GX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/compose/web/tasks/UnpackSkikoWasmRuntimeTask;", "Lorg/gradle/api/DefaultTask;", "()V", "archiveOperations", "Lorg/gradle/api/file/ArchiveOperations;", "getArchiveOperations$compose", "()Lorg/gradle/api/file/ArchiveOperations;", "fileOperations", "Lorg/gradle/api/file/FileSystemOperations;", "getFileOperations$compose", "()Lorg/gradle/api/file/FileSystemOperations;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "skikoRuntimeFiles", "Lorg/gradle/api/file/FileCollection;", "getSkikoRuntimeFiles", "()Lorg/gradle/api/file/FileCollection;", "setSkikoRuntimeFiles", "(Lorg/gradle/api/file/FileCollection;)V", "run", "", "unpackJar", "file", "Ljava/io/File;", "compose"})
public abstract class UnpackSkikoWasmRuntimeTask
extends DefaultTask {
    public FileCollection skikoRuntimeFiles;

    @InputFiles
    @NotNull
    public final FileCollection getSkikoRuntimeFiles() {
        FileCollection fileCollection = this.skikoRuntimeFiles;
        if (fileCollection != null) {
            return fileCollection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"skikoRuntimeFiles");
        return null;
    }

    public final void setSkikoRuntimeFiles(@NotNull FileCollection fileCollection) {
        Intrinsics.checkNotNullParameter((Object)fileCollection, (String)"<set-?>");
        this.skikoRuntimeFiles = fileCollection;
    }

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @Inject
    @NotNull
    public abstract ArchiveOperations getArchiveOperations$compose();

    @Inject
    @NotNull
    public abstract FileSystemOperations getFileOperations$compose();

    @TaskAction
    public final void run() {
        Provider[] providerArray = new Provider[]{this.getOutputDir()};
        FileUtilsKt.clearDirs(this.getFileOperations$compose(), providerArray);
        for (File file2 : this.getSkikoRuntimeFiles().getFiles()) {
            String string = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            if (!StringsKt.endsWith((String)string, (String)".jar", (boolean)true)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            this.unpackJar(file2);
        }
    }

    private final void unpackJar(File file2) {
        this.getFileOperations$compose().copy(arg_0 -> UnpackSkikoWasmRuntimeTask.unpackJar$lambda$0((Function1)new Function1<CopySpec, Unit>(this, file2){
            final /* synthetic */ UnpackSkikoWasmRuntimeTask this$0;
            final /* synthetic */ File $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(1);
            }

            public final void invoke(CopySpec copySpec) {
                Object[] objectArray = new Object[]{this.this$0.getArchiveOperations$compose().zipTree((Object)this.$file)};
                copySpec.from(objectArray);
                copySpec.into((Object)this.this$0.getOutputDir());
            }
        }, arg_0));
    }

    private static final void unpackJar$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

