/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.web.tasks;

import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.internal.utils.FileUtilsKt;
import org.jetbrains.compose.internal.utils.StringUtilsKt;
import org.jetbrains.compose.web.tasks.WebCompatibilityTask;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048aX\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\nR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/compose/web/tasks/WebCompatibilityTask;", "Lorg/gradle/api/DefaultTask;", "()V", "fileOperations", "Lorg/gradle/api/file/FileSystemOperations;", "getFileOperations$compose", "()Lorg/gradle/api/file/FileSystemOperations;", "jsDistFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getJsDistFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "jsOutputName", "Lorg/gradle/api/provider/Property;", "", "getJsOutputName", "()Lorg/gradle/api/provider/Property;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "wasmDistFiles", "getWasmDistFiles", "wasmOutputName", "getWasmOutputName", "run", "", "compose"})
public abstract class WebCompatibilityTask
extends DefaultTask {
    @Inject
    @NotNull
    public abstract FileSystemOperations getFileOperations$compose();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getJsDistFiles();

    @InputFiles
    @NotNull
    public abstract ConfigurableFileCollection getWasmDistFiles();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getJsOutputName();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getWasmOutputName();

    @TaskAction
    public final void run() {
        String prefix = "origin";
        String jsAppFileName = (String)this.getJsOutputName().get();
        String[] stringArray = new String[3];
        stringArray[0] = prefix;
        stringArray[1] = "js";
        Intrinsics.checkNotNullExpressionValue((Object)jsAppFileName, (String)"jsAppFileName");
        stringArray[2] = jsAppFileName;
        String jsAppRenamed = StringUtilsKt.joinLowerCamelCase(stringArray);
        String wasmAppFileName = (String)this.getWasmOutputName().get();
        String[] stringArray2 = new String[3];
        stringArray2[0] = prefix;
        stringArray2[1] = "wasm";
        Intrinsics.checkNotNullExpressionValue((Object)wasmAppFileName, (String)"wasmAppFileName");
        stringArray2[2] = wasmAppFileName;
        String wasmAppRenamed = StringUtilsKt.joinLowerCamelCase(stringArray2);
        stringArray2 = new Provider[]{this.getOutputDir()};
        FileUtilsKt.clearDirs(this.getFileOperations$compose(), stringArray2);
        this.getFileOperations$compose().copy(arg_0 -> WebCompatibilityTask.run$lambda$0((Function1)new Function1<CopySpec, Unit>(this, jsAppFileName, jsAppRenamed, wasmAppFileName, wasmAppRenamed){
            final /* synthetic */ WebCompatibilityTask this$0;
            final /* synthetic */ String $jsAppFileName;
            final /* synthetic */ String $jsAppRenamed;
            final /* synthetic */ String $wasmAppFileName;
            final /* synthetic */ String $wasmAppRenamed;
            {
                this.this$0 = $receiver;
                this.$jsAppFileName = $jsAppFileName;
                this.$jsAppRenamed = $jsAppRenamed;
                this.$wasmAppFileName = $wasmAppFileName;
                this.$wasmAppRenamed = $wasmAppRenamed;
                super(1);
            }

            public final void invoke(CopySpec copySpec) {
                copySpec.setDuplicatesStrategy(DuplicatesStrategy.WARN);
                copySpec.from((Object)this.this$0.getJsDistFiles(), arg_0 -> run.1.invoke$lambda$0((Function1)new Function1<CopySpec, Unit>(this.$jsAppFileName, this.$jsAppRenamed){
                    final /* synthetic */ String $jsAppFileName;
                    final /* synthetic */ String $jsAppRenamed;
                    {
                        this.$jsAppFileName = $jsAppFileName;
                        this.$jsAppRenamed = $jsAppRenamed;
                        super(1);
                    }

                    public final void invoke(CopySpec it) {
                        it.rename(arg_0 -> run.1.invoke$lambda$0(this.$jsAppFileName, this.$jsAppRenamed, arg_0));
                    }

                    private static final String invoke$lambda$0(String $jsAppFileName, String $jsAppRenamed, String name) {
                        String string = name;
                        return Intrinsics.areEqual((Object)string, (Object)$jsAppFileName) ? $jsAppRenamed : (Intrinsics.areEqual((Object)string, (Object)($jsAppFileName + ".map")) ? $jsAppRenamed + ".map" : name);
                    }
                }, arg_0));
                copySpec.from((Object)this.this$0.getWasmDistFiles(), arg_0 -> run.1.invoke$lambda$1((Function1)new Function1<CopySpec, Unit>(this.$wasmAppFileName, this.$wasmAppRenamed){
                    final /* synthetic */ String $wasmAppFileName;
                    final /* synthetic */ String $wasmAppRenamed;
                    {
                        this.$wasmAppFileName = $wasmAppFileName;
                        this.$wasmAppRenamed = $wasmAppRenamed;
                        super(1);
                    }

                    public final void invoke(CopySpec it) {
                        it.rename(arg_0 -> run.2.invoke$lambda$0(this.$wasmAppFileName, this.$wasmAppRenamed, arg_0));
                    }

                    private static final String invoke$lambda$0(String $wasmAppFileName, String $wasmAppRenamed, String name) {
                        String string = name;
                        return Intrinsics.areEqual((Object)string, (Object)$wasmAppFileName) ? $wasmAppRenamed : (Intrinsics.areEqual((Object)string, (Object)($wasmAppFileName + ".map")) ? $wasmAppRenamed + ".map" : name);
                    }
                }, arg_0));
                copySpec.into((Object)this.this$0.getOutputDir());
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                $tmp0.invoke(p0);
            }
        }, arg_0));
        String fallbackResolverCode = StringsKt.trimIndent((String)("\n            const loadApp = () => {\n                 const simpleWasmModule = new Uint8Array([\n                    0,  97, 115, 109,   1,   0,   0,  0,   1,   8,   2,  95,\n                    1, 120,   0,  96,   0,   0,   3,  3,   2,   1,   1,  10,\n                   14,   2,   6,   0,   6,  64,  25, 11,  11,   5,   0, 208,\n                  112,  26,  11,   0,  45,   4, 110, 97, 109, 101,   1,  15,\n                    2,   0,   5, 102, 117, 110,  99, 48,   1,   5, 102, 117,\n                  110,  99,  49,   4,   8,   1,   0,  5, 116, 121, 112, 101,\n                   48,  10,  11,   1,   0,   1,   0,  6, 102, 105, 101, 108,\n                  100,  48\n                    ]);\n\n                const hasSupportOfAllRequiredWasmFeatures = () =>\n                    typeof WebAssembly !== \"undefined\" &&\n                    typeof WebAssembly?.validate === \"function\" &&\n                    WebAssembly.validate(simpleWasmModule);\n\n                const createScript = (src) => {\n                    const script = document.createElement(\"script\");\n                    script.src = src;\n                    script.type = \"application/javascript\";\n                    return script;\n                }\n\n                document.body.appendChild(createScript(hasSupportOfAllRequiredWasmFeatures() ? \"" + wasmAppRenamed + "\" : \"" + jsAppRenamed + "\"));\n            }\n\n            if (document.readyState === \"loading\") {\n                document.addEventListener(\"DOMContentLoaded\", loadApp);\n            } else {\n                loadApp();\n            }\n            "));
        File outputDir = ((Directory)this.getOutputDir().get()).getAsFile();
        FilesKt.writeText$default((File)new File(outputDir, jsAppFileName), (String)fallbackResolverCode, null, (int)2, null);
        FilesKt.writeText$default((File)new File(outputDir, wasmAppFileName), (String)fallbackResolverCode, null, (int)2, null);
    }

    private static final void run$lambda$0(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

