/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.protocol;

import java.io.IOException;
import java.net.URISyntaxException;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.annotation.Contract;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.annotation.ThreadingBehavior;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.EntityDetails;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.Header;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpException;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpRequest;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpRequestInterceptor;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpVersion;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.ProtocolException;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.ProtocolVersion;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.protocol.HttpContext;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.net.URIAuthority;
import org.jetbrains.compose.internal.de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestValidateHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        Header header = request.getHeader("Host");
        if (header != null) {
            URIAuthority authority;
            try {
                authority = URIAuthority.create(header.getValue());
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException(ex.getMessage(), ex);
            }
            request.setAuthority(authority);
        } else {
            ProtocolVersion version;
            ProtocolVersion protocolVersion = version = request.getVersion() != null ? request.getVersion() : HttpVersion.HTTP_1_1;
            if (version.greaterEquals(HttpVersion.HTTP_1_1)) {
                throw new ProtocolException("Host header is absent");
            }
        }
    }
}

