/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy;

import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.lazy.LazyListItemPlacementAnimator;
import androidx.compose.foundation.lazy.LazyListPlaceableWrapper;
import androidx.compose.foundation.lazy.LazyListPositionedItem;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.layout.Placeable;
import androidx.compose.ui.unit.IntOffsetKt;
import androidx.compose.ui.unit.LayoutDirection;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B|\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\b\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0003\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\u0006\u0010\u0017\u001a\u00020\u0001\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020\u0003R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001bR\u0011\u0010\"\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u001bR\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\n\u0002\u0010$\u0082\u0002\u000f\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006*"}, d2={"Landroidx/compose/foundation/lazy/LazyMeasuredItem;", "", "index", "", "placeables", "", "Landroidx/compose/ui/layout/Placeable;", "isVertical", "", "horizontalAlignment", "Landroidx/compose/ui/Alignment$Horizontal;", "verticalAlignment", "Landroidx/compose/ui/Alignment$Vertical;", "layoutDirection", "Landroidx/compose/ui/unit/LayoutDirection;", "reverseLayout", "beforeContentPadding", "afterContentPadding", "placementAnimator", "Landroidx/compose/foundation/lazy/LazyListItemPlacementAnimator;", "spacing", "visualOffset", "Landroidx/compose/ui/unit/IntOffset;", "key", "(I[Landroidx/compose/ui/layout/Placeable;ZLandroidx/compose/ui/Alignment$Horizontal;Landroidx/compose/ui/Alignment$Vertical;Landroidx/compose/ui/unit/LayoutDirection;ZIILandroidx/compose/foundation/lazy/LazyListItemPlacementAnimator;IJLjava/lang/Object;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "crossAxisSize", "getCrossAxisSize", "()I", "getIndex", "getKey", "()Ljava/lang/Object;", "[Landroidx/compose/ui/layout/Placeable;", "size", "getSize", "sizeWithSpacings", "getSizeWithSpacings", "J", "position", "Landroidx/compose/foundation/lazy/LazyListPositionedItem;", "offset", "layoutWidth", "layoutHeight", "foundation"})
public final class LazyMeasuredItem {
    private final int index;
    @NotNull
    private final Placeable[] placeables;
    private final boolean isVertical;
    @Nullable
    private final Alignment.Horizontal horizontalAlignment;
    @Nullable
    private final Alignment.Vertical verticalAlignment;
    @NotNull
    private final LayoutDirection layoutDirection;
    private final boolean reverseLayout;
    private final int beforeContentPadding;
    private final int afterContentPadding;
    @NotNull
    private final LazyListItemPlacementAnimator placementAnimator;
    private final int spacing;
    private final long visualOffset;
    @NotNull
    private final Object key;
    private final int size;
    private final int sizeWithSpacings;
    private final int crossAxisSize;

    private LazyMeasuredItem(int index, Placeable[] placeables, boolean isVertical, Alignment.Horizontal horizontalAlignment, Alignment.Vertical verticalAlignment, LayoutDirection layoutDirection, boolean reverseLayout, int beforeContentPadding, int afterContentPadding, LazyListItemPlacementAnimator placementAnimator, int spacing, long visualOffset, Object key2) {
        this.index = index;
        this.placeables = placeables;
        this.isVertical = isVertical;
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.layoutDirection = layoutDirection;
        this.reverseLayout = reverseLayout;
        this.beforeContentPadding = beforeContentPadding;
        this.afterContentPadding = afterContentPadding;
        this.placementAnimator = placementAnimator;
        this.spacing = spacing;
        this.visualOffset = visualOffset;
        this.key = key2;
        int mainAxisSize = 0;
        int maxCrossAxis = 0;
        Placeable[] $this$forEach$iv = this.placeables;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Placeable element$iv;
            Placeable it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            mainAxisSize += this.isVertical ? it.getHeight() : it.getWidth();
            maxCrossAxis = Math.max(maxCrossAxis, !this.isVertical ? it.getHeight() : it.getWidth());
        }
        this.size = mainAxisSize;
        this.sizeWithSpacings = this.size + this.spacing;
        this.crossAxisSize = maxCrossAxis;
    }

    public final int getIndex() {
        return this.index;
    }

    @NotNull
    public final Object getKey() {
        return this.key;
    }

    public final int getSize() {
        return this.size;
    }

    public final int getSizeWithSpacings() {
        return this.sizeWithSpacings;
    }

    public final int getCrossAxisSize() {
        return this.crossAxisSize;
    }

    @NotNull
    public final LazyListPositionedItem position(int offset, int layoutWidth, int layoutHeight) {
        int index;
        List wrappers = new ArrayList();
        int mainAxisLayoutSize = this.isVertical ? layoutHeight : layoutWidth;
        int mainAxisOffset = this.reverseLayout ? mainAxisLayoutSize - offset - this.size : offset;
        int n = index = this.reverseLayout ? ArraysKt.getLastIndex((Object[])this.placeables) : 0;
        while (true) {
            long l;
            int addIndex;
            boolean bl = this.reverseLayout ? index >= 0 : index < this.placeables.length;
            if (!bl) break;
            Placeable it = this.placeables[index];
            int n2 = addIndex = this.reverseLayout ? 0 : wrappers.size();
            if (this.isVertical) {
                Alignment.Horizontal horizontal = this.horizontalAlignment;
                if (horizontal == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                int x = horizontal.align(it.getWidth(), layoutWidth, this.layoutDirection);
                l = IntOffsetKt.IntOffset((int)x, (int)mainAxisOffset);
            } else {
                Alignment.Vertical vertical = this.verticalAlignment;
                if (vertical == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                int y = vertical.align(it.getHeight(), layoutHeight);
                l = IntOffsetKt.IntOffset((int)mainAxisOffset, (int)y);
            }
            long placeableOffset = l;
            mainAxisOffset += this.isVertical ? it.getHeight() : it.getWidth();
            wrappers.add(addIndex, new LazyListPlaceableWrapper(placeableOffset, it, this.placeables[index].getParentData(), null));
            if (this.reverseLayout) {
                --index;
                continue;
            }
            ++index;
        }
        return new LazyListPositionedItem(offset, this.index, this.key, this.size, this.sizeWithSpacings, -(!this.reverseLayout ? this.beforeContentPadding : this.afterContentPadding), mainAxisLayoutSize + (!this.reverseLayout ? this.afterContentPadding : this.beforeContentPadding), this.isVertical, wrappers, this.placementAnimator, this.visualOffset, null);
    }

    @ExperimentalFoundationApi
    public /* synthetic */ LazyMeasuredItem(int index, Placeable[] placeables, boolean isVertical, Alignment.Horizontal horizontalAlignment, Alignment.Vertical verticalAlignment, LayoutDirection layoutDirection, boolean reverseLayout, int beforeContentPadding, int afterContentPadding, LazyListItemPlacementAnimator placementAnimator, int spacing, long visualOffset, Object key2, DefaultConstructorMarker $constructor_marker) {
        this(index, placeables, isVertical, horizontalAlignment, verticalAlignment, layoutDirection, reverseLayout, beforeContentPadding, afterContentPadding, placementAnimator, spacing, visualOffset, key2);
    }
}

