/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.selection.MultiWidgetSelectionDelegateKt;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionAdjustment;
import androidx.compose.foundation.text.selection.TextSelectionDelegateKt;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0006H\u0016J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\n\u0010\u001d\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J_\u0010 \u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020\u00150!2\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u00112\b\u0010$\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0013H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0002\u00a2\u0006\u0004\b)\u0010*R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006+"}, d2={"Landroidx/compose/foundation/text/selection/MultiWidgetSelectionDelegate;", "Landroidx/compose/foundation/text/selection/Selectable;", "selectableId", "", "coordinatesCallback", "Lkotlin/Function0;", "Landroidx/compose/ui/layout/LayoutCoordinates;", "layoutResultCallback", "Landroidx/compose/ui/text/TextLayoutResult;", "(JLkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "getSelectableId", "()J", "getBoundingBox", "Landroidx/compose/ui/geometry/Rect;", "offset", "", "getHandlePosition", "Landroidx/compose/ui/geometry/Offset;", "selection", "Landroidx/compose/foundation/text/selection/Selection;", "isStartHandle", "", "getHandlePosition-dBAh8RU", "(Landroidx/compose/foundation/text/selection/Selection;Z)J", "getLayoutCoordinates", "getRangeOfLineContaining", "Landroidx/compose/ui/text/TextRange;", "getRangeOfLineContaining--jx7JFs", "(I)J", "getSelectAllSelection", "getText", "Landroidx/compose/ui/text/AnnotatedString;", "updateSelection", "Lkotlin/Pair;", "startHandlePosition", "endHandlePosition", "previousHandlePosition", "containerLayoutCoordinates", "adjustment", "Landroidx/compose/foundation/text/selection/SelectionAdjustment;", "previousSelection", "updateSelection-qCDeeow", "(JJLandroidx/compose/ui/geometry/Offset;ZLandroidx/compose/ui/layout/LayoutCoordinates;Landroidx/compose/foundation/text/selection/SelectionAdjustment;Landroidx/compose/foundation/text/selection/Selection;)Lkotlin/Pair;", "foundation"})
public final class MultiWidgetSelectionDelegate
implements Selectable {
    private final long selectableId;
    @NotNull
    private final Function0<LayoutCoordinates> coordinatesCallback;
    @NotNull
    private final Function0<TextLayoutResult> layoutResultCallback;

    public MultiWidgetSelectionDelegate(long selectableId2, @NotNull Function0<? extends LayoutCoordinates> coordinatesCallback, @NotNull Function0<TextLayoutResult> layoutResultCallback) {
        Intrinsics.checkNotNullParameter(coordinatesCallback, (String)"coordinatesCallback");
        Intrinsics.checkNotNullParameter(layoutResultCallback, (String)"layoutResultCallback");
        this.selectableId = selectableId2;
        this.coordinatesCallback = coordinatesCallback;
        this.layoutResultCallback = layoutResultCallback;
    }

    @Override
    public long getSelectableId() {
        return this.selectableId;
    }

    @Override
    @NotNull
    public Pair<Selection, Boolean> updateSelection-qCDeeow(long startHandlePosition, long endHandlePosition, @Nullable Offset previousHandlePosition, boolean isStartHandle, @NotNull LayoutCoordinates containerLayoutCoordinates, @NotNull SelectionAdjustment adjustment, @Nullable Selection previousSelection) {
        Offset offset;
        Intrinsics.checkNotNullParameter((Object)containerLayoutCoordinates, (String)"containerLayoutCoordinates");
        Intrinsics.checkNotNullParameter((Object)adjustment, (String)"adjustment");
        if (!(previousSelection == null || this.getSelectableId() == previousSelection.getStart().getSelectableId() && this.getSelectableId() == previousSelection.getEnd().getSelectableId())) {
            boolean $i$a$-require-MultiWidgetSelectionDelegate$updateSelection$22 = false;
            String $i$a$-require-MultiWidgetSelectionDelegate$updateSelection$22 = "The given previousSelection doesn't belong to this selectable.";
            throw new IllegalArgumentException($i$a$-require-MultiWidgetSelectionDelegate$updateSelection$22.toString());
        }
        LayoutCoordinates layoutCoordinates = this.getLayoutCoordinates();
        if (layoutCoordinates == null) {
            return new Pair(null, (Object)false);
        }
        LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return new Pair(null, (Object)false);
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        long relativePosition = containerLayoutCoordinates.localPositionOf-R5De75A(layoutCoordinates2, Offset.Companion.getZero-F1C5BW0());
        long localStartPosition = Offset.minus-MK-Hz9U((long)startHandlePosition, (long)relativePosition);
        long localEndPosition = Offset.minus-MK-Hz9U((long)endHandlePosition, (long)relativePosition);
        Offset offset2 = previousHandlePosition;
        if (offset2 != null) {
            long it = offset2.unbox-impl();
            boolean bl = false;
            offset = Offset.box-impl((long)Offset.minus-MK-Hz9U((long)it, (long)relativePosition));
        } else {
            offset = null;
        }
        Offset localPreviousHandlePosition = offset;
        return MultiWidgetSelectionDelegateKt.getTextSelectionInfo-yM0VcXU(textLayoutResult2, localStartPosition, localEndPosition, localPreviousHandlePosition, this.getSelectableId(), adjustment, previousSelection, isStartHandle);
    }

    @Override
    @Nullable
    public Selection getSelectAllSelection() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return null;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        long newSelectionRange = TextRangeKt.TextRange((int)0, (int)textLayoutResult2.getLayoutInput().getText().length());
        return MultiWidgetSelectionDelegateKt.access$getAssembledSelectionInfo-vJH6DeI(newSelectionRange, false, this.getSelectableId(), textLayoutResult2);
    }

    @Override
    public long getHandlePosition-dBAh8RU(@NotNull Selection selection, boolean isStartHandle) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (isStartHandle && selection.getStart().getSelectableId() != this.getSelectableId() || !isStartHandle && selection.getEnd().getSelectableId() != this.getSelectableId()) {
            return Offset.Companion.getZero-F1C5BW0();
        }
        if (this.getLayoutCoordinates() == null) {
            return Offset.Companion.getZero-F1C5BW0();
        }
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Offset.Companion.getZero-F1C5BW0();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return TextSelectionDelegateKt.getSelectionHandleCoordinates(textLayoutResult2, isStartHandle ? selection.getStart().getOffset() : selection.getEnd().getOffset(), isStartHandle, selection.getHandlesCrossed());
    }

    @Override
    @Nullable
    public LayoutCoordinates getLayoutCoordinates() {
        LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.coordinatesCallback.invoke();
        if (layoutCoordinates == null || !layoutCoordinates.isAttached()) {
            return null;
        }
        return layoutCoordinates;
    }

    @Override
    @NotNull
    public AnnotatedString getText() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return new AnnotatedString("", null, null, 6, null);
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return textLayoutResult2.getLayoutInput().getText();
    }

    @Override
    @NotNull
    public Rect getBoundingBox(int offset) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Rect.Companion.getZero();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int textLength = textLayoutResult2.getLayoutInput().getText().length();
        if (textLength < 1) {
            return Rect.Companion.getZero();
        }
        return textLayoutResult2.getBoundingBox(RangesKt.coerceIn((int)offset, (int)0, (int)(textLength - 1)));
    }

    @Override
    public long getRangeOfLineContaining--jx7JFs(int offset) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return TextRange.Companion.getZero-d9O1mEE();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int textLength = textLayoutResult2.getLayoutInput().getText().length();
        if (textLength < 1) {
            return TextRange.Companion.getZero-d9O1mEE();
        }
        int line = textLayoutResult2.getLineForOffset(RangesKt.coerceIn((int)offset, (int)0, (int)(textLength - 1)));
        return TextRangeKt.TextRange((int)textLayoutResult2.getLineStart(line), (int)textLayoutResult2.getLineEnd(line, true));
    }
}

