/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.staggeredgrid;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u0004H\u0002J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\u0004J\u0006\u0010\u0013\u001a\u00020\bJ\u0016\u0010\u0014\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004J\u0006\u0010\u0016\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridSpans;", "", "()V", "anchor", "", "spans", "", "ensureCapacity", "", "capacity", "newOffset", "ensureValidIndex", "requestedIndex", "findNextItemIndex", "item", "target", "findPreviousItemIndex", "getSpan", "lowerBound", "reset", "setSpan", "span", "upperBound", "Companion", "foundation"})
@SourceDebugExtension(value={"SMAP\nLazyStaggeredGridSpans.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyStaggeredGridSpans.kt\nandroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridSpans\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n1#2:160\n*E\n"})
public final class LazyStaggeredGridSpans {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int anchor;
    @NotNull
    private int[] spans = new int[16];
    private static final int MaxCapacity = 131072;
    public static final int Unset = -1;

    public final void setSpan(int item2, int span) {
        if (!(item2 >= 0)) {
            boolean bl = false;
            String string = "Negative spans are not supported";
            throw new IllegalArgumentException(string.toString());
        }
        this.ensureValidIndex(item2);
        this.spans[item2 - this.anchor] = span + 1;
    }

    public final int getSpan(int item2) {
        if (item2 < this.lowerBound() || item2 >= this.upperBound()) {
            return -1;
        }
        return this.spans[item2 - this.anchor] - 1;
    }

    public final int upperBound() {
        return this.anchor + this.spans.length;
    }

    public final int lowerBound() {
        return this.anchor;
    }

    public final void reset() {
        ArraysKt.fill$default((int[])this.spans, (int)0, (int)0, (int)0, (int)6, null);
    }

    public final int findPreviousItemIndex(int item2, int target) {
        for (int i = item2 - 1; -1 < i; --i) {
            int span = this.getSpan(i);
            if (span != target && span != -1) continue;
            return i;
        }
        return -1;
    }

    public final int findNextItemIndex(int item2, int target) {
        int n = this.upperBound();
        for (int i = item2 + 1; i < n; ++i) {
            int span = this.getSpan(i);
            if (span != target && span != -1) continue;
            return i;
        }
        return this.upperBound();
    }

    public final void ensureValidIndex(int requestedIndex) {
        int requestedCapacity = requestedIndex - this.anchor;
        boolean bl = 0 <= requestedCapacity ? requestedCapacity < 131072 : false;
        if (bl) {
            LazyStaggeredGridSpans.ensureCapacity$default(this, requestedCapacity + 1, 0, 2, null);
        } else {
            int oldAnchor = this.anchor;
            this.anchor = Math.max(requestedIndex - this.spans.length / 2, 0);
            int delta = this.anchor - oldAnchor;
            if (delta >= 0) {
                if (delta < this.spans.length) {
                    ArraysKt.copyInto((int[])this.spans, (int[])this.spans, (int)0, (int)delta, (int)this.spans.length);
                }
                ArraysKt.fill((int[])this.spans, (int)0, (int)Math.max(0, this.spans.length - delta), (int)this.spans.length);
            } else if (this.spans.length + (delta = -delta) < 131072) {
                this.ensureCapacity(this.spans.length + delta + 1, delta);
            } else {
                if (delta < this.spans.length) {
                    ArraysKt.copyInto((int[])this.spans, (int[])this.spans, (int)delta, (int)0, (int)(this.spans.length - delta));
                }
                ArraysKt.fill((int[])this.spans, (int)0, (int)0, (int)Math.min(this.spans.length, delta));
            }
        }
    }

    private final void ensureCapacity(int capacity, int newOffset) {
        if (!(capacity <= 131072)) {
            boolean bl = false;
            String string = "Requested span capacity " + capacity + " is larger than max supported: 131072!";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.spans.length < capacity) {
            int newSize;
            for (newSize = this.spans.length; newSize < capacity; newSize *= 2) {
            }
            this.spans = ArraysKt.copyInto$default((int[])this.spans, (int[])new int[newSize], (int)newOffset, (int)0, (int)0, (int)12, null);
        }
    }

    static /* synthetic */ void ensureCapacity$default(LazyStaggeredGridSpans lazyStaggeredGridSpans, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        lazyStaggeredGridSpans.ensureCapacity(n, n2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/compose/foundation/lazy/staggeredgrid/LazyStaggeredGridSpans$Companion;", "", "()V", "MaxCapacity", "", "Unset", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

