/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.StringHelpersKt;
import androidx.compose.foundation.text.selection.SelectionAdjustmentKt;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KFunction;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b`\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eJ?\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H&\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\f\u0010\r\u00f8\u0001\u0002\u0082\u0002\u0011\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Landroidx/compose/foundation/text/selection/SelectionAdjustment;", "", "adjust", "Landroidx/compose/ui/text/TextRange;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "newRawSelectionRange", "previousHandleOffset", "", "isStartHandle", "", "previousSelectionRange", "adjust-ZXO7KMw", "(Landroidx/compose/ui/text/TextLayoutResult;JIZLandroidx/compose/ui/text/TextRange;)J", "Companion", "foundation"})
public interface SelectionAdjustment {
    @NotNull
    public static final Companion Companion = androidx.compose.foundation.text.selection.SelectionAdjustment$Companion.$$INSTANCE;

    public long adjust-ZXO7KMw(@NotNull TextLayoutResult var1, long var2, int var4, boolean var5, @Nullable TextRange var6);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00100\u0015H\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"Landroidx/compose/foundation/text/selection/SelectionAdjustment$Companion;", "", "()V", "Character", "Landroidx/compose/foundation/text/selection/SelectionAdjustment;", "getCharacter", "()Landroidx/compose/foundation/text/selection/SelectionAdjustment;", "CharacterWithWordAccelerate", "getCharacterWithWordAccelerate", "None", "getNone", "Paragraph", "getParagraph", "Word", "getWord", "adjustByBoundary", "Landroidx/compose/ui/text/TextRange;", "textLayoutResult", "Landroidx/compose/ui/text/TextLayoutResult;", "newRawSelection", "boundaryFun", "Lkotlin/Function1;", "", "adjustByBoundary--Dv-ylE", "(Landroidx/compose/ui/text/TextLayoutResult;JLkotlin/jvm/functions/Function1;)J", "foundation"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final SelectionAdjustment None;
        @NotNull
        private static final SelectionAdjustment Character;
        @NotNull
        private static final SelectionAdjustment Word;
        @NotNull
        private static final SelectionAdjustment Paragraph;
        @NotNull
        private static final SelectionAdjustment CharacterWithWordAccelerate;

        private Companion() {
        }

        @NotNull
        public final SelectionAdjustment getNone() {
            return None;
        }

        @NotNull
        public final SelectionAdjustment getCharacter() {
            return Character;
        }

        @NotNull
        public final SelectionAdjustment getWord() {
            return Word;
        }

        @NotNull
        public final SelectionAdjustment getParagraph() {
            return Paragraph;
        }

        private final long adjustByBoundary--Dv-ylE(TextLayoutResult textLayoutResult, long newRawSelection, Function1<? super Integer, TextRange> boundaryFun2) {
            if (((CharSequence)textLayoutResult.getLayoutInput().getText()).length() == 0) {
                return TextRange.Companion.getZero-d9O1mEE();
            }
            int maxOffset = StringsKt.getLastIndex((CharSequence)((CharSequence)textLayoutResult.getLayoutInput().getText()));
            long startBoundary = ((TextRange)boundaryFun2.invoke((Object)RangesKt.coerceIn((int)TextRange.getStart-impl((long)newRawSelection), (int)0, (int)maxOffset))).unbox-impl();
            long endBoundary = ((TextRange)boundaryFun2.invoke((Object)RangesKt.coerceIn((int)TextRange.getEnd-impl((long)newRawSelection), (int)0, (int)maxOffset))).unbox-impl();
            int start = TextRange.getReversed-impl((long)newRawSelection) ? TextRange.getEnd-impl((long)startBoundary) : TextRange.getStart-impl((long)startBoundary);
            int end = TextRange.getReversed-impl((long)newRawSelection) ? TextRange.getStart-impl((long)endBoundary) : TextRange.getEnd-impl((long)endBoundary);
            return TextRangeKt.TextRange((int)start, (int)end);
        }

        @NotNull
        public final SelectionAdjustment getCharacterWithWordAccelerate() {
            return CharacterWithWordAccelerate;
        }

        public static final /* synthetic */ long access$adjustByBoundary--Dv-ylE(Companion $this, TextLayoutResult textLayoutResult, long newRawSelection, Function1 boundaryFun2) {
            return $this.adjustByBoundary--Dv-ylE(textLayoutResult, newRawSelection, (Function1<? super Integer, TextRange>)boundaryFun2);
        }

        static {
            $$INSTANCE = new Companion();
            None = new SelectionAdjustment(){

                public long adjust-ZXO7KMw(@NotNull TextLayoutResult textLayoutResult, long newRawSelectionRange, int previousHandleOffset, boolean isStartHandle, @Nullable TextRange previousSelectionRange) {
                    Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
                    return newRawSelectionRange;
                }
            };
            Character = new SelectionAdjustment(){

                public long adjust-ZXO7KMw(@NotNull TextLayoutResult textLayoutResult, long newRawSelectionRange, int previousHandleOffset, boolean isStartHandle, @Nullable TextRange previousSelectionRange) {
                    long l;
                    Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
                    if (TextRange.getCollapsed-impl((long)newRawSelectionRange)) {
                        TextRange textRange = previousSelectionRange;
                        boolean previousHandlesCrossed = textRange != null ? TextRange.getReversed-impl((long)textRange.unbox-impl()) : false;
                        l = SelectionAdjustmentKt.ensureAtLeastOneChar(TextRange.getStart-impl((long)newRawSelectionRange), StringsKt.getLastIndex((CharSequence)((CharSequence)textLayoutResult.getLayoutInput().getText())), isStartHandle, previousHandlesCrossed);
                    } else {
                        l = newRawSelectionRange;
                    }
                    return l;
                }
            };
            Word = new SelectionAdjustment(){

                public long adjust-ZXO7KMw(@NotNull TextLayoutResult textLayoutResult, long newRawSelectionRange, int previousHandleOffset, boolean isStartHandle, @Nullable TextRange previousSelectionRange) {
                    Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
                    return androidx.compose.foundation.text.selection.SelectionAdjustment$Companion.access$adjustByBoundary--Dv-ylE(androidx.compose.foundation.text.selection.SelectionAdjustment$Companion.$$INSTANCE, textLayoutResult, newRawSelectionRange, (Function1)new Function1<Integer, TextRange>((Object)textLayoutResult){

                        public final long invoke--jx7JFs(int p0) {
                            return ((TextLayoutResult)this.receiver).getWordBoundary--jx7JFs(p0);
                        }
                    });
                }
            };
            Paragraph = new SelectionAdjustment(){

                public long adjust-ZXO7KMw(@NotNull TextLayoutResult textLayoutResult, long newRawSelectionRange, int previousHandleOffset, boolean isStartHandle, @Nullable TextRange previousSelectionRange) {
                    Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
                    KFunction boundaryFun2 = (KFunction)new Function1<Integer, TextRange>((Object)textLayoutResult.getLayoutInput().getText()){

                        public final long invoke--jx7JFs(int p0) {
                            return StringHelpersKt.getParagraphBoundary((CharSequence)this.receiver, p0);
                        }
                    };
                    return androidx.compose.foundation.text.selection.SelectionAdjustment$Companion.access$adjustByBoundary--Dv-ylE(androidx.compose.foundation.text.selection.SelectionAdjustment$Companion.$$INSTANCE, textLayoutResult, newRawSelectionRange, (Function1)boundaryFun2);
                }
            };
            CharacterWithWordAccelerate = new SelectionAdjustment(){

                public long adjust-ZXO7KMw(@NotNull TextLayoutResult textLayoutResult, long newRawSelectionRange, int previousHandleOffset, boolean isStartHandle, @Nullable TextRange previousSelectionRange) {
                    Intrinsics.checkNotNullParameter((Object)textLayoutResult, (String)"textLayoutResult");
                    if (previousSelectionRange == null) {
                        return androidx.compose.foundation.text.selection.SelectionAdjustment$Companion.$$INSTANCE.getWord().adjust-ZXO7KMw(textLayoutResult, newRawSelectionRange, previousHandleOffset, isStartHandle, previousSelectionRange);
                    }
                    if (TextRange.getCollapsed-impl((long)newRawSelectionRange)) {
                        return SelectionAdjustmentKt.ensureAtLeastOneChar(TextRange.getStart-impl((long)newRawSelectionRange), StringsKt.getLastIndex((CharSequence)((CharSequence)textLayoutResult.getLayoutInput().getText())), isStartHandle, TextRange.getReversed-impl((long)previousSelectionRange.unbox-impl()));
                    }
                    int start = 0;
                    int end = 0;
                    if (isStartHandle) {
                        start = this.updateSelectionBoundary(textLayoutResult, TextRange.getStart-impl((long)newRawSelectionRange), previousHandleOffset, TextRange.getStart-impl((long)previousSelectionRange.unbox-impl()), TextRange.getEnd-impl((long)newRawSelectionRange), true, TextRange.getReversed-impl((long)newRawSelectionRange));
                        end = TextRange.getEnd-impl((long)newRawSelectionRange);
                    } else {
                        start = TextRange.getStart-impl((long)newRawSelectionRange);
                        end = this.updateSelectionBoundary(textLayoutResult, TextRange.getEnd-impl((long)newRawSelectionRange), previousHandleOffset, TextRange.getEnd-impl((long)previousSelectionRange.unbox-impl()), TextRange.getStart-impl((long)newRawSelectionRange), false, TextRange.getReversed-impl((long)newRawSelectionRange));
                    }
                    return TextRangeKt.TextRange((int)start, (int)end);
                }

                private final int updateSelectionBoundary(TextLayoutResult textLayoutResult, int newRawOffset, int previousRawOffset, int previousAdjustedOffset, int otherBoundaryOffset, boolean isStart, boolean isReversed) {
                    int previousLine;
                    if (newRawOffset == previousRawOffset) {
                        return previousAdjustedOffset;
                    }
                    int currentLine = textLayoutResult.getLineForOffset(newRawOffset);
                    if (currentLine != (previousLine = textLayoutResult.getLineForOffset(previousAdjustedOffset))) {
                        return this.snapToWordBoundary(textLayoutResult, newRawOffset, currentLine, otherBoundaryOffset, isStart, isReversed);
                    }
                    boolean isExpanding = this.isExpanding(newRawOffset, previousRawOffset, isStart, isReversed);
                    if (!isExpanding) {
                        return newRawOffset;
                    }
                    if (!this.isAtWordBoundary(textLayoutResult, previousAdjustedOffset)) {
                        return newRawOffset;
                    }
                    return this.snapToWordBoundary(textLayoutResult, newRawOffset, currentLine, otherBoundaryOffset, isStart, isReversed);
                }

                private final int snapToWordBoundary(TextLayoutResult textLayoutResult, int newRawOffset, int currentLine, int otherBoundaryOffset, boolean isStart, boolean isReversed) {
                    int end;
                    long wordBoundary = textLayoutResult.getWordBoundary--jx7JFs(newRawOffset);
                    int wordStartLine = textLayoutResult.getLineForOffset(TextRange.getStart-impl((long)wordBoundary));
                    int start = wordStartLine == currentLine ? TextRange.getStart-impl((long)wordBoundary) : textLayoutResult.getLineStart(currentLine);
                    int wordEndLine = textLayoutResult.getLineForOffset(TextRange.getEnd-impl((long)wordBoundary));
                    int n = end = wordEndLine == currentLine ? TextRange.getEnd-impl((long)wordBoundary) : TextLayoutResult.getLineEnd$default((TextLayoutResult)textLayoutResult, (int)currentLine, (boolean)false, (int)2, null);
                    if (start == otherBoundaryOffset) {
                        return end;
                    }
                    if (end == otherBoundaryOffset) {
                        return start;
                    }
                    int threshold = (start + end) / 2;
                    return isStart ^ isReversed ? (newRawOffset <= threshold ? start : end) : (newRawOffset >= threshold ? end : start);
                }

                private final boolean isAtWordBoundary(TextLayoutResult $this$isAtWordBoundary, int offset) {
                    long wordBoundary = $this$isAtWordBoundary.getWordBoundary--jx7JFs(offset);
                    return offset == TextRange.getStart-impl((long)wordBoundary) || offset == TextRange.getEnd-impl((long)wordBoundary);
                }

                private final boolean isExpanding(int newRawOffset, int previousRawOffset, boolean isStart, boolean previousReversed) {
                    if (previousRawOffset == -1) {
                        return true;
                    }
                    if (newRawOffset == previousRawOffset) {
                        return false;
                    }
                    return isStart ^ previousReversed ? newRawOffset < previousRawOffset : newRawOffset > previousRawOffset;
                }
            };
        }
    }
}

