/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.pager;

import androidx.compose.animation.core.AnimationSpec;
import androidx.compose.animation.core.AnimationSpecKt;
import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.MutatePriority;
import androidx.compose.foundation.gestures.ScrollExtensionsKt;
import androidx.compose.foundation.gestures.ScrollScope;
import androidx.compose.foundation.gestures.ScrollableState;
import androidx.compose.foundation.gestures.snapping.LazyListSnapLayoutInfoProviderKt;
import androidx.compose.foundation.interaction.InteractionSource;
import androidx.compose.foundation.lazy.LazyListItemInfo;
import androidx.compose.foundation.lazy.LazyListLayoutInfo;
import androidx.compose.foundation.lazy.LazyListState;
import androidx.compose.foundation.pager.AwaitLazyListStateSet;
import androidx.compose.foundation.pager.PagerState;
import androidx.compose.foundation.pager.PagerStateKt;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.Stable;
import androidx.compose.runtime.State;
import androidx.compose.runtime.saveable.ListSaverKt;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.ui.unit.Density;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\"\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 y2\u00020\u0001:\u0001yB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J3\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020\u00032\b\b\u0002\u0010_\u001a\u00020\u00052\u000e\b\u0002\u0010`\u001a\b\u0012\u0004\u0012\u00020\u00050aH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010bJ\u0011\u0010c\u001a\u00020]H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010dJ\u0010\u0010e\u001a\u00020\u00052\u0006\u0010f\u001a\u00020\u0005H\u0016J\u0015\u0010g\u001a\u00020]2\u0006\u0010h\u001a\u000206H\u0000\u00a2\u0006\u0002\biJB\u0010j\u001a\u00020]2\u0006\u0010k\u001a\u00020l2'\u0010m\u001a#\b\u0001\u0012\u0004\u0012\u00020o\u0012\n\u0012\b\u0012\u0004\u0012\u00020]0p\u0012\u0006\u0012\u0004\u0018\u00010q0n\u00a2\u0006\u0002\brH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010sJ#\u0010t\u001a\u00020]2\u0006\u0010^\u001a\u00020\u00032\b\b\u0002\u0010_\u001a\u00020\u0005H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010uJ\r\u0010v\u001a\u00020]H\u0000\u00a2\u0006\u0002\bwJ\f\u0010x\u001a\u00020\u0003*\u00020\u0003H\u0002R+\u0010\b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00038B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001c\u0010\nR\u001b\u0010\u001f\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u001e\u001a\u0004\b \u0010!R\u0014\u0010#\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010!R\u0016\u0010)\u001a\u0004\u0018\u00010\u00188@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010!R\u0011\u0010-\u001a\u00020.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0014R\u0014\u00102\u001a\u0002038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R/\u00107\u001a\u0004\u0018\u0001062\b\u0010\u0007\u001a\u0004\u0018\u0001068B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b<\u0010\u000e\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0014\u0010=\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\nR\u0014\u0010?\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\nR\u0014\u0010A\u001a\u00020\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010\nR+\u0010C\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00038@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\bF\u0010\u000e\u001a\u0004\bD\u0010\n\"\u0004\bE\u0010\fR\u0014\u0010G\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010!R\u001b\u0010I\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bK\u0010\u001e\u001a\u0004\bJ\u0010\nR+\u0010L\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00038B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\bO\u0010\u000e\u001a\u0004\bM\u0010\n\"\u0004\bN\u0010\fR+\u0010P\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00058@@@X\u0080\u008e\u0002\u00a2\u0006\u0012\n\u0004\bT\u0010\u000e\u001a\u0004\bQ\u0010!\"\u0004\bR\u0010SR\u001b\u0010U\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bW\u0010\u001e\u001a\u0004\bV\u0010\nR\u001a\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00180Y8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bZ\u0010[\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006z"}, d2={"Landroidx/compose/foundation/pager/PagerState;", "Landroidx/compose/foundation/gestures/ScrollableState;", "initialPage", "", "initialPageOffsetFraction", "", "(IF)V", "<set-?>", "animationTargetPage", "getAnimationTargetPage", "()I", "setAnimationTargetPage", "(I)V", "animationTargetPage$delegate", "Landroidx/compose/runtime/MutableState;", "awaitLazyListStateSet", "Landroidx/compose/foundation/pager/AwaitLazyListStateSet;", "canScrollBackward", "", "getCanScrollBackward", "()Z", "canScrollForward", "getCanScrollForward", "closestPageToSnappedPosition", "Landroidx/compose/foundation/lazy/LazyListItemInfo;", "getClosestPageToSnappedPosition", "()Landroidx/compose/foundation/lazy/LazyListItemInfo;", "currentPage", "getCurrentPage", "currentPage$delegate", "Landroidx/compose/runtime/State;", "currentPageOffsetFraction", "getCurrentPageOffsetFraction", "()F", "currentPageOffsetFraction$delegate", "density", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "distanceToSnapPosition", "getDistanceToSnapPosition", "firstVisiblePage", "getFirstVisiblePage$foundation", "getInitialPage", "getInitialPageOffsetFraction", "interactionSource", "Landroidx/compose/foundation/interaction/InteractionSource;", "getInteractionSource", "()Landroidx/compose/foundation/interaction/InteractionSource;", "isScrollInProgress", "layoutInfo", "Landroidx/compose/foundation/lazy/LazyListLayoutInfo;", "getLayoutInfo$foundation", "()Landroidx/compose/foundation/lazy/LazyListLayoutInfo;", "Landroidx/compose/foundation/lazy/LazyListState;", "lazyListState", "getLazyListState", "()Landroidx/compose/foundation/lazy/LazyListState;", "setLazyListState", "(Landroidx/compose/foundation/lazy/LazyListState;)V", "lazyListState$delegate", "pageAvailableSpace", "getPageAvailableSpace", "pageCount", "getPageCount$foundation", "pageSize", "getPageSize$foundation", "pageSpacing", "getPageSpacing$foundation", "setPageSpacing$foundation", "pageSpacing$delegate", "positionThresholdFraction", "getPositionThresholdFraction", "settledPage", "getSettledPage", "settledPage$delegate", "settledPageState", "getSettledPageState", "setSettledPageState", "settledPageState$delegate", "snapRemainingScrollOffset", "getSnapRemainingScrollOffset$foundation", "setSnapRemainingScrollOffset$foundation", "(F)V", "snapRemainingScrollOffset$delegate", "targetPage", "getTargetPage", "targetPage$delegate", "visiblePages", "", "getVisiblePages", "()Ljava/util/List;", "animateScrollToPage", "", "page", "pageOffsetFraction", "animationSpec", "Landroidx/compose/animation/core/AnimationSpec;", "(IFLandroidx/compose/animation/core/AnimationSpec;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitScrollDependencies", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispatchRawDelta", "delta", "loadNewState", "newState", "loadNewState$foundation", "scroll", "scrollPriority", "Landroidx/compose/foundation/MutatePriority;", "block", "Lkotlin/Function2;", "Landroidx/compose/foundation/gestures/ScrollScope;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Landroidx/compose/foundation/MutatePriority;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scrollToPage", "(IFLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateOnScrollStopped", "updateOnScrollStopped$foundation", "coerceInPageRange", "Companion", "foundation"})
@ExperimentalFoundationApi
@Stable
@SourceDebugExtension(value={"SMAP\nPagerState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PagerState.kt\nandroidx/compose/foundation/pager/PagerState\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n+ 3 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 PagerState.kt\nandroidx/compose/foundation/pager/PagerStateKt\n*L\n1#1,455:1\n76#2:456\n102#2,2:457\n76#2:459\n102#2,2:460\n76#2:462\n102#2,2:463\n76#2:484\n76#2:485\n102#2,2:486\n76#2:488\n102#2,2:489\n76#2:491\n76#2:492\n76#2:493\n171#3,13:465\n533#4,6:478\n452#5,4:494\n452#5,4:498\n452#5,4:502\n*S KotlinDebug\n*F\n+ 1 PagerState.kt\nandroidx/compose/foundation/pager/PagerState\n*L\n96#1:456\n96#1:457,2\n98#1:459\n98#1:460,2\n100#1:462\n100#1:463,2\n177#1:484\n179#1:485\n179#1:486,2\n181#1:488\n181#1:489,2\n191#1:491\n204#1:492\n238#1:493\n133#1:465,13\n144#1:478,6\n262#1:494,4\n312#1:498,4\n328#1:502,4\n*E\n"})
public final class PagerState
implements ScrollableState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int initialPage;
    private final float initialPageOffsetFraction;
    @NotNull
    private final MutableState snapRemainingScrollOffset$delegate;
    @NotNull
    private final MutableState lazyListState$delegate;
    @NotNull
    private final MutableState pageSpacing$delegate;
    @NotNull
    private final AwaitLazyListStateSet awaitLazyListStateSet;
    @NotNull
    private final State currentPage$delegate;
    @NotNull
    private final MutableState animationTargetPage$delegate;
    @NotNull
    private final MutableState settledPageState$delegate;
    @NotNull
    private final State settledPage$delegate;
    @NotNull
    private final State targetPage$delegate;
    @NotNull
    private final State currentPageOffsetFraction$delegate;
    public static final int $stable;
    @NotNull
    private static final Saver<PagerState, ?> Saver;

    public PagerState(int initialPage, float initialPageOffsetFraction) {
        this.initialPage = initialPage;
        this.initialPageOffsetFraction = initialPageOffsetFraction;
        double d = this.initialPageOffsetFraction;
        if (!(-0.5 <= d ? d <= 0.5 : false)) {
            boolean bl = false;
            String string = "initialPageOffsetFraction " + this.initialPageOffsetFraction + " is not within the range -0.5 to 0.5";
            throw new IllegalArgumentException(string.toString());
        }
        this.snapRemainingScrollOffset$delegate = SnapshotStateKt.mutableStateOf$default((Object)Float.valueOf(0.0f), null, (int)2, null);
        this.lazyListState$delegate = SnapshotStateKt.mutableStateOf$default(null, null, (int)2, null);
        this.pageSpacing$delegate = SnapshotStateKt.mutableStateOf$default((Object)0, null, (int)2, null);
        this.awaitLazyListStateSet = new AwaitLazyListStateSet();
        this.currentPage$delegate = SnapshotStateKt.derivedStateOf((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ PagerState this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                LazyListItemInfo lazyListItemInfo = PagerState.access$getClosestPageToSnappedPosition(this.this$0);
                return lazyListItemInfo != null ? lazyListItemInfo.getIndex() : this.this$0.getInitialPage();
            }
        }));
        this.animationTargetPage$delegate = SnapshotStateKt.mutableStateOf$default((Object)-1, null, (int)2, null);
        this.settledPageState$delegate = SnapshotStateKt.mutableStateOf$default((Object)this.initialPage, null, (int)2, null);
        this.settledPage$delegate = SnapshotStateKt.derivedStateOf((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ PagerState this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                return this.this$0.getPageCount$foundation() == 0 ? 0 : PagerState.access$coerceInPageRange(this.this$0, PagerState.access$getSettledPageState(this.this$0));
            }
        }));
        this.targetPage$delegate = SnapshotStateKt.derivedStateOf((Function0)((Function0)new Function0<Integer>(this){
            final /* synthetic */ PagerState this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Integer invoke() {
                int n;
                if (!this.this$0.isScrollInProgress()) {
                    n = this.this$0.getCurrentPage();
                } else if (PagerState.access$getAnimationTargetPage(this.this$0) != -1) {
                    n = PagerState.access$getAnimationTargetPage(this.this$0);
                } else if (this.this$0.getSnapRemainingScrollOffset$foundation() == 0.0f) {
                    n = Math.abs(this.this$0.getCurrentPageOffsetFraction()) >= Math.abs(PagerState.access$getPositionThresholdFraction(this.this$0)) ? this.this$0.getCurrentPage() + (int)Math.signum(this.this$0.getCurrentPageOffsetFraction()) : this.this$0.getCurrentPage();
                } else {
                    float pageDisplacement = this.this$0.getSnapRemainingScrollOffset$foundation() / (float)PagerState.access$getPageAvailableSpace(this.this$0);
                    n = this.this$0.getCurrentPage() + MathKt.roundToInt((float)pageDisplacement);
                }
                int finalPage = n;
                return PagerState.access$coerceInPageRange(this.this$0, finalPage);
            }
        }));
        this.currentPageOffsetFraction$delegate = SnapshotStateKt.derivedStateOf((Function0)((Function0)new Function0<Float>(this){
            final /* synthetic */ PagerState this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Float invoke() {
                LazyListItemInfo lazyListItemInfo = PagerState.access$getClosestPageToSnappedPosition(this.this$0);
                int currentPagePositionOffset = lazyListItemInfo != null ? lazyListItemInfo.getOffset() : 0;
                float pageUsedSpace = PagerState.access$getPageAvailableSpace(this.this$0);
                return Float.valueOf(pageUsedSpace == 0.0f ? this.this$0.getInitialPageOffsetFraction() : RangesKt.coerceIn((float)((float)(-currentPagePositionOffset) / pageUsedSpace), (float)-0.5f, (float)0.5f));
            }
        }));
    }

    public /* synthetic */ PagerState(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        this(n, f);
    }

    public final int getInitialPage() {
        return this.initialPage;
    }

    public final float getInitialPageOffsetFraction() {
        return this.initialPageOffsetFraction;
    }

    /*
     * WARNING - void declaration
     */
    public final float getSnapRemainingScrollOffset$foundation() {
        void $this$getValue$iv;
        State state = (State)this.snapRemainingScrollOffset$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).floatValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setSnapRemainingScrollOffset$foundation(float f) {
        void $this$setValue$iv;
        MutableState mutableState = this.snapRemainingScrollOffset$delegate;
        Object var3_3 = null;
        Float value$iv = Float.valueOf(f);
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final LazyListState getLazyListState() {
        void $this$getValue$iv;
        State state = (State)this.lazyListState$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (LazyListState)$this$getValue$iv.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setLazyListState(LazyListState lazyListState) {
        void $this$setValue$iv;
        MutableState mutableState = this.lazyListState$delegate;
        Object property$iv = null;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)lazyListState);
    }

    /*
     * WARNING - void declaration
     */
    public final int getPageSpacing$foundation() {
        void $this$getValue$iv;
        State state = (State)this.pageSpacing$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void setPageSpacing$foundation(int n) {
        void $this$setValue$iv;
        MutableState mutableState = this.pageSpacing$delegate;
        Object var3_3 = null;
        Integer value$iv = n;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    public final int getPageSize$foundation() {
        LazyListItemInfo lazyListItemInfo = (LazyListItemInfo)CollectionsKt.firstOrNull(this.getVisiblePages());
        return lazyListItemInfo != null ? lazyListItemInfo.getSize() : 0;
    }

    private final Density getDensity() {
        LazyListState lazyListState = this.getLazyListState();
        if (lazyListState == null || (lazyListState = lazyListState.getDensity$foundation()) == null) {
            lazyListState = PagerStateKt.access$getUnitDensity$p();
        }
        return lazyListState;
    }

    @NotNull
    public final LazyListLayoutInfo getLayoutInfo$foundation() {
        Object object = this.getLazyListState();
        if (object == null || (object = ((LazyListState)object).getLayoutInfo()) == null) {
            object = PagerStateKt.access$getEmptyLayoutInfo$p();
        }
        return object;
    }

    private final List<LazyListItemInfo> getVisiblePages() {
        return this.getLayoutInfo$foundation().getVisibleItemsInfo();
    }

    private final int getPageAvailableSpace() {
        return this.getPageSize$foundation() + this.getPageSpacing$foundation();
    }

    private final float getPositionThresholdFraction() {
        Density $this$_get_positionThresholdFraction__u24lambda_u241 = this.getDensity();
        boolean bl = false;
        float minThreshold = Math.min($this$_get_positionThresholdFraction__u24lambda_u241.toPx-0680j_4(PagerStateKt.getDefaultPositionThreshold()), (float)this.getPageSize$foundation() / 2.0f);
        return minThreshold / (float)this.getPageSize$foundation();
    }

    public final int getPageCount$foundation() {
        return this.getLayoutInfo$foundation().getTotalItemsCount();
    }

    /*
     * WARNING - void declaration
     */
    private final LazyListItemInfo getClosestPageToSnappedPosition() {
        Object v0;
        List<LazyListItemInfo> $this$fastMaxBy$iv = this.getVisiblePages();
        boolean $i$f$fastMaxBy = false;
        if ($this$fastMaxBy$iv.isEmpty()) {
            v0 = null;
        } else {
            void var3_3;
            LazyListItemInfo maxElem$iv;
            LazyListItemInfo it = maxElem$iv = $this$fastMaxBy$iv.get(0);
            boolean bl = false;
            float maxValue$iv = -Math.abs(LazyListSnapLayoutInfoProviderKt.calculateDistanceToDesiredSnapPosition(this.getDensity(), this.getLayoutInfo$foundation(), it, PagerStateKt.getSnapAlignmentStartToStart()));
            int i$iv = 1;
            int n = CollectionsKt.getLastIndex($this$fastMaxBy$iv);
            if (i$iv <= n) {
                while (true) {
                    LazyListItemInfo e$iv;
                    LazyListItemInfo it2 = e$iv = $this$fastMaxBy$iv.get(i$iv);
                    $i$a$-fastMaxBy-PagerState$closestPageToSnappedPosition$1 = false;
                    float v$iv = -Math.abs(LazyListSnapLayoutInfoProviderKt.calculateDistanceToDesiredSnapPosition(this.getDensity(), this.getLayoutInfo$foundation(), it2, PagerStateKt.getSnapAlignmentStartToStart()));
                    if (Float.compare(maxValue$iv, v$iv) < 0) {
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    }
                    if (i$iv == n) break;
                    ++i$iv;
                }
            }
            v0 = var3_3;
        }
        return v0;
    }

    @Nullable
    public final LazyListItemInfo getFirstVisiblePage$foundation() {
        LazyListItemInfo lazyListItemInfo;
        block1: {
            List<LazyListItemInfo> $this$lastOrNull$iv = this.getVisiblePages();
            boolean $i$f$lastOrNull = false;
            ListIterator<LazyListItemInfo> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                LazyListItemInfo element$iv;
                LazyListItemInfo it = element$iv = iterator$iv.previous();
                boolean bl = false;
                boolean bl2 = LazyListSnapLayoutInfoProviderKt.calculateDistanceToDesiredSnapPosition(this.getDensity(), this.getLayoutInfo$foundation(), it, PagerStateKt.getSnapAlignmentStartToStart()) <= 0.0f;
                if (!bl2) continue;
                lazyListItemInfo = element$iv;
                break block1;
            }
            lazyListItemInfo = null;
        }
        return lazyListItemInfo;
    }

    private final float getDistanceToSnapPosition() {
        float f;
        LazyListItemInfo lazyListItemInfo = this.getClosestPageToSnappedPosition();
        if (lazyListItemInfo != null) {
            LazyListItemInfo it = lazyListItemInfo;
            boolean bl = false;
            f = LazyListSnapLayoutInfoProviderKt.calculateDistanceToDesiredSnapPosition(this.getDensity(), this.getLayoutInfo$foundation(), it, PagerStateKt.getSnapAlignmentStartToStart());
        } else {
            f = 0.0f;
        }
        return f;
    }

    @NotNull
    public final InteractionSource getInteractionSource() {
        Object object = this.getLazyListState();
        if (object == null || (object = ((LazyListState)object).getInteractionSource()) == null) {
            object = PagerStateKt.access$getEmptyInteractionSources$p();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public final int getCurrentPage() {
        void $this$getValue$iv;
        State state = this.currentPage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final int getAnimationTargetPage() {
        void $this$getValue$iv;
        State state = (State)this.animationTargetPage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setAnimationTargetPage(int n) {
        void $this$setValue$iv;
        MutableState mutableState = this.animationTargetPage$delegate;
        Object var3_3 = null;
        Integer value$iv = n;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final int getSettledPageState() {
        void $this$getValue$iv;
        State state = (State)this.settledPageState$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void setSettledPageState(int n) {
        void $this$setValue$iv;
        MutableState mutableState = this.settledPageState$delegate;
        Object var3_3 = null;
        Integer value$iv = n;
        boolean $i$f$setValue = false;
        $this$setValue$iv.setValue((Object)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    public final int getSettledPage() {
        void $this$getValue$iv;
        State state = this.settledPage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public final int getTargetPage() {
        void $this$getValue$iv;
        State state = this.targetPage$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).intValue();
    }

    /*
     * WARNING - void declaration
     */
    public final float getCurrentPageOffsetFraction() {
        void $this$getValue$iv;
        State state = this.currentPageOffsetFraction$delegate;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return ((Number)$this$getValue$iv.getValue()).floatValue();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object scrollToPage(int var1_1, float var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof scrollToPage.1)) ** GOTO lbl-1000
        var8_4 = var3_3;
        if ((var8_4.label & -2147483648) != 0) {
            var8_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                int I$0;
                float F$0;
                /* synthetic */ Object result;
                final /* synthetic */ PagerState this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.scrollToPage(0, 0.0f, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$debugLog = false;
                $continuation.L$0 = this;
                $continuation.I$0 = page;
                $continuation.F$0 = pageOffsetFraction;
                $continuation.label = 1;
                v0 = this.awaitScrollDependencies((Continuation<? super Unit>)$continuation);
                if (v0 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl29
            }
            case 1: {
                pageOffsetFraction = $continuation.F$0;
                page = $continuation.I$0;
                this = (PagerState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                if (!(-0.5 <= ($i$f$debugLog = (double)pageOffsetFraction) ? $i$f$debugLog <= 0.5 : false)) {
                    $i$a$-require-PagerState$scrollToPage$3 = false;
                    $i$a$-require-PagerState$scrollToPage$3 = "pageOffsetFraction " + pageOffsetFraction + " is not within the range -0.5 to 0.5";
                    throw new IllegalArgumentException($i$a$-require-PagerState$scrollToPage$3.toString());
                }
                targetPage = this.coerceInPageRange(page);
                pageOffsetToCorrectPosition = MathKt.roundToInt((float)((float)this.getPageAvailableSpace() * pageOffsetFraction));
                v1 = this.getLazyListState();
                if (v1 == null) {
                    var6_13 = "Required value was null.";
                    throw new IllegalArgumentException(var6_13.toString());
                }
                $continuation.L$0 = null;
                $continuation.label = 2;
                v2 = v1.scrollToItem(targetPage, pageOffsetToCorrectPosition, (Continuation<? super Unit>)$continuation);
                if (v2 == var9_6) {
                    return var9_6;
                }
                ** GOTO lbl48
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl48:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object scrollToPage$default(PagerState pagerState, int n, float f, Continuation continuation, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        return pagerState.scrollToPage(n, f, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object animateScrollToPage(int var1_1, float var2_2, @NotNull AnimationSpec<Float> var3_3, @NotNull Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof animateScrollToPage.1)) ** GOTO lbl-1000
        var16_5 = var4_4;
        if ((var16_5.label & -2147483648) != 0) {
            var16_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                int I$0;
                int I$1;
                float F$0;
                /* synthetic */ Object result;
                final /* synthetic */ PagerState this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.animateScrollToPage(0, 0.0f, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (page == this.getCurrentPage()) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = animationSpec;
                $continuation.I$0 = page;
                $continuation.F$0 = pageOffsetFraction;
                $continuation.label = 1;
                v0 = this.awaitScrollDependencies((Continuation<? super Unit>)$continuation);
                if (v0 == var17_7) {
                    return var17_7;
                }
                ** GOTO lbl30
            }
            case 1: {
                pageOffsetFraction = $continuation.F$0;
                page = $continuation.I$0;
                animationSpec = (AnimationSpec)$continuation.L$1;
                this = (PagerState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl30:
                // 2 sources

                if (!(-0.5 <= (var5_8 = (double)pageOffsetFraction) ? var5_8 <= 0.5 : false)) {
                    $i$a$-require-PagerState$animateScrollToPage$2 = false;
                    $i$a$-require-PagerState$animateScrollToPage$2 = "pageOffsetFraction " + pageOffsetFraction + " is not within the range -0.5 to 0.5";
                    throw new IllegalArgumentException($i$a$-require-PagerState$animateScrollToPage$2.toString());
                }
                currentPosition = this.getCurrentPage();
                targetPage = this.coerceInPageRange(page);
                this.setAnimationTargetPage(targetPage);
                firstVisiblePageIndex = ((LazyListItemInfo)CollectionsKt.first(this.getVisiblePages())).getIndex();
                lastVisiblePageIndex = ((LazyListItemInfo)CollectionsKt.last(this.getVisiblePages())).getIndex();
                if ((page <= this.getCurrentPage() || page <= lastVisiblePageIndex) && (page >= this.getCurrentPage() || page >= firstVisiblePageIndex) || Math.abs(page - this.getCurrentPage()) < 3) ** GOTO lbl67
                preJumpPosition = page > this.getCurrentPage() ? RangesKt.coerceAtLeast((int)(page - this.getVisiblePages().size()), (int)currentPosition) : page + RangesKt.coerceAtMost((int)this.getVisiblePages().size(), (int)currentPosition);
                $i$f$debugLog = false;
                v1 = this.getLazyListState();
                if (v1 == null) {
                    var11_17 = "Required value was null.";
                    throw new IllegalArgumentException(var11_17.toString());
                }
                $continuation.L$0 = this;
                $continuation.L$1 = animationSpec;
                $continuation.F$0 = pageOffsetFraction;
                $continuation.I$0 = targetPage;
                $continuation.I$1 = preJumpPosition;
                $continuation.label = 2;
                v2 = LazyListState.scrollToItem$default(v1, preJumpPosition, 0, (Continuation)$continuation, 2, null);
                if (v2 == var17_7) {
                    return var17_7;
                }
                ** GOTO lbl66
            }
            case 2: {
                preJumpPosition = $continuation.I$1;
                targetPage = $continuation.I$0;
                pageOffsetFraction = $continuation.F$0;
                animationSpec = (AnimationSpec)$continuation.L$1;
                this = (PagerState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl66:
                // 2 sources

                currentPosition = preJumpPosition;
lbl67:
                // 2 sources

                targetOffset = targetPage * this.getPageAvailableSpace();
                currentOffset = currentPosition * this.getPageAvailableSpace();
                pageOffsetToSnappedPosition = this.getDistanceToSnapPosition() + pageOffsetFraction * (float)this.getPageAvailableSpace();
                displacement = (float)(targetOffset - currentOffset) + pageOffsetToSnappedPosition;
                $i$f$debugLog = false;
                v3 = this.getLazyListState();
                if (v3 == null) {
                    var14_21 = "Required value was null.";
                    throw new IllegalArgumentException(var14_21.toString());
                }
                $continuation.L$0 = this;
                $continuation.L$1 = null;
                $continuation.label = 3;
                v4 = ScrollExtensionsKt.animateScrollBy(v3, displacement, (AnimationSpec<Float>)animationSpec, (Continuation<? super Float>)$continuation);
                if (v4 == var17_7) {
                    return var17_7;
                }
                ** GOTO lbl89
            }
            case 3: {
                this = (PagerState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl89:
                // 2 sources

                this.setAnimationTargetPage(-1);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object animateScrollToPage$default(PagerState pagerState, int n, float f, AnimationSpec animationSpec, Continuation continuation, int n2, Object object) {
        if ((n2 & 2) != 0) {
            f = 0.0f;
        }
        if ((n2 & 4) != 0) {
            animationSpec = (AnimationSpec)AnimationSpecKt.spring$default((float)0.0f, (float)400.0f, null, (int)5, null);
        }
        return pagerState.animateScrollToPage(n, f, (AnimationSpec<Float>)animationSpec, (Continuation<? super Unit>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object awaitScrollDependencies(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof awaitScrollDependencies.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ PagerState this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PagerState.access$awaitScrollDependencies(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.awaitLazyListStateSet.waitFinalLazyListSetting((Continuation<? super Unit>)$continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (PagerState)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                v1 = this.getLazyListState();
                if (v1 == null) {
                    var2_5 = "Required value was null.";
                    throw new IllegalArgumentException(var2_5.toString());
                }
                $continuation.L$0 = null;
                $continuation.label = 2;
                v2 = v1.getAwaitLayoutModifier$foundation().waitForFirstLayout((Continuation<? super Unit>)$continuation);
                if (v2 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl35
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl35:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    public Object scroll(@NotNull MutatePriority scrollPriority, @NotNull Function2<? super ScrollScope, ? super Continuation<? super Unit>, ? extends Object> block2, @NotNull Continuation<? super Unit> $completion) {
        LazyListState lazyListState = this.getLazyListState();
        if (lazyListState != null) {
            Object object = lazyListState.scroll(scrollPriority, block2, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    public float dispatchRawDelta(float delta) {
        LazyListState lazyListState = this.getLazyListState();
        return lazyListState != null ? lazyListState.dispatchRawDelta(delta) : 0.0f;
    }

    @Override
    public boolean isScrollInProgress() {
        LazyListState lazyListState = this.getLazyListState();
        return lazyListState != null ? lazyListState.isScrollInProgress() : false;
    }

    @Override
    public boolean getCanScrollForward() {
        LazyListState lazyListState = this.getLazyListState();
        return lazyListState != null ? lazyListState.getCanScrollForward() : true;
    }

    @Override
    public boolean getCanScrollBackward() {
        LazyListState lazyListState = this.getLazyListState();
        return lazyListState != null ? lazyListState.getCanScrollBackward() : true;
    }

    private final int coerceInPageRange(int $this$coerceInPageRange) {
        return this.getPageCount$foundation() > 0 ? RangesKt.coerceIn((int)$this$coerceInPageRange, (int)0, (int)(this.getPageCount$foundation() - 1)) : 0;
    }

    public final void updateOnScrollStopped$foundation() {
        this.setSettledPageState(this.getCurrentPage());
    }

    public final void loadNewState$foundation(@NotNull LazyListState newState) {
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.setLazyListState(newState);
        this.awaitLazyListStateSet.onStateLoaded();
    }

    public PagerState() {
        this(0, 0.0f, 3, null);
    }

    public static final /* synthetic */ Object access$awaitScrollDependencies(PagerState $this, Continuation $completion) {
        return $this.awaitScrollDependencies((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ LazyListItemInfo access$getClosestPageToSnappedPosition(PagerState $this) {
        return $this.getClosestPageToSnappedPosition();
    }

    public static final /* synthetic */ int access$coerceInPageRange(PagerState $this, int $receiver) {
        return $this.coerceInPageRange($receiver);
    }

    public static final /* synthetic */ int access$getSettledPageState(PagerState $this) {
        return $this.getSettledPageState();
    }

    public static final /* synthetic */ int access$getAnimationTargetPage(PagerState $this) {
        return $this.getAnimationTargetPage();
    }

    public static final /* synthetic */ float access$getPositionThresholdFraction(PagerState $this) {
        return $this.getPositionThresholdFraction();
    }

    public static final /* synthetic */ int access$getPageAvailableSpace(PagerState $this) {
        return $this.getPageAvailableSpace();
    }

    static {
        Saver = ListSaverKt.listSaver((Function2)Companion.Saver.1.INSTANCE, (Function1)Companion.Saver.2.INSTANCE);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u0005\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Landroidx/compose/foundation/pager/PagerState$Companion;", "", "()V", "Saver", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/foundation/pager/PagerState;", "getSaver", "()Landroidx/compose/runtime/saveable/Saver;", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Saver<PagerState, ?> getSaver() {
            return Saver;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

