/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.v2;

import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.ScrollExtensionsKt;
import androidx.compose.foundation.lazy.LazyListItemInfo;
import androidx.compose.foundation.lazy.LazyListLayoutInfo;
import androidx.compose.foundation.lazy.LazyListState;
import androidx.compose.foundation.v2.LazyLineContentAdapter;
import androidx.compose.ui.unit.IntSize;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\nH\u0014J\b\u0010\u000e\u001a\u00020\u0006H\u0014J\u000f\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u0010J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u0019\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J!\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u0006H\u0014R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Landroidx/compose/foundation/v2/LazyListScrollbarAdapter;", "Landroidx/compose/foundation/v2/LazyLineContentAdapter;", "scrollState", "Landroidx/compose/foundation/lazy/LazyListState;", "(Landroidx/compose/foundation/lazy/LazyListState;)V", "lineSpacing", "", "getLineSpacing", "()I", "viewportSize", "", "getViewportSize", "()D", "averageVisibleLineSize", "contentPadding", "firstFloatingVisibleItemIndex", "()Ljava/lang/Integer;", "firstVisibleLine", "Landroidx/compose/foundation/v2/LazyLineContentAdapter$VisibleLine;", "scrollBy", "", "value", "", "(FLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "snapToLine", "lineIndex", "scrollOffset", "(IILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "totalLineCount", "foundation"})
public final class LazyListScrollbarAdapter
extends LazyLineContentAdapter {
    @NotNull
    private final LazyListState scrollState;

    public LazyListScrollbarAdapter(@NotNull LazyListState scrollState) {
        Intrinsics.checkNotNullParameter((Object)scrollState, (String)"scrollState");
        this.scrollState = scrollState;
    }

    @Override
    public double getViewportSize() {
        LazyListLayoutInfo $this$_get_viewportSize__u24lambda_u240 = this.scrollState.getLayoutInfo();
        boolean bl = false;
        return $this$_get_viewportSize__u24lambda_u240.getOrientation() == Orientation.Vertical ? IntSize.getHeight-impl((long)$this$_get_viewportSize__u24lambda_u240.getViewportSize-YbymL2g()) : IntSize.getWidth-impl((long)$this$_get_viewportSize__u24lambda_u240.getViewportSize-YbymL2g());
    }

    private final Integer firstFloatingVisibleItemIndex() {
        Integer n;
        List<LazyListItemInfo> $this$firstFloatingVisibleItemIndex_u24lambda_u241 = this.scrollState.getLayoutInfo().getVisibleItemsInfo();
        boolean bl = false;
        switch ($this$firstFloatingVisibleItemIndex_u24lambda_u241.size()) {
            case 0: {
                n = null;
                break;
            }
            case 1: {
                n = 0;
                break;
            }
            default: {
                LazyListItemInfo first = $this$firstFloatingVisibleItemIndex_u24lambda_u241.get(0);
                LazyListItemInfo second = $this$firstFloatingVisibleItemIndex_u24lambda_u241.get(1);
                n = first.getIndex() < second.getIndex() - 1 || first.getOffset() + first.getSize() + this.getLineSpacing() > second.getOffset() ? 1 : 0;
            }
        }
        return n;
    }

    @Override
    @Nullable
    protected LazyLineContentAdapter.VisibleLine firstVisibleLine() {
        Integer n = this.firstFloatingVisibleItemIndex();
        if (n == null) {
            return null;
        }
        int firstFloatingVisibleIndex = n;
        LazyListItemInfo firstFloatingItem = this.scrollState.getLayoutInfo().getVisibleItemsInfo().get(firstFloatingVisibleIndex);
        return new LazyLineContentAdapter.VisibleLine(firstFloatingItem.getIndex(), firstFloatingItem.getOffset());
    }

    @Override
    protected int totalLineCount() {
        return this.scrollState.getLayoutInfo().getTotalItemsCount();
    }

    @Override
    protected int contentPadding() {
        LazyListLayoutInfo $this$contentPadding_u24lambda_u242 = this.scrollState.getLayoutInfo();
        boolean bl = false;
        return $this$contentPadding_u24lambda_u242.getBeforeContentPadding() + $this$contentPadding_u24lambda_u242.getAfterContentPadding();
    }

    @Override
    @Nullable
    protected Object snapToLine(int lineIndex, int scrollOffset, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.scrollState.scrollToItem(lineIndex, scrollOffset, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    protected Object scrollBy(float value2, @NotNull Continuation<? super Unit> $completion) {
        Object object = ScrollExtensionsKt.scrollBy(this.scrollState, value2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    protected double averageVisibleLineSize() {
        double d;
        List<LazyListItemInfo> $this$averageVisibleLineSize_u24lambda_u243 = this.scrollState.getLayoutInfo().getVisibleItemsInfo();
        boolean bl = false;
        Integer n = this.firstFloatingVisibleItemIndex();
        if (n == null) {
            d = 0.0;
        } else {
            int firstFloatingIndex = n;
            LazyListItemInfo first = $this$averageVisibleLineSize_u24lambda_u243.get(firstFloatingIndex);
            LazyListItemInfo last = (LazyListItemInfo)CollectionsKt.last($this$averageVisibleLineSize_u24lambda_u243);
            int count = $this$averageVisibleLineSize_u24lambda_u243.size() - firstFloatingIndex;
            d = (double)(last.getOffset() + last.getSize() - first.getOffset() - (count - 1) * this.getLineSpacing()) / (double)count;
        }
        return d;
    }

    @Override
    protected int getLineSpacing() {
        return this.scrollState.getLayoutInfo().getMainAxisItemSpacing();
    }
}

