/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures;

import androidx.compose.foundation.gestures.AnimatedMouseWheelScrollNode;
import androidx.compose.foundation.gestures.MouseWheelScrollNode;
import androidx.compose.foundation.gestures.RawMouseWheelScrollNode;
import androidx.compose.foundation.gestures.ScrollConfig;
import androidx.compose.foundation.gestures.ScrollingLogic;
import androidx.compose.ui.node.ModifierNodeElement;
import androidx.compose.ui.platform.InspectorInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0002H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\f\u0010\u001a\u001a\u00020\u0018*\u00020\u001bH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Landroidx/compose/foundation/gestures/MouseWheelScrollableElement;", "Landroidx/compose/ui/node/ModifierNodeElement;", "Landroidx/compose/foundation/gestures/MouseWheelScrollNode;", "scrollingLogic", "Landroidx/compose/foundation/gestures/ScrollingLogic;", "mouseWheelScrollConfig", "Landroidx/compose/foundation/gestures/ScrollConfig;", "density", "", "(Landroidx/compose/foundation/gestures/ScrollingLogic;Landroidx/compose/foundation/gestures/ScrollConfig;F)V", "getDensity", "()F", "getMouseWheelScrollConfig", "()Landroidx/compose/foundation/gestures/ScrollConfig;", "getScrollingLogic", "()Landroidx/compose/foundation/gestures/ScrollingLogic;", "create", "equals", "", "other", "", "hashCode", "", "update", "", "node", "inspectableProperties", "Landroidx/compose/ui/platform/InspectorInfo;", "foundation"})
public final class MouseWheelScrollableElement
extends ModifierNodeElement<MouseWheelScrollNode> {
    @NotNull
    private final ScrollingLogic scrollingLogic;
    @NotNull
    private final ScrollConfig mouseWheelScrollConfig;
    private final float density;

    public MouseWheelScrollableElement(@NotNull ScrollingLogic scrollingLogic, @NotNull ScrollConfig mouseWheelScrollConfig, float density) {
        Intrinsics.checkNotNullParameter((Object)scrollingLogic, (String)"scrollingLogic");
        Intrinsics.checkNotNullParameter((Object)mouseWheelScrollConfig, (String)"mouseWheelScrollConfig");
        this.scrollingLogic = scrollingLogic;
        this.mouseWheelScrollConfig = mouseWheelScrollConfig;
        this.density = density;
    }

    @NotNull
    public final ScrollingLogic getScrollingLogic() {
        return this.scrollingLogic;
    }

    @NotNull
    public final ScrollConfig getMouseWheelScrollConfig() {
        return this.mouseWheelScrollConfig;
    }

    public final float getDensity() {
        return this.density;
    }

    @NotNull
    public MouseWheelScrollNode create() {
        return this.mouseWheelScrollConfig.isSmoothScrollingEnabled() ? (MouseWheelScrollNode)new AnimatedMouseWheelScrollNode(this.scrollingLogic, this.mouseWheelScrollConfig, this.density) : (MouseWheelScrollNode)new RawMouseWheelScrollNode(this.scrollingLogic, this.mouseWheelScrollConfig);
    }

    public void update(@NotNull MouseWheelScrollNode node) {
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        node.setScrollingLogic(this.scrollingLogic);
        node.setMouseWheelScrollConfig(this.mouseWheelScrollConfig);
    }

    public int hashCode() {
        int result2 = this.scrollingLogic.hashCode();
        result2 = 31 * result2 + this.mouseWheelScrollConfig.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MouseWheelScrollableElement)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scrollingLogic, (Object)((MouseWheelScrollableElement)((Object)other)).scrollingLogic)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mouseWheelScrollConfig, (Object)((MouseWheelScrollableElement)((Object)other)).mouseWheelScrollConfig);
    }

    public void inspectableProperties(@NotNull InspectorInfo $this$inspectableProperties) {
        Intrinsics.checkNotNullParameter((Object)$this$inspectableProperties, (String)"<this>");
    }
}

