/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text;

import androidx.compose.foundation.text.UndoManagerKt;
import androidx.compose.foundation.text.UndoManager_jvmKt;
import androidx.compose.ui.text.input.TextFieldValue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0015\u001a\u00020\u0010H\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0017\u001a\u00020\bJ\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/compose/foundation/text/UndoManager;", "", "maxStoredCharacters", "", "(I)V", "forceNextSnapshot", "", "lastSnapshot", "", "Ljava/lang/Long;", "getMaxStoredCharacters", "()I", "redoStack", "Landroidx/compose/foundation/text/UndoManager$Entry;", "storedCharacters", "undoStack", "", "makeSnapshot", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "redo", "removeLastUndo", "snapshotIfNeeded", "now", "undo", "Entry", "foundation"})
public final class UndoManager {
    private final int maxStoredCharacters;
    @Nullable
    private Entry undoStack;
    @Nullable
    private Entry redoStack;
    private int storedCharacters;
    @Nullable
    private Long lastSnapshot;
    private boolean forceNextSnapshot;

    public UndoManager(int maxStoredCharacters) {
        this.maxStoredCharacters = maxStoredCharacters;
    }

    public /* synthetic */ UndoManager(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 100000;
        }
        this(n);
    }

    public final int getMaxStoredCharacters() {
        return this.maxStoredCharacters;
    }

    public final void snapshotIfNeeded(@NotNull TextFieldValue value, long now) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                if (this.forceNextSnapshot) break block2;
                Long l = this.lastSnapshot;
                if (now <= (l != null ? l : 0L) + (long)UndoManagerKt.getSNAPSHOTS_INTERVAL_MILLIS()) break block3;
            }
            this.lastSnapshot = now;
            this.makeSnapshot(value);
        }
    }

    public static /* synthetic */ void snapshotIfNeeded$default(UndoManager undoManager, TextFieldValue textFieldValue, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = UndoManager_jvmKt.timeNowMillis();
        }
        undoManager.snapshotIfNeeded(textFieldValue, l);
    }

    public final void forceNextSnapshot() {
        this.forceNextSnapshot = true;
    }

    public final void makeSnapshot(@NotNull TextFieldValue value) {
        Entry entry;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.forceNextSnapshot = false;
        Entry entry2 = this.undoStack;
        if (Intrinsics.areEqual((Object)value, (Object)(entry2 != null ? entry2.getValue() : null))) {
            return;
        }
        if (Intrinsics.areEqual((Object)value.getText(), (entry = this.undoStack) != null && (entry = entry.getValue()) != null ? entry.getText() : null)) {
            Entry entry3 = this.undoStack;
            if (entry3 != null) {
                entry3.setValue(value);
            }
            return;
        }
        Entry entry4 = this.undoStack;
        this.undoStack = new Entry(entry4, value);
        this.redoStack = null;
        this.storedCharacters += value.getText().length();
        if (this.storedCharacters > this.maxStoredCharacters) {
            this.removeLastUndo();
        }
    }

    private final void removeLastUndo() {
        Entry entry;
        Entry entry2;
        Entry entry3 = entry2 = this.undoStack;
        if ((entry3 != null ? entry3.getNext() : null) == null) {
            return;
        }
        while (((entry = entry2) != null && (entry = entry.getNext()) != null ? entry.getNext() : null) != null) {
            entry2 = entry2.getNext();
        }
        Entry entry4 = entry2;
        if (entry4 != null) {
            entry4.setNext(null);
        }
    }

    @Nullable
    public final TextFieldValue undo() {
        TextFieldValue textFieldValue;
        Entry entry = this.undoStack;
        if (entry != null) {
            Entry undoEntry = entry;
            boolean bl = false;
            Entry entry2 = undoEntry.getNext();
            if (entry2 != null) {
                Entry nextEntry = entry2;
                boolean bl2 = false;
                this.undoStack = nextEntry;
                this.storedCharacters -= undoEntry.getValue().getText().length();
                TextFieldValue textFieldValue2 = undoEntry.getValue();
                Entry entry3 = this.redoStack;
                this.redoStack = new Entry(entry3, textFieldValue2);
                textFieldValue = nextEntry.getValue();
            } else {
                textFieldValue = null;
            }
        } else {
            textFieldValue = null;
        }
        return textFieldValue;
    }

    @Nullable
    public final TextFieldValue redo() {
        TextFieldValue textFieldValue;
        Entry entry = this.redoStack;
        if (entry != null) {
            Entry redoEntry = entry;
            boolean bl = false;
            this.redoStack = redoEntry.getNext();
            TextFieldValue textFieldValue2 = redoEntry.getValue();
            Entry entry2 = this.undoStack;
            this.undoStack = new Entry(entry2, textFieldValue2);
            this.storedCharacters += redoEntry.getValue().getText().length();
            textFieldValue = redoEntry.getValue();
        } else {
            textFieldValue = null;
        }
        return textFieldValue;
    }

    public UndoManager() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Landroidx/compose/foundation/text/UndoManager$Entry;", "", "next", "value", "Landroidx/compose/ui/text/input/TextFieldValue;", "(Landroidx/compose/foundation/text/UndoManager$Entry;Landroidx/compose/ui/text/input/TextFieldValue;)V", "getNext", "()Landroidx/compose/foundation/text/UndoManager$Entry;", "setNext", "(Landroidx/compose/foundation/text/UndoManager$Entry;)V", "getValue", "()Landroidx/compose/ui/text/input/TextFieldValue;", "setValue", "(Landroidx/compose/ui/text/input/TextFieldValue;)V", "foundation"})
    private static final class Entry {
        @Nullable
        private Entry next;
        @NotNull
        private TextFieldValue value;

        public Entry(@Nullable Entry next, @NotNull TextFieldValue value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.next = next;
            this.value = value;
        }

        public /* synthetic */ Entry(Entry entry, TextFieldValue textFieldValue, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                entry = null;
            }
            this(entry, textFieldValue);
        }

        @Nullable
        public final Entry getNext() {
            return this.next;
        }

        public final void setNext(@Nullable Entry entry) {
            this.next = entry;
        }

        @NotNull
        public final TextFieldValue getValue() {
            return this.value;
        }

        public final void setValue(@NotNull TextFieldValue textFieldValue) {
            Intrinsics.checkNotNullParameter((Object)textFieldValue, (String)"<set-?>");
            this.value = textFieldValue;
        }
    }
}

