/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.selection;

import androidx.compose.foundation.text.selection.MultiWidgetSelectionDelegateKt;
import androidx.compose.foundation.text.selection.Selectable;
import androidx.compose.foundation.text.selection.Selection;
import androidx.compose.foundation.text.selection.SelectionLayoutBuilder;
import androidx.compose.foundation.text.selection.TextSelectionDelegateKt;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.text.AnnotatedString;
import androidx.compose.ui.text.TextLayoutResult;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.unit.IntSize;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b!\u0010\"J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\n\u0010#\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\u001d\u0010'\u001a\u00020(2\u0006\u0010\u0018\u001a\u00020\u000bH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b)\u0010*J\n\u0010+\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010,\u001a\u00020-H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\u000b*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006."}, d2={"Landroidx/compose/foundation/text/selection/MultiWidgetSelectionDelegate;", "Landroidx/compose/foundation/text/selection/Selectable;", "selectableId", "", "coordinatesCallback", "Lkotlin/Function0;", "Landroidx/compose/ui/layout/LayoutCoordinates;", "layoutResultCallback", "Landroidx/compose/ui/text/TextLayoutResult;", "(JLkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "_previousLastVisibleOffset", "", "_previousTextLayoutResult", "getSelectableId", "()J", "lastVisibleOffset", "getLastVisibleOffset", "(Landroidx/compose/ui/text/TextLayoutResult;)I", "appendSelectableInfoToBuilder", "", "builder", "Landroidx/compose/foundation/text/selection/SelectionLayoutBuilder;", "getBoundingBox", "Landroidx/compose/ui/geometry/Rect;", "offset", "getCenterYForOffset", "", "getHandlePosition", "Landroidx/compose/ui/geometry/Offset;", "selection", "Landroidx/compose/foundation/text/selection/Selection;", "isStartHandle", "", "getHandlePosition-dBAh8RU", "(Landroidx/compose/foundation/text/selection/Selection;Z)J", "getLayoutCoordinates", "getLineHeight", "getLineLeft", "getLineRight", "getRangeOfLineContaining", "Landroidx/compose/ui/text/TextRange;", "getRangeOfLineContaining--jx7JFs", "(I)J", "getSelectAllSelection", "getText", "Landroidx/compose/ui/text/AnnotatedString;", "foundation"})
@StabilityInferred(parameters=0)
public final class MultiWidgetSelectionDelegate
implements Selectable {
    private final long selectableId;
    @NotNull
    private final Function0<LayoutCoordinates> coordinatesCallback;
    @NotNull
    private final Function0<TextLayoutResult> layoutResultCallback;
    @Nullable
    private TextLayoutResult _previousTextLayoutResult;
    private int _previousLastVisibleOffset;
    public static final int $stable = 8;

    public MultiWidgetSelectionDelegate(long selectableId2, @NotNull Function0<? extends LayoutCoordinates> coordinatesCallback, @NotNull Function0<TextLayoutResult> layoutResultCallback) {
        Intrinsics.checkNotNullParameter(coordinatesCallback, (String)"coordinatesCallback");
        Intrinsics.checkNotNullParameter(layoutResultCallback, (String)"layoutResultCallback");
        this.selectableId = selectableId2;
        this.coordinatesCallback = coordinatesCallback;
        this.layoutResultCallback = layoutResultCallback;
        this._previousLastVisibleOffset = -1;
    }

    @Override
    public long getSelectableId() {
        return this.selectableId;
    }

    private final synchronized int getLastVisibleOffset(TextLayoutResult $this$lastVisibleOffset) {
        if (this._previousTextLayoutResult != $this$lastVisibleOffset) {
            int n;
            if (!$this$lastVisibleOffset.getDidOverflowHeight() || $this$lastVisibleOffset.getMultiParagraph().getDidExceedMaxLines()) {
                n = $this$lastVisibleOffset.getLineCount() - 1;
            } else {
                int finalVisibleLine;
                for (finalVisibleLine = RangesKt.coerceAtMost((int)$this$lastVisibleOffset.getLineForVerticalPosition((float)IntSize.getHeight-impl((long)$this$lastVisibleOffset.getSize-YbymL2g())), (int)($this$lastVisibleOffset.getLineCount() - 1)); finalVisibleLine >= 0 && $this$lastVisibleOffset.getLineTop(finalVisibleLine) >= (float)IntSize.getHeight-impl((long)$this$lastVisibleOffset.getSize-YbymL2g()); --finalVisibleLine) {
                }
                n = RangesKt.coerceAtLeast((int)finalVisibleLine, (int)0);
            }
            int lastVisibleLine = n;
            this._previousLastVisibleOffset = $this$lastVisibleOffset.getLineEnd(lastVisibleLine, true);
            this._previousTextLayoutResult = $this$lastVisibleOffset;
        }
        return this._previousLastVisibleOffset;
    }

    @Override
    public void appendSelectableInfoToBuilder(@NotNull SelectionLayoutBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        LayoutCoordinates layoutCoordinates = this.getLayoutCoordinates();
        if (layoutCoordinates == null) {
            return;
        }
        LayoutCoordinates layoutCoordinates2 = layoutCoordinates;
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        long relativePosition = builder.getContainerCoordinates().localPositionOf-R5De75A(layoutCoordinates2, Offset.Companion.getZero-F1C5BW0());
        long localPosition = Offset.minus-MK-Hz9U((long)builder.getCurrentPosition-F1C5BW0(), (long)relativePosition);
        long localPreviousHandlePosition = OffsetKt.isUnspecified-k-4lQ0M((long)builder.getPreviousHandlePosition-F1C5BW0()) ? Offset.Companion.getUnspecified-F1C5BW0() : Offset.minus-MK-Hz9U((long)builder.getPreviousHandlePosition-F1C5BW0(), (long)relativePosition);
        MultiWidgetSelectionDelegateKt.appendSelectableInfo-Parwq6A(builder, textLayoutResult2, localPosition, localPreviousHandlePosition, this.getSelectableId());
    }

    @Override
    @Nullable
    public Selection getSelectAllSelection() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return null;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int start = 0;
        int end = textLayoutResult2.getLayoutInput().getText().length();
        return new Selection(new Selection.AnchorInfo(textLayoutResult2.getBidiRunDirection(start), start, this.getSelectableId()), new Selection.AnchorInfo(textLayoutResult2.getBidiRunDirection(Math.max(end - 1, 0)), end, this.getSelectableId()), false);
    }

    @Override
    public long getHandlePosition-dBAh8RU(@NotNull Selection selection, boolean isStartHandle) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        if (isStartHandle && selection.getStart().getSelectableId() != this.getSelectableId() || !isStartHandle && selection.getEnd().getSelectableId() != this.getSelectableId()) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        if (this.getLayoutCoordinates() == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Offset.Companion.getUnspecified-F1C5BW0();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int offset = isStartHandle ? selection.getStart().getOffset() : selection.getEnd().getOffset();
        int coercedOffset = RangesKt.coerceIn((int)offset, (int)0, (int)this.getLastVisibleOffset(textLayoutResult2));
        return TextSelectionDelegateKt.getSelectionHandleCoordinates(textLayoutResult2, coercedOffset, isStartHandle, selection.getHandlesCrossed());
    }

    @Override
    @Nullable
    public LayoutCoordinates getLayoutCoordinates() {
        LayoutCoordinates layoutCoordinates = (LayoutCoordinates)this.coordinatesCallback.invoke();
        if (layoutCoordinates == null || !layoutCoordinates.isAttached()) {
            return null;
        }
        return layoutCoordinates;
    }

    @Override
    @NotNull
    public AnnotatedString getText() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return new AnnotatedString("", null, null, 6, null);
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return textLayoutResult2.getLayoutInput().getText();
    }

    @Override
    @NotNull
    public Rect getBoundingBox(int offset) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return Rect.Companion.getZero();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int textLength = textLayoutResult2.getLayoutInput().getText().length();
        if (textLength < 1) {
            return Rect.Companion.getZero();
        }
        return textLayoutResult2.getBoundingBox(RangesKt.coerceIn((int)offset, (int)0, (int)(textLength - 1)));
    }

    @Override
    public float getLineLeft(int offset) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return -1.0f;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int line = textLayoutResult2.getLineForOffset(offset);
        if (line >= textLayoutResult2.getLineCount()) {
            return -1.0f;
        }
        return textLayoutResult2.getLineLeft(line);
    }

    @Override
    public float getLineRight(int offset) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return -1.0f;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int line = textLayoutResult2.getLineForOffset(offset);
        if (line >= textLayoutResult2.getLineCount()) {
            return -1.0f;
        }
        return textLayoutResult2.getLineRight(line);
    }

    @Override
    public float getCenterYForOffset(int offset) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return -1.0f;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int line = textLayoutResult2.getLineForOffset(offset);
        if (line >= textLayoutResult2.getLineCount()) {
            return -1.0f;
        }
        float top = textLayoutResult2.getLineTop(line);
        float bottom = textLayoutResult2.getLineBottom(line);
        return (bottom - top) / (float)2 + top;
    }

    @Override
    public long getRangeOfLineContaining--jx7JFs(int offset) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return TextRange.Companion.getZero-d9O1mEE();
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int visibleTextLength = this.getLastVisibleOffset(textLayoutResult2);
        if (visibleTextLength < 1) {
            return TextRange.Companion.getZero-d9O1mEE();
        }
        int line = textLayoutResult2.getLineForOffset(RangesKt.coerceIn((int)offset, (int)0, (int)(visibleTextLength - 1)));
        return TextRangeKt.TextRange((int)textLayoutResult2.getLineStart(line), (int)textLayoutResult2.getLineEnd(line, true));
    }

    @Override
    public int getLastVisibleOffset() {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return 0;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        return this.getLastVisibleOffset(textLayoutResult2);
    }

    @Override
    public float getLineHeight(int offset) {
        TextLayoutResult textLayoutResult = (TextLayoutResult)this.layoutResultCallback.invoke();
        if (textLayoutResult == null) {
            return 0.0f;
        }
        TextLayoutResult textLayoutResult2 = textLayoutResult;
        int textLength = textLayoutResult2.getLayoutInput().getText().length();
        if (textLength < 1) {
            return 0.0f;
        }
        int line = textLayoutResult2.getLineForOffset(RangesKt.coerceIn((int)offset, (int)0, (int)(textLength - 1)));
        return textLayoutResult2.getMultiParagraph().getLineHeight(line);
    }
}

