/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.lazy.grid;

import androidx.compose.foundation.lazy.grid.LazyGridItemPlacementAnimatorKt;
import androidx.compose.foundation.lazy.grid.LazyGridMeasuredItem;
import androidx.compose.foundation.lazy.layout.LazyLayoutAnimation;
import androidx.compose.foundation.lazy.layout.LazyLayoutAnimationSpecsNode;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R0\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0019"}, d2={"Landroidx/compose/foundation/lazy/grid/ItemInfo;", "", "crossAxisSize", "", "crossAxisOffset", "(II)V", "<set-?>", "", "Landroidx/compose/foundation/lazy/layout/LazyLayoutAnimation;", "animations", "getAnimations", "()[Landroidx/compose/foundation/lazy/layout/LazyLayoutAnimation;", "[Landroidx/compose/foundation/lazy/layout/LazyLayoutAnimation;", "getCrossAxisOffset", "()I", "setCrossAxisOffset", "(I)V", "getCrossAxisSize", "setCrossAxisSize", "updateAnimation", "", "positionedItem", "Landroidx/compose/foundation/lazy/grid/LazyGridMeasuredItem;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "foundation"})
final class ItemInfo {
    private int crossAxisSize;
    private int crossAxisOffset;
    @NotNull
    private LazyLayoutAnimation[] animations;

    public ItemInfo(int crossAxisSize, int crossAxisOffset) {
        this.crossAxisSize = crossAxisSize;
        this.crossAxisOffset = crossAxisOffset;
        this.animations = LazyGridItemPlacementAnimatorKt.access$getEmptyArray$p();
    }

    public final int getCrossAxisSize() {
        return this.crossAxisSize;
    }

    public final void setCrossAxisSize(int n) {
        this.crossAxisSize = n;
    }

    public final int getCrossAxisOffset() {
        return this.crossAxisOffset;
    }

    public final void setCrossAxisOffset(int n) {
        this.crossAxisOffset = n;
    }

    @NotNull
    public final LazyLayoutAnimation[] getAnimations() {
        return this.animations;
    }

    public final void updateAnimation(@NotNull LazyGridMeasuredItem positionedItem, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)positionedItem, (String)"positionedItem");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        int n = this.animations.length;
        for (int i = positionedItem.getPlaceablesCount(); i < n; ++i) {
            LazyLayoutAnimation lazyLayoutAnimation = this.animations[i];
            if (lazyLayoutAnimation == null) continue;
            lazyLayoutAnimation.stopAnimations();
        }
        if (this.animations.length != positionedItem.getPlaceablesCount()) {
            LazyLayoutAnimation[] lazyLayoutAnimationArray = Arrays.copyOf(this.animations, positionedItem.getPlaceablesCount());
            Intrinsics.checkNotNullExpressionValue((Object)lazyLayoutAnimationArray, (String)"copyOf(...)");
            this.animations = lazyLayoutAnimationArray;
        }
        int n2 = positionedItem.getPlaceablesCount();
        for (n = 0; n < n2; ++n) {
            int index2 = n;
            boolean bl = false;
            LazyLayoutAnimationSpecsNode specs = LazyGridItemPlacementAnimatorKt.access$getSpecs(positionedItem.getParentData(index2));
            if (specs == null) {
                LazyLayoutAnimation lazyLayoutAnimation = this.animations[index2];
                if (lazyLayoutAnimation != null) {
                    lazyLayoutAnimation.stopAnimations();
                }
                this.animations[index2] = null;
                continue;
            }
            LazyLayoutAnimation lazyLayoutAnimation = this.animations[index2];
            if (lazyLayoutAnimation == null) {
                LazyLayoutAnimation lazyLayoutAnimation2;
                LazyLayoutAnimation it = lazyLayoutAnimation2 = new LazyLayoutAnimation(coroutineScope);
                boolean bl2 = false;
                this.animations[index2] = it;
                lazyLayoutAnimation = lazyLayoutAnimation2;
            }
            LazyLayoutAnimation item2 = lazyLayoutAnimation;
            item2.setAppearanceSpec(specs.getAppearanceSpec());
            item2.setPlacementSpec(specs.getPlacementSpec());
        }
    }
}

