/*
 * Copyright 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.foundation.text.l10n

import androidx.compose.foundation.text.Strings
import androidx.compose.foundation.text.Translations

@Suppress("UnusedReceiverParameter", "DuplicatedCode")
internal fun Translations.km() = mapOf(
    Strings.SelectAll to "ជ្រើសរើស​ទាំងអស់",
    Strings.Cut to "កាត់",
    Strings.Copy to "ចម្លង",
    Strings.Paste to "ដាក់ចូល",
    Strings.Autofill to "បំពេញ​ដោយស្វ័យ​ប្រវត្តិ",
)
