/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.desktop.application.internal;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Properties;

public class JdkVersionProbe {
    public static final String JDK_MAJOR_VERSION_KEY = "jdk.major.version";
    public static final String JDK_VENDOR_KEY = "jdk.vendor";

    public static void main(String[] args) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(JDK_MAJOR_VERSION_KEY, JdkVersionProbe.getJDKMajorVersion());
        properties.setProperty(JDK_VENDOR_KEY, System.getProperty("java.vendor"));
        properties.storeToXML(System.out, null);
    }

    private static String getJDKMajorVersion() {
        Class<Runtime> runtimeClass = Runtime.class;
        try {
            Method version = runtimeClass.getMethod("version", new Class[0]);
            Object runtimeVer = version.invoke(runtimeClass, new Object[0]);
            Class<?> runtimeVerClass = runtimeVer.getClass();
            try {
                int feature = (Integer)runtimeVerClass.getMethod("feature", new Class[0]).invoke(runtimeVer, new Object[0]);
                return Integer.valueOf(feature).toString();
            }
            catch (NoSuchMethodException e) {
                int major = (Integer)runtimeVerClass.getMethod("major", new Class[0]).invoke(runtimeVer, new Object[0]);
                return Integer.valueOf(major).toString();
            }
        }
        catch (Exception e) {
            String javaVersion = System.getProperty("java.version");
            String[] parts = javaVersion.split("\\.");
            if (parts.length > 2 && "1".equalsIgnoreCase(parts[0])) {
                return parts[1];
            }
            throw new IllegalStateException("Could not determine JDK version from string: '" + javaVersion + "'");
        }
    }
}

