/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.ComposeHotReloadProcessManagerTask;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.PidFileInfo;
import org.jetbrains.compose.reload.core.PidFileInfoKt;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.gradle.Future;
import org.jetbrains.compose.reload.gradle.LifecycleKt;
import org.jetbrains.compose.reload.gradle.PluginStage;
import org.jetbrains.compose.reload.gradle.PluginStageKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationClient;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientRole;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u001a\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002\"+\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001*\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"hotProcessManagerTask", "Lorg/jetbrains/compose/reload/gradle/Future;", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/jetbrains/compose/reload/ComposeHotReloadProcessManagerTask;", "Lorg/gradle/api/Project;", "getHotProcessManagerTask", "(Lorg/gradle/api/Project;)Lorg/jetbrains/compose/reload/gradle/Future;", "hotProcessManagerTask$delegate", "Lkotlin/properties/ReadOnlyProperty;", "createShutdownAction", "Ljava/lang/Runnable;", "pidfile", "Ljava/nio/file/Path;", "logger", "Lorg/gradle/api/logging/Logger;", "shutdownApplication", "", "hot-reload-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nhotProcessManagerTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 hotProcessManagerTask.kt\norg/jetbrains/compose/reload/HotProcessManagerTaskKt\n+ 2 Either.kt\norg/jetbrains/compose/reload/core/EitherKt\n*L\n1#1,87:1\n29#2,3:88\n*S KotlinDebug\n*F\n+ 1 hotProcessManagerTask.kt\norg/jetbrains/compose/reload/HotProcessManagerTaskKt\n*L\n62#1:88,3\n*E\n"})
public final class HotProcessManagerTaskKt {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final ReadOnlyProperty hotProcessManagerTask$delegate;

    @NotNull
    public static final Future<TaskProvider<ComposeHotReloadProcessManagerTask>> getHotProcessManagerTask(@NotNull Project $this$hotProcessManagerTask) {
        Intrinsics.checkNotNullParameter((Object)$this$hotProcessManagerTask, (String)"<this>");
        return (Future)hotProcessManagerTask$delegate.getValue((Object)$this$hotProcessManagerTask, $$delegatedProperties[0]);
    }

    @NotNull
    public static final Runnable createShutdownAction(@NotNull Path pidfile, @Nullable Logger logger) {
        Intrinsics.checkNotNullParameter((Object)pidfile, (String)"pidfile");
        return () -> HotProcessManagerTaskKt.createShutdownAction$lambda$0(pidfile, logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void shutdownApplication(Path pidfile, Logger logger) {
        Either $this$leftOr$iv = PidFileInfoKt.PidFileInfo((Path)pidfile);
        boolean $i$f$leftOr = false;
        Either either = $this$leftOr$iv;
        if (!(either instanceof Left)) {
            if (either instanceof Right) {
                Right it = (Right)$this$leftOr$iv;
                boolean bl = false;
                return;
            }
            throw new NoWhenBranchMatchedException();
        }
        PidFileInfo info = (PidFileInfo)((Left)$this$leftOr$iv).getValue();
        Long l = info.getPid();
        if (l == null) {
            return;
        }
        long pid = l;
        Integer n = info.getOrchestrationPort();
        if (n == null) {
            return;
        }
        int port = n;
        Optional<ProcessHandle> optional = ProcessHandle.of(pid);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        ProcessHandle processHandle = (ProcessHandle)OptionalsKt.getOrNull(optional);
        if (processHandle == null) {
            return;
        }
        ProcessHandle process = processHandle;
        Logger logger2 = logger;
        if (logger2 != null) {
            logger2.quiet("Sending 'ShutdownRequest' to '" + port + "'");
        }
        AutoCloseable autoCloseable = (AutoCloseable)OrchestrationClientKt.connectOrchestrationClient((OrchestrationClientRole)OrchestrationClientRole.Tooling, (int)port);
        Throwable throwable = null;
        try {
            ProcessHandle processHandle2;
            OrchestrationClient client = (OrchestrationClient)autoCloseable;
            boolean bl = false;
            Path path = pidfile.toAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
            client.sendMessage((OrchestrationMessage)new OrchestrationMessage.ShutdownRequest("Gradle Build cancelled", path.toFile(), Long.valueOf(pid))).get(15L, TimeUnit.SECONDS);
            Logger logger3 = logger;
            if (logger3 != null) {
                logger3.quiet("Waiting for process to exit. PID: '" + pid + "'");
            }
            try {
                processHandle2 = process.onExit().get(5L, TimeUnit.SECONDS);
            }
            catch (Throwable t) {
                Logger logger4 = logger;
                if (logger4 != null) {
                    logger4.error("Failed to shutdown process: PID '" + pid + "', orchestrationPort: '" + port + "'", t);
                }
                throw t;
            }
            ProcessHandle processHandle3 = processHandle2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    static /* synthetic */ void shutdownApplication$default(Path path, Logger logger, int n, Object object) {
        if ((n & 2) != 0) {
            logger = null;
        }
        HotProcessManagerTaskKt.shutdownApplication(path, logger);
    }

    private static final void createShutdownAction$lambda$0(Path $pidfile, Logger $logger) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists($pidfile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        HotProcessManagerTaskKt.shutdownApplication($pidfile, $logger);
    }

    public static final /* synthetic */ void access$shutdownApplication(Path pidfile, Logger logger) {
        HotProcessManagerTaskKt.shutdownApplication(pidfile, logger);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(HotProcessManagerTaskKt.class, "hotProcessManagerTask", "getHotProcessManagerTask(Lorg/gradle/api/Project;)Lorg/jetbrains/compose/reload/gradle/Future;", 1)))};
        $$delegatedProperties = kPropertyArray;
        hotProcessManagerTask$delegate = LifecycleKt.projectFuture((Function2)((Function2)new Function2<Project, Continuation<? super TaskProvider<ComposeHotReloadProcessManagerTask>>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$projectFuture = (Project)this.L$0;
                        this.L$0 = $this$projectFuture;
                        this.label = 1;
                        v0 = PluginStageKt.await((PluginStage)PluginStage.EagerConfiguration, (Continuation)((Continuation)this));
                        if (v0 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        $this$projectFuture = (Project)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        v1 = $this$projectFuture.getProject().getTasks();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getTasks(...)");
                        var3_4 = v1;
                        name$iv = "composeHotReloadProcessManager";
                        $i$f$register = false;
                        v2 = $this$register$iv.register(name$iv, ComposeHotReloadProcessManagerTask.class);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"register(name, T::class.java)");
                        return v2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(Project p1, Continuation<? super TaskProvider<ComposeHotReloadProcessManagerTask>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }
}

