/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.Template;
import org.jetbrains.compose.reload.core.TemplateBuilder;
import org.jetbrains.compose.reload.core.TemplateKt;
import org.jetbrains.compose.reload.core.TryKt;
import org.jetbrains.compose.reload.gradle.InternalHotReloadGradleApi;
import org.jetbrains.compose.reload.orchestration.OrchestrationClient;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientRole;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;

@DisableCachingByDefault(because="Should always run")
@InternalHotReloadGradleApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H'J\b\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u00020\r8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/compose/reload/HotReloadTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "rootProjectDirectory", "Lorg/gradle/api/file/Directory;", "kotlin.jvm.PlatformType", "agentPort", "Lorg/gradle/api/provider/Property;", "", "getAgentPort", "()Lorg/gradle/api/provider/Property;", "pendingRequestFile", "Lorg/gradle/api/file/RegularFileProperty;", "getPendingRequestFile", "()Lorg/gradle/api/file/RegularFileProperty;", "getCancellationToken", "Lorg/gradle/initialization/BuildCancellationToken;", "execute", "", "reloadReport", "", "request", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage$ReloadClassesRequest;", "hot-reload-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nhotReloadTasks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 hotReloadTasks.kt\norg/jetbrains/compose/reload/HotReloadTask\n+ 2 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 utils.kt\norg/jetbrains/compose/reload/gradle/UtilsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 Template.kt\norg/jetbrains/compose/reload/core/TemplateKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,159:1\n59#2:160\n1#3:161\n148#4,3:162\n37#5,2:165\n39#6:167\n25#6,10:168\n35#6:189\n12734#7,3:178\n12734#7,3:181\n12734#7,3:184\n13409#7,2:187\n*S KotlinDebug\n*F\n+ 1 hotReloadTasks.kt\norg/jetbrains/compose/reload/HotReloadTask\n*L\n93#1:160\n112#1:162,3\n130#1:165,2\n144#1:167\n144#1:168,10\n144#1:189\n147#1:178,3\n148#1:181,3\n149#1:184,3\n151#1:187,2\n*E\n"})
public abstract class HotReloadTask
extends DefaultTask {
    private final Directory rootProjectDirectory = this.getProject().getRootProject().getLayout().getProjectDirectory();
    @NotNull
    private final Property<Integer> agentPort;
    @NotNull
    private final RegularFileProperty pendingRequestFile;

    public HotReloadTask() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(Integer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.agentPort = property;
        RegularFileProperty regularFileProperty = this.getProject().getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"fileProperty(...)");
        this.pendingRequestFile = regularFileProperty;
    }

    @Internal
    @NotNull
    public final Property<Integer> getAgentPort() {
        return this.agentPort;
    }

    @Internal
    @NotNull
    public final RegularFileProperty getPendingRequestFile() {
        return this.pendingRequestFile;
    }

    @Inject
    @NotNull
    public abstract BuildCancellationToken getCancellationToken();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void execute() {
        Object $this$execute_u24lambda_u240;
        Object object = this;
        try {
            $this$execute_u24lambda_u240 = object;
            boolean bl = false;
            Object object2 = $this$execute_u24lambda_u240.agentPort.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            $this$execute_u24lambda_u240 = Result.constructor-impl((Object)OrchestrationClientKt.connectOrchestrationClient((OrchestrationClientRole)OrchestrationClientRole.Compiler, (int)((Number)object2).intValue()));
        }
        catch (Throwable bl) {
            $this$execute_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$execute_u24lambda_u240;
        OrchestrationClient orchestrationClient = (OrchestrationClient)(Result.isFailure-impl((Object)object) ? null : object);
        if (orchestrationClient == null) {
            HotReloadTask $this$execute_u24lambda_u241 = this;
            boolean bl = false;
            $this$execute_u24lambda_u241.getLogger().quiet("Failed to create 'OrchestrationClient'!");
            $this$execute_u24lambda_u241.getCancellationToken().cancel();
            throw new IllegalStateException("Failed to create 'OrchestrationClient'!".toString());
        }
        OrchestrationClient client = orchestrationClient;
        AutoCloseable autoCloseable = (AutoCloseable)client;
        object = null;
        try {
            OrchestrationMessage.ReloadClassesRequest request;
            OrchestrationMessage.ReloadClassesRequest reloadClassesRequest;
            OrchestrationClient client2 = (OrchestrationClient)autoCloseable;
            boolean bl = false;
            Path pendingRequestFile = ((RegularFile)this.pendingRequestFile.get()).getAsFile().toPath();
            Intrinsics.checkNotNull((Object)pendingRequestFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(pendingRequestFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path $this$readObject$iv = pendingRequestFile;
                boolean $i$f$readObject = false;
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream($this$readObject$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                Closeable closeable = new ObjectInputStream(inputStream);
                Throwable throwable = null;
                try {
                    ObjectInputStream ois$iv = (ObjectInputStream)closeable;
                    boolean bl2 = false;
                    Object object3 = ois$iv.readObject();
                    if (object3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.compose.reload.orchestration.OrchestrationMessage.ReloadClassesRequest");
                    }
                    OrchestrationMessage.ReloadClassesRequest reloadClassesRequest2 = (OrchestrationMessage.ReloadClassesRequest)object3;
                    reloadClassesRequest = reloadClassesRequest2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                this.getLogger().info("UP-TO-DATE");
                reloadClassesRequest = request = new OrchestrationMessage.ReloadClassesRequest(MapsKt.emptyMap());
            }
            if (request.getChangedClassFiles().isEmpty()) {
                this.getLogger().debug("UP-TO-DATE: No changed classes found");
            }
            this.getLogger().quiet(this.reloadReport(request));
            client2.sendMessage((OrchestrationMessage)request).get();
            boolean bl3 = Files.deleteIfExists(pendingRequestFile);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object);
        }
    }

    private final String reloadReport(OrchestrationMessage.ReloadClassesRequest request) {
        Map.Entry it;
        Map.Entry element$iv;
        int n;
        Map.Entry[] $this$count$iv;
        File rootPath = this.rootProjectDirectory.getAsFile();
        Collection $this$toTypedArray$iv = request.getChangedClassFiles().entrySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Map.Entry[] entries = thisCollection$iv.toArray(new Map.Entry[0]);
        Template $this$renderOrThrow$iv = TemplateKt.asTemplateOrThrow((String)"Reloading classes\n  Application listening at '{{port}}'\n  Request ID: '{{messageId}}'\n  \n  Summary: \n    - Modifications: {{modifications}}\n    - Additions: {{additions}}\n    - Deletions: {{deletions}}\n  \n  Details: \n    - {{detail}}");
        boolean $i$f$renderOrThrow = false;
        Template $this$render$iv$iv = $this$renderOrThrow$iv;
        boolean $i$f$render = false;
        Map values$iv$iv = new LinkedHashMap();
        TemplateBuilder $this$reloadReport_u24lambda_u247 = new TemplateBuilder(values$iv$iv){
            final /* synthetic */ Map $values;
            {
                this.$values = $values;
            }

            public void push(String key, Object value) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Map $this$getOrPut$iv = this.$values;
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList<E>();
                    $this$getOrPut$iv.put(key, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(value);
            }

            public void set(String key, Object value) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Map map = this.$values;
                Object object = new Object[]{value};
                object = CollectionsKt.mutableListOf((Object[])object);
                map.put(key, object);
            }

            public void invoke(String $this$invoke, Object value) {
                TemplateBuilder.DefaultImpls.invoke((TemplateBuilder)this, (String)$this$invoke, (Object)value);
            }
        };
        boolean bl = false;
        $this$reloadReport_u24lambda_u247.invoke("port", this.agentPort.get());
        $this$reloadReport_u24lambda_u247.invoke("messageId", (Object)request.getMessageId());
        Map.Entry[] entryArray = entries;
        String string = "modifications";
        TemplateBuilder templateBuilder = $this$reloadReport_u24lambda_u247;
        boolean $i$f$count = false;
        int count$iv = 0;
        int n2 = $this$count$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$count$iv[n];
            boolean bl2 = false;
            if (!(it.getValue() == OrchestrationMessage.ReloadClassesRequest.ChangeType.Modified)) continue;
            ++count$iv;
        }
        int n3 = count$iv;
        templateBuilder.invoke(string, (Object)n3);
        $this$count$iv = entries;
        string = "additions";
        templateBuilder = $this$reloadReport_u24lambda_u247;
        $i$f$count = false;
        count$iv = 0;
        n2 = $this$count$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$count$iv[n];
            boolean bl3 = false;
            if (!(it.getValue() == OrchestrationMessage.ReloadClassesRequest.ChangeType.Added)) continue;
            ++count$iv;
        }
        n3 = count$iv;
        templateBuilder.invoke(string, (Object)n3);
        $this$count$iv = entries;
        string = "deletions";
        templateBuilder = $this$reloadReport_u24lambda_u247;
        $i$f$count = false;
        count$iv = 0;
        n2 = $this$count$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$count$iv[n];
            boolean bl4 = false;
            if (!(it.getValue() == OrchestrationMessage.ReloadClassesRequest.ChangeType.Removed)) continue;
            ++count$iv;
        }
        n3 = count$iv;
        templateBuilder.invoke(string, (Object)n3);
        Map.Entry[] $this$forEach$iv = entries;
        boolean $i$f$forEach = false;
        n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            Map.Entry element$iv2;
            Map.Entry entry = element$iv2 = $this$forEach$iv[j];
            boolean bl5 = false;
            File file = (File)entry.getKey();
            OrchestrationMessage.ReloadClassesRequest.ChangeType changeType = (OrchestrationMessage.ReloadClassesRequest.ChangeType)entry.getValue();
            Intrinsics.checkNotNull((Object)rootPath);
            File file2 = FilesKt.relativeToOrSelf((File)file, (File)rootPath);
            String string2 = changeType.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            $this$reloadReport_u24lambda_u247.invoke("detail", (Object)(file2 + ": " + string2));
        }
        return (String)TryKt.getOrThrow((Either)$this$render$iv$iv.render(values$iv$iv));
    }
}

