/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.tooling.Failure;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.task.TaskFailureResult;
import org.gradle.tooling.events.task.TaskFinishEvent;
import org.gradle.tooling.events.task.TaskOperationResult;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.core.Update;
import org.jetbrains.compose.reload.orchestration.OrchestrationClient;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientRole;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/compose/reload/StatusService;", "Lorg/gradle/api/services/BuildService;", "Lorg/jetbrains/compose/reload/StatusService$Params;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Ljava/lang/AutoCloseable;", "<init>", "()V", "clients", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationClient;", "onFinish", "", "event", "Lorg/gradle/tooling/events/FinishEvent;", "close", "Params", "hot-reload-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nstatusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 statusService.kt\norg/jetbrains/compose/reload/StatusService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 atomics.kt\norg/jetbrains/compose/reload/core/AtomicsKt\n*L\n1#1,130:1\n1611#2,9:131\n1863#2:140\n1864#2:143\n1620#2:144\n2642#2:145\n1557#2:147\n1628#2,3:148\n1863#2,2:151\n1863#2,2:153\n1863#2,2:155\n1#3:141\n1#3:142\n1#3:146\n13#4,5:157\n*S KotlinDebug\n*F\n+ 1 statusService.kt\norg/jetbrains/compose/reload/StatusService\n*L\n82#1:131,9\n82#1:140\n82#1:143\n82#1:144\n84#1:145\n109#1:147\n109#1:148,3\n119#1:151,2\n126#1:153,2\n127#1:155,2\n82#1:142\n84#1:146\n87#1:157,5\n*E\n"})
public abstract class StatusService
implements BuildService<Params>,
OperationCompletionListener,
AutoCloseable {
    @NotNull
    private final AtomicReference<List<OrchestrationClient>> clients = new AtomicReference<List>(CollectionsKt.emptyList());

    /*
     * WARNING - void declaration
     */
    public StatusService() {
        void $this$onEach$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object object = ((Params)this.getParameters()).getPorts().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Iterable iterable = (Iterable)object;
        AtomicReference<List<OrchestrationClient>> atomicReference = this.clients;
        boolean $i$f$mapNotNull = false;
        void var3_4 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            OrchestrationClient it$iv$iv;
            Object object2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Integer port = (Integer)element$iv$iv;
            boolean bl2 = false;
            Object object3 = this;
            try {
                StatusService $this$lambda_u241_u24lambda_u240 = object3;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)port);
                object2 = Result.constructor-impl((Object)OrchestrationClientKt.connectOrchestrationClient((OrchestrationClientRole)OrchestrationClientRole.Compiler, (int)port));
            }
            catch (Throwable throwable) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object3 = object2;
            if ((OrchestrationClient)(Result.isFailure-impl((Object)object3) ? null : object3) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        void $this$onEach_u24lambda_u2419$iv = var3_4 = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2419$iv) {
            OrchestrationClient client = (OrchestrationClient)element$iv;
            boolean bl5 = false;
            client.sendMessage((OrchestrationMessage)new OrchestrationMessage.BuildStarted());
            client.invokeWhenClosed(() -> StatusService.lambda$4$lambda$3(this, client));
        }
        atomicReference.set((List<OrchestrationClient>)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public void onFinish(@NotNull FinishEvent event) {
        OrchestrationMessage.BuildTaskResult buildTaskResult;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.clients.get().isEmpty()) {
            return;
        }
        if (!(event instanceof TaskFinishEvent)) {
            return;
        }
        TaskOperationResult result = ((TaskFinishEvent)event).getResult();
        if (result instanceof TaskSuccessResult) {
            String string = ((TaskFinishEvent)event).getDescriptor().getTaskPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTaskPath(...)");
            buildTaskResult = new OrchestrationMessage.BuildTaskResult(string, true, Long.valueOf(((TaskFinishEvent)event).getResult().getStartTime()), Long.valueOf(((TaskFinishEvent)event).getResult().getEndTime()), CollectionsKt.emptyList());
        } else if (result instanceof TaskFailureResult) {
            Collection<OrchestrationMessage.BuildTaskResult.BuildTaskFailure> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string = ((TaskFinishEvent)event).getDescriptor().getTaskPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTaskPath(...)");
            Long l = ((TaskFinishEvent)event).getResult().getStartTime();
            Long l2 = ((TaskFinishEvent)event).getResult().getEndTime();
            List list = ((TaskFailureResult)result).getFailures();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFailures(...)");
            Iterable iterable = list;
            Long l3 = l2;
            Long l4 = l;
            boolean bl = false;
            String string2 = string;
            boolean $i$f$map = false;
            void var6_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void failure;
                Failure failure2 = (Failure)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new OrchestrationMessage.BuildTaskResult.BuildTaskFailure(failure.getMessage(), failure.getDescription()));
            }
            Collection<OrchestrationMessage.BuildTaskResult.BuildTaskFailure> collection2 = collection = (List)destination$iv$iv;
            Long l5 = l3;
            Long l6 = l4;
            boolean bl3 = bl;
            String string3 = string2;
            buildTaskResult = new OrchestrationMessage.BuildTaskResult(string3, bl3, l6, l5, collection2);
        } else {
            return;
        }
        OrchestrationMessage.BuildTaskResult message = buildTaskResult;
        List<OrchestrationClient> list = this.clients.get();
        Intrinsics.checkNotNullExpressionValue(list, (String)"get(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OrchestrationClient client = (OrchestrationClient)element$iv;
            boolean bl = false;
            client.sendMessage((OrchestrationMessage)message);
        }
    }

    @Override
    public void close() {
        OrchestrationClient client;
        List<OrchestrationClient> clients = this.clients.getAndSet(CollectionsKt.emptyList());
        Intrinsics.checkNotNull(clients);
        Iterable $this$forEach$iv = clients;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            client = (OrchestrationClient)element$iv;
            boolean bl = false;
            client.sendMessage((OrchestrationMessage)new OrchestrationMessage.BuildFinished());
        }
        $this$forEach$iv = clients;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            client = (OrchestrationClient)element$iv;
            boolean bl = false;
            client.closeGracefully();
        }
    }

    private static final Unit lambda$4$lambda$3(StatusService this$0, OrchestrationClient $client) {
        List<OrchestrationClient> it;
        List updated$iv;
        List<OrchestrationClient> value$iv;
        AtomicReference<List<OrchestrationClient>> $this$update$iv = this$0.clients;
        boolean $i$f$update = false;
        do {
            it = value$iv = $this$update$iv.get();
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(value$iv, updated$iv = CollectionsKt.minus((Iterable)it, (Object)$client)));
        new Update(value$iv, (Object)updated$iv);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/compose/reload/StatusService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "projectPath", "Lorg/gradle/api/provider/Property;", "", "getProjectPath", "()Lorg/gradle/api/provider/Property;", "ports", "Lorg/gradle/api/provider/ListProperty;", "", "getPorts", "()Lorg/gradle/api/provider/ListProperty;", "hot-reload-gradle-plugin"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public Property<String> getProjectPath();

        @NotNull
        public ListProperty<Integer> getPorts();
    }
}

