/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.gradle;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.compose.reload.gradle.JarSnapshot;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0013\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0004H\u0086\u0002J\u0019\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u0005H\u0086\u0002J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u0004J\u0015\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\u001f\u0010\u0010\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/compose/reload/gradle/ClasspathSnapshot;", "Ljava/io/Serializable;", "jars", "", "Ljava/io/File;", "Lorg/jetbrains/compose/reload/gradle/JarSnapshot;", "<init>", "(Ljava/util/Map;)V", "()V", "get", "file", "set", "", "snapshot", "remove", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "hot-reload-gradle-plugin"})
public final class ClasspathSnapshot
implements Serializable {
    @NotNull
    private final Map<File, JarSnapshot> jars;

    private ClasspathSnapshot(Map<File, JarSnapshot> jars) {
        this.jars = jars;
    }

    public ClasspathSnapshot() {
        this(new LinkedHashMap());
    }

    @Nullable
    public final JarSnapshot get(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.jars.get(file.getAbsoluteFile());
    }

    public final void set(@NotNull File file, @NotNull JarSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        this.jars.put(file.getAbsoluteFile(), snapshot);
    }

    @Nullable
    public final JarSnapshot remove(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.jars.remove(file.getAbsoluteFile());
    }

    private final Map<File, JarSnapshot> component1() {
        return this.jars;
    }

    private final ClasspathSnapshot copy(Map<File, JarSnapshot> jars) {
        return new ClasspathSnapshot(jars);
    }

    static /* synthetic */ ClasspathSnapshot copy$default(ClasspathSnapshot classpathSnapshot, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            map = classpathSnapshot.jars;
        }
        return classpathSnapshot.copy(map);
    }

    @NotNull
    public String toString() {
        return "ClasspathSnapshot(jars=" + this.jars + ")";
    }

    public int hashCode() {
        return ((Object)this.jars).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ClasspathSnapshot)) {
            return false;
        }
        ClasspathSnapshot classpathSnapshot = (ClasspathSnapshot)other;
        return Intrinsics.areEqual(this.jars, classpathSnapshot.jars);
    }
}

