/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.gradle;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.gradle.ClasspathSnapshot;
import org.jetbrains.compose.reload.gradle.JarSnapshot;
import org.jetbrains.compose.reload.gradle.ZipFileChange;
import org.jetbrains.compose.reload.gradle.ZipFileChanges;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\u0004H\u0000\u001a\f\u0010\t\u001a\u00020\u0001*\u00020\bH\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u000bH\u0000\u00a8\u0006\u0010"}, d2={"ClasspathSnapshot", "Lorg/jetbrains/compose/reload/gradle/ClasspathSnapshot;", "files", "", "Ljava/io/File;", "writeClasspathSnapshot", "", "snapshot", "Ljava/nio/file/Path;", "readClasspathSnapshot", "createJarSnapshot", "Lorg/jetbrains/compose/reload/gradle/JarSnapshot;", "file", "resolveChanges", "Lorg/jetbrains/compose/reload/gradle/ZipFileChanges;", "Ljava/util/zip/ZipFile;", "hot-reload-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nclasspathSnapshot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 classpathSnapshot.kt\norg/jetbrains/compose/reload/gradle/ClasspathSnapshotKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,133:1\n1863#2,2:134\n1557#2:140\n1628#2,3:141\n1317#3,2:136\n1317#3,2:138\n*S KotlinDebug\n*F\n+ 1 classpathSnapshot.kt\norg/jetbrains/compose/reload/gradle/ClasspathSnapshotKt\n*L\n20#1:134,2\n130#1:140\n130#1:141,3\n85#1:136,2\n117#1:138,2\n*E\n"})
public final class ClasspathSnapshotKt {
    @NotNull
    public static final ClasspathSnapshot ClasspathSnapshot(@NotNull Iterable<? extends File> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        ClasspathSnapshot snapshot = new ClasspathSnapshot();
        Iterable<? extends File> $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        Iterator<? extends File> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            File element$iv;
            File file = element$iv = iterator.next();
            boolean bl = false;
            if (!file.isFile() || !Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"jar") && !Intrinsics.areEqual((Object)FilesKt.getExtension((File)file), (Object)"zip")) continue;
            snapshot.set(file, ClasspathSnapshotKt.createJarSnapshot(file));
        }
        return snapshot;
    }

    public static final void writeClasspathSnapshot(@NotNull File $this$writeClasspathSnapshot, @NotNull ClasspathSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)$this$writeClasspathSnapshot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Path path = $this$writeClasspathSnapshot.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        ClasspathSnapshotKt.writeClasspathSnapshot(path, snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeClasspathSnapshot(@NotNull Path $this$writeClasspathSnapshot, @NotNull ClasspathSnapshot snapshot) {
        Intrinsics.checkNotNullParameter((Object)$this$writeClasspathSnapshot, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream($this$writeClasspathSnapshot, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        int n = 8192;
        closeable = new ObjectOutputStream(closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n));
        Throwable throwable = null;
        try {
            ObjectOutputStream oos = (ObjectOutputStream)closeable;
            boolean bl = false;
            oos.writeObject(snapshot);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @NotNull
    public static final ClasspathSnapshot readClasspathSnapshot(@NotNull File $this$readClasspathSnapshot) {
        Intrinsics.checkNotNullParameter((Object)$this$readClasspathSnapshot, (String)"<this>");
        Path path = $this$readClasspathSnapshot.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return ClasspathSnapshotKt.readClasspathSnapshot(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ClasspathSnapshot readClasspathSnapshot(@NotNull Path $this$readClasspathSnapshot) {
        ClasspathSnapshot classpathSnapshot;
        Intrinsics.checkNotNullParameter((Object)$this$readClasspathSnapshot, (String)"<this>");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream($this$readClasspathSnapshot, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        int n = 8192;
        closeable = new ObjectInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
        Throwable throwable = null;
        try {
            ObjectInputStream ois = (ObjectInputStream)closeable;
            boolean bl = false;
            Object object = ois.readObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.compose.reload.gradle.ClasspathSnapshot");
            classpathSnapshot = (ClasspathSnapshot)object;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return classpathSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final JarSnapshot createJarSnapshot(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map index = new LinkedHashMap();
        Closeable closeable = new ZipFile(file);
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            ZipFile zip = (ZipFile)closeable;
            boolean bl = false;
            Enumeration<? extends ZipEntry> enumeration = zip.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
            Sequence sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ZipEntry entry = (ZipEntry)element$iv;
                boolean bl2 = false;
                if (entry.isDirectory()) continue;
                String string = entry.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                index.put(string, entry.getCrc());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return new JarSnapshot(index);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ZipFileChanges resolveChanges(@NotNull ZipFile $this$resolveChanges, @NotNull JarSnapshot snapshot) {
        Collection<ZipFileChange.Removed> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)$this$resolveChanges, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Map newIndex = new LinkedHashMap();
        List changes = new ArrayList();
        HashSet removedEntries = CollectionsKt.toHashSet((Iterable)snapshot.entries());
        Enumeration<? extends ZipEntry> enumeration = $this$resolveChanges.entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
        Sequence sequence = SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Long l;
            ZipEntry entry = (ZipEntry)element$iv;
            boolean bl = false;
            if (entry.isDirectory()) continue;
            newIndex.put(entry.getName(), entry.getCrc());
            removedEntries.remove(entry.getName());
            String string = entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Long l2 = l = snapshot.crc(string);
            long l3 = entry.getCrc();
            if (l2 != null && l2 == l3) continue;
            if (l == null) {
                Intrinsics.checkNotNull((Object)entry);
                changes.add(new ZipFileChange.Added(entry));
                continue;
            }
            Intrinsics.checkNotNull((Object)entry);
            changes.add(new ZipFileChange.Modified(entry));
        }
        $this$forEach$iv = removedEntries;
        Collection collection2 = changes;
        JarSnapshot jarSnapshot = new JarSnapshot(newIndex);
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void name;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ZipFileChange.Removed((String)name));
        }
        collection = (List)destination$iv$iv;
        List list = CollectionsKt.plus((Collection)collection2, (Iterable)collection);
        JarSnapshot jarSnapshot2 = jarSnapshot;
        return new ZipFileChanges(jarSnapshot2, list);
    }
}

