/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.compose.reload.gradle;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.compose.reload.InternalHotReloadApi;
import org.jetbrains.compose.reload.core.Either;
import org.jetbrains.compose.reload.core.Left;
import org.jetbrains.compose.reload.core.Right;
import org.jetbrains.compose.reload.core.Template;
import org.jetbrains.compose.reload.core.TemplateBuilder;
import org.jetbrains.compose.reload.core.TemplateKt;
import org.jetbrains.compose.reload.core.TryKt;
import org.jetbrains.compose.reload.gradle.ComposeHotReloadOtherTask;
import org.jetbrains.compose.reload.orchestration.OrchestrationClient;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationClientRole;
import org.jetbrains.compose.reload.orchestration.OrchestrationHandle;
import org.jetbrains.compose.reload.orchestration.OrchestrationHandleKt;
import org.jetbrains.compose.reload.orchestration.OrchestrationMessage;

@DisableCachingByDefault(because="Should always run")
@InternalHotReloadApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H'J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u00020\u000e8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/compose/reload/gradle/ComposeHotReloadTask;", "Lorg/gradle/api/DefaultTask;", "Lorg/jetbrains/compose/reload/gradle/ComposeHotReloadOtherTask;", "<init>", "()V", "rootProjectDirectory", "Lorg/gradle/api/file/Directory;", "kotlin.jvm.PlatformType", "agentPort", "Lorg/gradle/api/provider/Property;", "", "getAgentPort", "()Lorg/gradle/api/provider/Property;", "pendingRequestFile", "Lorg/gradle/api/file/RegularFileProperty;", "getPendingRequestFile", "()Lorg/gradle/api/file/RegularFileProperty;", "getCancellationToken", "Lorg/gradle/initialization/BuildCancellationToken;", "execute", "", "reloadReport", "", "request", "Lorg/jetbrains/compose/reload/orchestration/OrchestrationMessage$ReloadClassesRequest;", "hot-reload-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nhotReloadTasks.kt\nKotlin\n*S Kotlin\n*F\n+ 1 hotReloadTasks.kt\norg/jetbrains/compose/reload/gradle/ComposeHotReloadTask\n+ 2 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n+ 3 Either.kt\norg/jetbrains/compose/reload/core/EitherKt\n+ 4 utils.kt\norg/jetbrains/compose/reload/gradle/UtilsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 Template.kt\norg/jetbrains/compose/reload/core/TemplateKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,153:1\n59#2:154\n38#3,3:155\n155#4,3:158\n37#5,2:161\n47#6:163\n32#6,10:164\n42#6:185\n12734#7,3:174\n12734#7,3:177\n12734#7,3:180\n13409#7,2:183\n*S KotlinDebug\n*F\n+ 1 hotReloadTasks.kt\norg/jetbrains/compose/reload/gradle/ComposeHotReloadTask\n*L\n84#1:154\n95#1:155,3\n105#1:158,3\n123#1:161,2\n137#1:163\n137#1:164,10\n137#1:185\n140#1:174,3\n141#1:177,3\n142#1:180,3\n144#1:183,2\n*E\n"})
public abstract class ComposeHotReloadTask
extends DefaultTask
implements ComposeHotReloadOtherTask {
    private final Directory rootProjectDirectory = this.getProject().getRootProject().getLayout().getProjectDirectory();
    @NotNull
    private final Property<Integer> agentPort;
    @NotNull
    private final RegularFileProperty pendingRequestFile;

    public ComposeHotReloadTask() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"getObjects(...)");
        ObjectFactory $this$property$iv = objectFactory;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(Integer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.agentPort = property;
        RegularFileProperty regularFileProperty = this.getProject().getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"fileProperty(...)");
        this.pendingRequestFile = regularFileProperty;
    }

    @Internal
    @NotNull
    public final Property<Integer> getAgentPort() {
        return this.agentPort;
    }

    @Internal
    @NotNull
    public final RegularFileProperty getPendingRequestFile() {
        return this.pendingRequestFile;
    }

    @Inject
    @NotNull
    public abstract BuildCancellationToken getCancellationToken();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void execute() {
        Object object = this.agentPort.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        AutoCloseable autoCloseable = (AutoCloseable)OrchestrationClientKt.OrchestrationClient((OrchestrationClientRole)OrchestrationClientRole.Compiler, (int)((Number)object).intValue());
        Throwable throwable = null;
        try {
            OrchestrationMessage.ReloadClassesRequest request;
            OrchestrationMessage.ReloadClassesRequest reloadClassesRequest;
            OrchestrationClient client = (OrchestrationClient)autoCloseable;
            boolean bl = false;
            Either $this$leftOr$iv = OrchestrationHandleKt.connectBlocking((OrchestrationClient)client);
            boolean $i$f$leftOr = false;
            Either either = $this$leftOr$iv;
            if (!(either instanceof Left)) {
                if (either instanceof Right) {
                    Right it = (Right)$this$leftOr$iv;
                    boolean bl2 = false;
                    this.getLogger().error("Failed to create 'OrchestrationClient'!");
                    this.getCancellationToken().cancel();
                    throw new IllegalStateException("Failed to create 'OrchestrationClient'!".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
            ((Left)$this$leftOr$iv).getValue();
            this.getLogger().debug("Connected to '" + client.getPort().getOrNull() + "'");
            Path pendingRequestFile = ((RegularFile)this.pendingRequestFile.get()).getAsFile().toPath();
            Intrinsics.checkNotNull((Object)pendingRequestFile);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(pendingRequestFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Path $this$readObject$iv = pendingRequestFile;
                boolean $i$f$readObject = false;
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream = Files.newInputStream($this$readObject$iv, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                Closeable closeable = new ObjectInputStream(inputStream);
                Throwable throwable2 = null;
                try {
                    ObjectInputStream ois$iv = (ObjectInputStream)closeable;
                    boolean bl3 = false;
                    Object object2 = ois$iv.readObject();
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.compose.reload.orchestration.OrchestrationMessage.ReloadClassesRequest");
                    }
                    OrchestrationMessage.ReloadClassesRequest reloadClassesRequest2 = (OrchestrationMessage.ReloadClassesRequest)object2;
                    reloadClassesRequest = reloadClassesRequest2;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
            } else {
                this.getLogger().info("UP-TO-DATE");
                reloadClassesRequest = request = new OrchestrationMessage.ReloadClassesRequest(MapsKt.emptyMap());
            }
            if (request.getChangedClassFiles().isEmpty()) {
                this.getLogger().info("UP-TO-DATE: No changed classes found");
            }
            this.getLogger().info(this.reloadReport(request));
            OrchestrationHandleKt.sendBlocking((OrchestrationHandle)((OrchestrationHandle)client), (OrchestrationMessage)((OrchestrationMessage)request));
            boolean bl4 = Files.deleteIfExists(pendingRequestFile);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final String reloadReport(OrchestrationMessage.ReloadClassesRequest request) {
        Map.Entry it;
        Map.Entry element$iv;
        int n;
        Map.Entry[] $this$count$iv;
        File rootPath = this.rootProjectDirectory.getAsFile();
        Collection $this$toTypedArray$iv = request.getChangedClassFiles().entrySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Map.Entry[] entries = thisCollection$iv.toArray(new Map.Entry[0]);
        Template $this$renderOrThrow$iv = TemplateKt.asTemplateOrThrow((String)"Reloading classes\n  Application listening at '{{port}}'\n  Request ID: '{{messageId}}'\n  \n  Summary: \n    - Modifications: {{modifications}}\n    - Additions: {{additions}}\n    - Deletions: {{deletions}}\n  \n  Details: \n    - {{detail}}");
        boolean $i$f$renderOrThrow = false;
        Template $this$render$iv$iv = $this$renderOrThrow$iv;
        boolean $i$f$render = false;
        Map values$iv$iv = new LinkedHashMap();
        TemplateBuilder $this$reloadReport_u24lambda_u246 = new TemplateBuilder(values$iv$iv){
            final /* synthetic */ Map $values;
            {
                this.$values = $values;
            }

            /*
             * WARNING - void declaration
             */
            public void push(String key, Object value) {
                Object object;
                void $this$getOrPut$iv;
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Map map = this.$values;
                String key$iv = key;
                boolean $i$f$getOrPut = false;
                V value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList<E>();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(value);
            }

            public void set(String key, Object value) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                Map map = this.$values;
                Object object = new Object[]{value};
                object = CollectionsKt.mutableListOf((Object[])object);
                map.put(key, object);
            }

            public void invoke(String $this$invoke, Object value) {
                TemplateBuilder.DefaultImpls.invoke((TemplateBuilder)this, (String)$this$invoke, (Object)value);
            }
        };
        boolean bl = false;
        $this$reloadReport_u24lambda_u246.invoke("port", this.agentPort.get());
        $this$reloadReport_u24lambda_u246.invoke("messageId", (Object)request.getMessageId());
        Map.Entry[] entryArray = entries;
        String string = "modifications";
        TemplateBuilder templateBuilder = $this$reloadReport_u24lambda_u246;
        boolean $i$f$count = false;
        int count$iv = 0;
        int n2 = $this$count$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$count$iv[n];
            boolean bl2 = false;
            if (!(it.getValue() == OrchestrationMessage.ReloadClassesRequest.ChangeType.Modified)) continue;
            ++count$iv;
        }
        int n3 = count$iv;
        templateBuilder.invoke(string, (Object)n3);
        $this$count$iv = entries;
        string = "additions";
        templateBuilder = $this$reloadReport_u24lambda_u246;
        $i$f$count = false;
        count$iv = 0;
        n2 = $this$count$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$count$iv[n];
            boolean bl3 = false;
            if (!(it.getValue() == OrchestrationMessage.ReloadClassesRequest.ChangeType.Added)) continue;
            ++count$iv;
        }
        n3 = count$iv;
        templateBuilder.invoke(string, (Object)n3);
        $this$count$iv = entries;
        string = "deletions";
        templateBuilder = $this$reloadReport_u24lambda_u246;
        $i$f$count = false;
        count$iv = 0;
        n2 = $this$count$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$count$iv[n];
            boolean bl4 = false;
            if (!(it.getValue() == OrchestrationMessage.ReloadClassesRequest.ChangeType.Removed)) continue;
            ++count$iv;
        }
        n3 = count$iv;
        templateBuilder.invoke(string, (Object)n3);
        Map.Entry[] $this$forEach$iv = entries;
        boolean $i$f$forEach = false;
        n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            Map.Entry element$iv2;
            Map.Entry entry = element$iv2 = $this$forEach$iv[j];
            boolean bl5 = false;
            File file = (File)entry.getKey();
            OrchestrationMessage.ReloadClassesRequest.ChangeType changeType = (OrchestrationMessage.ReloadClassesRequest.ChangeType)entry.getValue();
            Intrinsics.checkNotNull((Object)rootPath);
            File file2 = FilesKt.relativeToOrSelf((File)file, (File)rootPath);
            String string2 = changeType.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            $this$reloadReport_u24lambda_u246.invoke("detail", (Object)(file2 + ": " + string2));
        }
        return (String)TryKt.getOrThrow((Either)$this$render$iv$iv.render(values$iv$iv));
    }
}

