/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.AlarmOff: ImageVector
    get() {
        if (_alarmOff != null) {
            return _alarmOff!!
        }
        _alarmOff = materialIcon(name = "Filled.AlarmOff") {
            materialPath {
                moveTo(12.0f, 6.0f)
                curveToRelative(3.87f, 0.0f, 7.0f, 3.13f, 7.0f, 7.0f)
                curveToRelative(0.0f, 0.84f, -0.16f, 1.65f, -0.43f, 2.4f)
                lineToRelative(1.52f, 1.52f)
                curveToRelative(0.58f, -1.19f, 0.91f, -2.51f, 0.91f, -3.92f)
                curveToRelative(0.0f, -4.97f, -4.03f, -9.0f, -9.0f, -9.0f)
                curveToRelative(-1.41f, 0.0f, -2.73f, 0.33f, -3.92f, 0.91f)
                lineTo(9.6f, 6.43f)
                curveTo(10.35f, 6.16f, 11.16f, 6.0f, 12.0f, 6.0f)
                close()
                moveTo(22.0f, 5.72f)
                lineToRelative(-4.6f, -3.86f)
                lineToRelative(-1.29f, 1.53f)
                lineToRelative(4.6f, 3.86f)
                lineTo(22.0f, 5.72f)
                close()
                moveTo(2.92f, 2.29f)
                lineTo(1.65f, 3.57f)
                lineTo(2.98f, 4.9f)
                lineToRelative(-1.11f, 0.93f)
                lineToRelative(1.42f, 1.42f)
                lineToRelative(1.11f, -0.94f)
                lineToRelative(0.8f, 0.8f)
                curveTo(3.83f, 8.69f, 3.0f, 10.75f, 3.0f, 13.0f)
                curveToRelative(0.0f, 4.97f, 4.02f, 9.0f, 9.0f, 9.0f)
                curveToRelative(2.25f, 0.0f, 4.31f, -0.83f, 5.89f, -2.2f)
                lineToRelative(2.2f, 2.2f)
                lineToRelative(1.27f, -1.27f)
                lineTo(3.89f, 3.27f)
                lineToRelative(-0.97f, -0.98f)
                close()
                moveTo(16.47f, 18.39f)
                curveTo(15.26f, 19.39f, 13.7f, 20.0f, 12.0f, 20.0f)
                curveToRelative(-3.87f, 0.0f, -7.0f, -3.13f, -7.0f, -7.0f)
                curveToRelative(0.0f, -1.7f, 0.61f, -3.26f, 1.61f, -4.47f)
                lineToRelative(9.86f, 9.86f)
                close()
                moveTo(8.02f, 3.28f)
                lineTo(6.6f, 1.86f)
                lineToRelative(-0.86f, 0.71f)
                lineToRelative(1.42f, 1.42f)
                lineToRelative(0.86f, -0.71f)
                close()
            }
        }
        return _alarmOff!!
    }

private var _alarmOff: ImageVector? = null
