/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.LayersClear: ImageVector
    get() {
        if (_layersClear != null) {
            return _layersClear!!
        }
        _layersClear = materialIcon(name = "Filled.LayersClear") {
            materialPath {
                moveTo(19.81f, 14.99f)
                lineToRelative(1.19f, -0.92f)
                lineToRelative(-1.43f, -1.43f)
                lineToRelative(-1.19f, 0.92f)
                lineToRelative(1.43f, 1.43f)
                close()
                moveTo(19.36f, 10.27f)
                lineTo(21.0f, 9.0f)
                lineToRelative(-9.0f, -7.0f)
                lineToRelative(-2.91f, 2.27f)
                lineToRelative(7.87f, 7.88f)
                lineToRelative(2.4f, -1.88f)
                close()
                moveTo(3.27f, 1.0f)
                lineTo(2.0f, 2.27f)
                lineToRelative(4.22f, 4.22f)
                lineTo(3.0f, 9.0f)
                lineToRelative(1.63f, 1.27f)
                lineTo(12.0f, 16.0f)
                lineToRelative(2.1f, -1.63f)
                lineToRelative(1.43f, 1.43f)
                lineTo(12.0f, 18.54f)
                lineToRelative(-7.37f, -5.73f)
                lineTo(3.0f, 14.07f)
                lineToRelative(9.0f, 7.0f)
                lineToRelative(4.95f, -3.85f)
                lineTo(20.73f, 21.0f)
                lineTo(22.0f, 19.73f)
                lineTo(3.27f, 1.0f)
                close()
            }
        }
        return _layersClear!!
    }

private var _layersClear: ImageVector? = null
