/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Scale: ImageVector
    get() {
        if (_scale != null) {
            return _scale!!
        }
        _scale = materialIcon(name = "Filled.Scale") {
            materialPath {
                moveTo(14.0f, 11.0f)
                verticalLineTo(8.0f)
                curveToRelative(4.56f, -0.58f, 8.0f, -3.1f, 8.0f, -6.0f)
                horizontalLineTo(2.0f)
                curveToRelative(0.0f, 2.9f, 3.44f, 5.42f, 8.0f, 6.0f)
                lineToRelative(0.0f, 3.0f)
                curveToRelative(-3.68f, 0.73f, -8.0f, 3.61f, -8.0f, 11.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(4.13f)
                curveToRelative(0.93f, -6.83f, 6.65f, -7.2f, 7.87f, -7.2f)
                reflectiveCurveToRelative(6.94f, 0.37f, 7.87f, 7.2f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(6.0f)
                curveTo(22.0f, 14.61f, 17.68f, 11.73f, 14.0f, 11.0f)
                close()
                moveTo(12.0f, 22.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                curveToRelative(0.0f, -0.55f, 0.22f, -1.05f, 0.59f, -1.41f)
                curveTo(11.39f, 17.79f, 16.0f, 16.0f, 16.0f, 16.0f)
                reflectiveCurveToRelative(-1.79f, 4.61f, -2.59f, 5.41f)
                curveTo(13.05f, 21.78f, 12.55f, 22.0f, 12.0f, 22.0f)
                close()
            }
        }
        return _scale!!
    }

private var _scale: ImageVector? = null
