/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.Microwave: ImageVector
    get() {
        if (_microwave != null) {
            return _microwave!!
        }
        _microwave = materialIcon(name = "Outlined.Microwave") {
            materialPath {
                moveTo(20.0f, 4.0f)
                horizontalLineTo(4.0f)
                curveTo(2.9f, 4.0f, 2.0f, 4.9f, 2.0f, 6.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(6.0f)
                curveTo(22.0f, 4.9f, 21.1f, 4.0f, 20.0f, 4.0f)
                close()
                moveTo(4.0f, 6.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(12.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(6.0f)
                close()
                moveTo(20.0f, 18.0f)
                horizontalLineToRelative(-4.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(4.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(19.0f, 9.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(9.0f)
                close()
                moveTo(18.0f, 13.0f)
                lineTo(18.0f, 13.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveTo(19.0f, 12.55f, 18.55f, 13.0f, 18.0f, 13.0f)
                close()
                moveTo(18.0f, 17.0f)
                lineTo(18.0f, 17.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(0.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(0.0f)
                curveTo(19.0f, 16.55f, 18.55f, 17.0f, 18.0f, 17.0f)
                close()
                moveTo(10.25f, 16.0f)
                curveToRelative(-0.79f, 0.0f, -1.37f, -0.38f, -1.79f, -0.66f)
                curveTo(8.13f, 15.12f, 7.94f, 15.0f, 7.75f, 15.0f)
                curveToRelative(-0.37f, 0.0f, -0.8f, 0.41f, -0.95f, 0.61f)
                lineToRelative(-1.42f, -1.42f)
                curveTo(5.73f, 13.79f, 6.59f, 13.0f, 7.75f, 13.0f)
                curveToRelative(0.8f, 0.0f, 1.39f, 0.39f, 1.81f, 0.67f)
                curveTo(9.87f, 13.88f, 10.07f, 14.0f, 10.25f, 14.0f)
                curveToRelative(0.37f, 0.0f, 0.8f, -0.41f, 0.95f, -0.61f)
                lineToRelative(1.42f, 1.42f)
                curveTo(12.26f, 15.21f, 11.41f, 16.0f, 10.25f, 16.0f)
                close()
                moveTo(10.25f, 11.0f)
                curveToRelative(-0.79f, 0.0f, -1.37f, -0.38f, -1.79f, -0.66f)
                curveTo(8.13f, 10.12f, 7.94f, 10.0f, 7.75f, 10.0f)
                curveToRelative(-0.37f, 0.0f, -0.8f, 0.41f, -0.95f, 0.61f)
                lineTo(5.37f, 9.19f)
                curveTo(5.73f, 8.79f, 6.59f, 8.0f, 7.75f, 8.0f)
                curveToRelative(0.8f, 0.0f, 1.39f, 0.39f, 1.81f, 0.67f)
                curveTo(9.87f, 8.88f, 10.07f, 9.0f, 10.25f, 9.0f)
                curveToRelative(0.37f, 0.0f, 0.8f, -0.41f, 0.95f, -0.61f)
                lineToRelative(1.42f, 1.42f)
                curveTo(12.26f, 10.21f, 11.41f, 11.0f, 10.25f, 11.0f)
                close()
            }
        }
        return _microwave!!
    }

private var _microwave: ImageVector? = null
