/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.RawOn: ImageVector
    get() {
        if (_rawOn != null) {
            return _rawOn!!
        }
        _rawOn = materialIcon(name = "Rounded.RawOn") {
            materialPath {
                moveTo(6.5f, 9.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(4.31f)
                curveTo(3.0f, 14.69f, 3.31f, 15.0f, 3.69f, 15.0f)
                horizontalLineToRelative(0.11f)
                curveToRelative(0.38f, 0.0f, 0.69f, -0.31f, 0.69f, -0.69f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(1.1f)
                lineToRelative(0.72f, 1.59f)
                curveTo(6.43f, 14.84f, 6.68f, 15.0f, 6.95f, 15.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.5f, 0.0f, 0.83f, -0.51f, 0.64f, -0.97f)
                lineTo(7.1f, 12.9f)
                curveTo(7.6f, 12.6f, 8.0f, 12.1f, 8.0f, 11.5f)
                verticalLineToRelative(-1.0f)
                curveTo(8.0f, 9.68f, 7.32f, 9.0f, 6.5f, 9.0f)
                close()
                moveTo(6.5f, 11.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(11.5f)
                close()
            }
            materialPath {
                moveTo(11.5f, 9.0f)
                curveToRelative(-0.73f, 0.0f, -1.37f, 0.5f, -1.55f, 1.21f)
                lineTo(8.98f, 14.1f)
                curveTo(8.86f, 14.56f, 9.21f, 15.0f, 9.68f, 15.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.33f, 0.0f, 0.62f, -0.23f, 0.7f, -0.55f)
                lineToRelative(0.24f, -0.95f)
                horizontalLineToRelative(1.75f)
                lineToRelative(0.23f, 0.95f)
                curveToRelative(0.08f, 0.32f, 0.37f, 0.55f, 0.71f, 0.55f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.47f, 0.0f, 0.82f, -0.44f, 0.71f, -0.9f)
                lineToRelative(-0.97f, -3.88f)
                curveTo(12.87f, 9.5f, 12.23f, 9.0f, 11.5f, 9.0f)
                lineTo(11.5f, 9.0f)
                close()
                moveTo(11.0f, 12.0f)
                lineToRelative(0.25f, -1.0f)
                horizontalLineToRelative(0.5f)
                lineTo(12.0f, 12.0f)
                horizontalLineTo(11.0f)
                close()
            }
            materialPath {
                moveTo(19.84f, 9.55f)
                lineTo(19.24f, 12.0f)
                lineToRelative(-0.56f, -2.26f)
                curveTo(18.58f, 9.3f, 18.19f, 9.0f, 17.74f, 9.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.45f, 0.0f, -0.84f, 0.3f, -0.94f, 0.74f)
                lineTo(16.24f, 12.0f)
                lineToRelative(-0.6f, -2.45f)
                curveTo(15.56f, 9.23f, 15.27f, 9.0f, 14.93f, 9.0f)
                horizontalLineToRelative(0.0f)
                curveToRelative(-0.47f, 0.0f, -0.82f, 0.44f, -0.71f, 0.9f)
                lineToRelative(1.09f, 4.38f)
                curveTo(15.43f, 14.7f, 15.81f, 15.0f, 16.24f, 15.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.43f, 0.0f, 0.81f, -0.3f, 0.92f, -0.72f)
                lineToRelative(0.58f, -2.32f)
                lineToRelative(0.58f, 2.32f)
                curveTo(18.43f, 14.7f, 18.81f, 15.0f, 19.24f, 15.0f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.43f, 0.0f, 0.81f, -0.3f, 0.92f, -0.72f)
                lineToRelative(1.09f, -4.38f)
                curveTo(21.37f, 9.44f, 21.02f, 9.0f, 20.55f, 9.0f)
                horizontalLineToRelative(0.0f)
                curveTo(20.21f, 9.0f, 19.92f, 9.23f, 19.84f, 9.55f)
                close()
            }
        }
        return _rawOn!!
    }

private var _rawOn: ImageVector? = null
