/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SignLanguage: ImageVector
    get() {
        if (_signLanguage != null) {
            return _signLanguage!!
        }
        _signLanguage = materialIcon(name = "Rounded.SignLanguage") {
            materialPath {
                moveTo(12.49f, 13.0f)
                lineToRelative(-0.93f, -1.86f)
                curveToRelative(-0.37f, -0.74f, -0.07f, -1.64f, 0.67f, -2.01f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.16f, -0.08f, 0.34f, -0.05f, 0.47f, 0.07f)
                lineToRelative(5.53f, 5.26f)
                curveToRelative(0.5f, 0.47f, 0.78f, 1.13f, 0.78f, 1.81f)
                verticalLineToRelative(5.23f)
                curveToRelative(0.0f, 1.38f, -1.12f, 2.5f, -2.5f, 2.5f)
                horizontalLineToRelative(-11.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineTo(10.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(3.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(4.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineTo(12.49f)
                close()
                moveTo(11.78f, 7.12f)
                curveToRelative(-0.84f, 0.4f, -1.17f, 0.62f, -1.63f, 1.19f)
                lineToRelative(-2.7f, -2.85f)
                curveToRelative(-0.38f, -0.4f, -0.36f, -1.03f, 0.04f, -1.41f)
                curveToRelative(0.4f, -0.38f, 1.03f, -0.36f, 1.41f, 0.04f)
                lineTo(11.78f, 7.12f)
                close()
                moveTo(9.64f, 9.21f)
                curveTo(9.41f, 9.76f, 9.35f, 10.45f, 9.44f, 11.0f)
                horizontalLineTo(8.58f)
                lineTo(6.31f, 8.61f)
                curveTo(5.93f, 8.21f, 5.94f, 7.58f, 6.35f, 7.2f)
                curveToRelative(0.4f, -0.38f, 1.03f, -0.36f, 1.41f, 0.04f)
                lineTo(9.64f, 9.21f)
                close()
                moveTo(20.33f, 13.91f)
                lineToRelative(0.88f, -0.83f)
                curveToRelative(0.5f, -0.47f, 0.79f, -1.13f, 0.79f, -1.82f)
                verticalLineTo(3.64f)
                curveToRelative(0.0f, -0.17f, -0.11f, -0.33f, -0.27f, -0.39f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(-0.78f, -0.28f, -1.64f, 0.12f, -1.92f, 0.9f)
                lineTo(19.1f, 6.11f)
                lineToRelative(-5.5f, -5.8f)
                curveToRelative(-0.38f, -0.4f, -1.01f, -0.42f, -1.41f, -0.04f)
                curveToRelative(-0.4f, 0.38f, -0.42f, 1.01f, -0.04f, 1.41f)
                lineToRelative(3.79f, 3.99f)
                lineToRelative(-0.73f, 0.69f)
                lineToRelative(-4.82f, -5.08f)
                curveToRelative(-0.38f, -0.4f, -1.01f, -0.42f, -1.41f, -0.04f)
                curveToRelative(-0.4f, 0.38f, -0.42f, 1.01f, -0.04f, 1.41f)
                lineToRelative(3.78f, 3.98f)
                lineTo(15.38f, 9.0f)
                lineToRelative(3.61f, 3.43f)
                lineToRelative(0.61f, 0.58f)
                curveTo(19.89f, 13.28f, 20.13f, 13.58f, 20.33f, 13.91f)
                close()
            }
        }
        return _signLanguage!!
    }

private var _signLanguage: ImageVector? = null
