/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SignalWifi4Bar: ImageVector
    get() {
        if (_signalWifi4Bar != null) {
            return _signalWifi4Bar!!
        }
        _signalWifi4Bar = materialIcon(name = "Rounded.SignalWifi4Bar") {
            materialPath {
                moveTo(23.64f, 7.0f)
                curveToRelative(-0.45f, -0.34f, -4.93f, -4.0f, -11.64f, -4.0f)
                curveTo(5.28f, 3.0f, 0.81f, 6.66f, 0.36f, 7.0f)
                lineToRelative(10.08f, 12.56f)
                curveToRelative(0.8f, 1.0f, 2.32f, 1.0f, 3.12f, 0.0f)
                lineTo(23.64f, 7.0f)
                close()
            }
        }
        return _signalWifi4Bar!!
    }

private var _signalWifi4Bar: ImageVector? = null
