/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.CarCrash: ImageVector
    get() {
        if (_carCrash != null) {
            return _carCrash!!
        }
        _carCrash = materialIcon(name = "Sharp.CarCrash") {
            materialPath {
                moveTo(18.0f, 1.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.24f, 5.0f, 5.0f, 5.0f)
                reflectiveCurveToRelative(5.0f, -2.24f, 5.0f, -5.0f)
                reflectiveCurveTo(20.76f, 1.0f, 18.0f, 1.0f)
                close()
                moveTo(18.5f, 7.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(7.0f)
                close()
                moveTo(18.5f, 8.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(8.0f)
                horizontalLineTo(18.5f)
                close()
                moveTo(17.91f, 13.0f)
                curveToRelative(0.06f, 0.16f, 0.09f, 0.33f, 0.09f, 0.5f)
                curveToRelative(0.0f, 0.83f, -0.67f, 1.5f, -1.5f, 1.5f)
                reflectiveCurveTo(15.0f, 14.33f, 15.0f, 13.5f)
                curveToRelative(0.0f, -0.39f, 0.15f, -0.74f, 0.39f, -1.01f)
                curveToRelative(-1.63f, -0.66f, -2.96f, -1.91f, -3.71f, -3.49f)
                horizontalLineTo(5.81f)
                lineToRelative(1.04f, -3.0f)
                horizontalLineTo(11.0f)
                curveToRelative(0.0f, -0.69f, 0.1f, -1.37f, 0.29f, -2.0f)
                horizontalLineTo(5.41f)
                lineTo(3.0f, 11.0f)
                verticalLineToRelative(9.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-7.68f)
                curveTo(19.95f, 12.83f, 18.84f, 13.01f, 17.91f, 13.0f)
                close()
                moveTo(7.5f, 15.0f)
                curveTo(6.67f, 15.0f, 6.0f, 14.33f, 6.0f, 13.5f)
                reflectiveCurveTo(6.67f, 12.0f, 7.5f, 12.0f)
                reflectiveCurveTo(9.0f, 12.67f, 9.0f, 13.5f)
                reflectiveCurveTo(8.33f, 15.0f, 7.5f, 15.0f)
                close()
            }
        }
        return _carCrash!!
    }

private var _carCrash: ImageVector? = null
