/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PersonAddDisabled: ImageVector
    get() {
        if (_personAddDisabled != null) {
            return _personAddDisabled!!
        }
        _personAddDisabled = materialIcon(name = "Sharp.PersonAddDisabled") {
            materialPath {
                moveTo(14.48f, 11.95f)
                curveToRelative(0.17f, 0.02f, 0.34f, 0.05f, 0.52f, 0.05f)
                curveToRelative(2.21f, 0.0f, 4.0f, -1.79f, 4.0f, -4.0f)
                reflectiveCurveToRelative(-1.79f, -4.0f, -4.0f, -4.0f)
                reflectiveCurveToRelative(-4.0f, 1.79f, -4.0f, 4.0f)
                curveToRelative(0.0f, 0.18f, 0.03f, 0.35f, 0.05f, 0.52f)
                lineToRelative(3.43f, 3.43f)
                close()
                moveTo(16.69f, 14.16f)
                lineTo(22.53f, 20.0f)
                lineTo(23.0f, 20.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(0.0f, -2.14f, -3.56f, -3.5f, -6.31f, -3.84f)
                close()
                moveTo(0.0f, 3.12f)
                lineToRelative(4.0f, 4.0f)
                lineTo(4.0f, 10.0f)
                lineTo(1.0f, 10.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(2.88f)
                lineToRelative(2.51f, 2.51f)
                curveTo(9.19f, 15.11f, 7.0f, 16.3f, 7.0f, 18.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(9.88f)
                lineToRelative(4.0f, 4.0f)
                lineToRelative(1.41f, -1.41f)
                lineTo(1.41f, 1.71f)
                lineTo(0.0f, 3.12f)
                close()
                moveTo(6.88f, 10.0f)
                lineTo(6.0f, 10.0f)
                verticalLineToRelative(-0.88f)
                lineToRelative(0.88f, 0.88f)
                close()
            }
        }
        return _personAddDisabled!!
    }

private var _personAddDisabled: ImageVector? = null
