/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.RunCircle: ImageVector
    get() {
        if (_runCircle != null) {
            return _runCircle!!
        }
        _runCircle = materialIcon(name = "Sharp.RunCircle") {
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(13.5f, 6.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                curveTo(12.5f, 6.45f, 12.95f, 6.0f, 13.5f, 6.0f)
                close()
                moveTo(16.0f, 12.0f)
                curveToRelative(-0.7f, 0.0f, -2.01f, -0.54f, -2.91f, -1.76f)
                lineToRelative(-0.41f, 2.35f)
                lineTo(14.0f, 14.03f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-3.58f)
                lineToRelative(-1.11f, -1.21f)
                lineToRelative(-0.52f, 2.64f)
                lineTo(7.6f, 15.08f)
                lineToRelative(0.2f, -0.98f)
                lineToRelative(2.78f, 0.57f)
                lineToRelative(0.96f, -4.89f)
                lineTo(10.0f, 10.35f)
                verticalLineTo(12.0f)
                horizontalLineTo(9.0f)
                verticalLineTo(9.65f)
                lineToRelative(3.28f, -1.21f)
                curveToRelative(0.49f, -0.18f, 1.03f, 0.06f, 1.26f, 0.53f)
                curveTo(14.37f, 10.67f, 15.59f, 11.0f, 16.0f, 11.0f)
                verticalLineTo(12.0f)
                close()
            }
        }
        return _runCircle!!
    }

private var _runCircle: ImageVector? = null
