/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.DirectionsBoatFilled: ImageVector
    get() {
        if (_directionsBoatFilled != null) {
            return _directionsBoatFilled!!
        }
        _directionsBoatFilled = materialIcon(name = "TwoTone.DirectionsBoatFilled") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(19.77f, 12.66f)
                lineToRelative(-1.12f, 3.97f)
                curveToRelative(-0.78f, -0.43f, -1.07f, -0.86f, -2.65f, -2.67f)
                curveTo(14.4f, 15.78f, 13.57f, 17.0f, 12.0f, 17.0f)
                curveToRelative(-1.53f, 0.0f, -2.34f, -1.15f, -4.0f, -3.04f)
                curveToRelative(-1.6f, 1.82f, -1.87f, 2.21f, -2.65f, 2.65f)
                lineToRelative(-1.13f, -3.96f)
                lineTo(12.0f, 10.11f)
                lineTo(19.77f, 12.66f)
                close()
            }
            materialPath {
                moveTo(19.77f, 12.66f)
                lineToRelative(-1.12f, 3.97f)
                curveToRelative(-0.78f, -0.43f, -1.07f, -0.86f, -2.65f, -2.67f)
                curveTo(14.4f, 15.78f, 13.57f, 17.0f, 12.0f, 17.0f)
                curveToRelative(-1.53f, 0.0f, -2.34f, -1.15f, -4.0f, -3.04f)
                curveToRelative(-1.6f, 1.82f, -1.87f, 2.21f, -2.65f, 2.65f)
                lineToRelative(-1.13f, -3.96f)
                lineTo(12.0f, 10.11f)
                lineTo(19.77f, 12.66f)
                close()
                moveTo(15.0f, 1.0f)
                horizontalLineTo(9.0f)
                verticalLineToRelative(3.0f)
                horizontalLineTo(6.0f)
                curveTo(4.9f, 4.0f, 4.0f, 4.9f, 4.0f, 6.0f)
                verticalLineToRelative(4.62f)
                lineToRelative(-1.29f, 0.42f)
                curveToRelative(-0.63f, 0.19f, -0.81f, 0.84f, -0.66f, 1.28f)
                lineTo(3.95f, 19.0f)
                horizontalLineTo(4.0f)
                curveToRelative(1.6f, 0.0f, 3.02f, -0.88f, 4.0f, -2.0f)
                curveToRelative(0.98f, 1.12f, 2.4f, 2.0f, 4.0f, 2.0f)
                reflectiveCurveToRelative(3.02f, -0.88f, 4.0f, -2.0f)
                curveToRelative(0.98f, 1.12f, 2.4f, 2.0f, 4.0f, 2.0f)
                horizontalLineToRelative(0.05f)
                lineToRelative(1.91f, -6.68f)
                curveToRelative(0.11f, -0.37f, 0.04f, -1.06f, -0.66f, -1.28f)
                lineTo(20.0f, 10.62f)
                verticalLineTo(6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineTo(1.0f)
                lineTo(15.0f, 1.0f)
                close()
                moveTo(6.0f, 9.97f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(3.97f)
                lineTo(12.0f, 8.0f)
                lineTo(6.0f, 9.97f)
                lineTo(6.0f, 9.97f)
                close()
                moveTo(16.0f, 19.68f)
                curveToRelative(-1.22f, 0.85f, -2.61f, 1.28f, -4.0f, 1.28f)
                reflectiveCurveToRelative(-2.78f, -0.43f, -4.0f, -1.28f)
                curveTo(6.78f, 20.53f, 5.39f, 21.0f, 4.0f, 21.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(1.38f, 0.0f, 2.74f, -0.35f, 4.0f, -0.99f)
                curveToRelative(1.26f, 0.64f, 2.63f, 0.97f, 4.0f, 0.97f)
                reflectiveCurveToRelative(2.74f, -0.32f, 4.0f, -0.97f)
                curveToRelative(1.26f, 0.65f, 2.62f, 0.99f, 4.0f, 0.99f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(-2.0f)
                curveTo(18.61f, 21.0f, 17.22f, 20.53f, 16.0f, 19.68f)
                lineTo(16.0f, 19.68f)
                close()
            }
        }
        return _directionsBoatFilled!!
    }

private var _directionsBoatFilled: ImageVector? = null
