/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.PhonelinkLock: ImageVector
    get() {
        if (_phonelinkLock != null) {
            return _phonelinkLock!!
        }
        _phonelinkLock = materialIcon(name = "TwoTone.PhonelinkLock") {
            materialPath {
                moveTo(8.0f, 7.0f)
                curveTo(6.6f, 7.0f, 5.2f, 8.1f, 5.2f, 9.5f)
                lineTo(5.2f, 11.0f)
                curveToRelative(-0.6f, 0.0f, -1.2f, 0.6f, -1.2f, 1.2f)
                verticalLineToRelative(3.5f)
                curveToRelative(0.0f, 0.7f, 0.6f, 1.3f, 1.2f, 1.3f)
                horizontalLineToRelative(5.5f)
                curveToRelative(0.7f, 0.0f, 1.3f, -0.6f, 1.3f, -1.2f)
                verticalLineToRelative(-3.5f)
                curveToRelative(0.0f, -0.7f, -0.6f, -1.3f, -1.2f, -1.3f)
                lineTo(10.8f, 9.5f)
                curveTo(10.8f, 8.1f, 9.4f, 7.0f, 8.0f, 7.0f)
                close()
                moveTo(9.5f, 11.0f)
                horizontalLineToRelative(-3.0f)
                lineTo(6.5f, 9.5f)
                curveToRelative(0.0f, -0.8f, 0.7f, -1.3f, 1.5f, -1.3f)
                reflectiveCurveToRelative(1.5f, 0.5f, 1.5f, 1.3f)
                lineTo(9.5f, 11.0f)
                close()
                moveTo(21.0f, 21.0f)
                lineTo(21.0f, 3.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                lineTo(9.0f, 1.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(2.0f)
                lineTo(9.0f, 4.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(16.0f)
                lineTo(9.0f, 20.0f)
                verticalLineToRelative(-2.0f)
                lineTo(7.0f, 18.0f)
                verticalLineToRelative(3.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                close()
            }
        }
        return _phonelinkLock!!
    }

private var _phonelinkLock: ImageVector? = null
