/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.ShuffleOn: ImageVector
    get() {
        if (_shuffleOn != null) {
            return _shuffleOn!!
        }
        _shuffleOn = materialIcon(name = "TwoTone.ShuffleOn") {
            materialPath {
                moveTo(21.0f, 1.0f)
                horizontalLineTo(3.0f)
                curveTo(1.9f, 1.0f, 1.0f, 1.9f, 1.0f, 3.0f)
                verticalLineToRelative(18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(18.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(3.0f)
                curveTo(23.0f, 1.9f, 22.1f, 1.0f, 21.0f, 1.0f)
                close()
                moveTo(5.41f, 4.0f)
                lineToRelative(5.18f, 5.17f)
                lineToRelative(-1.42f, 1.41f)
                lineTo(4.0f, 5.41f)
                lineTo(5.41f, 4.0f)
                close()
                moveTo(20.0f, 20.0f)
                horizontalLineToRelative(-5.5f)
                lineToRelative(2.05f, -2.05f)
                lineToRelative(-3.13f, -3.13f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(3.13f, 3.13f)
                lineTo(20.0f, 14.5f)
                verticalLineTo(20.0f)
                close()
                moveTo(20.0f, 9.5f)
                lineToRelative(-2.04f, -2.04f)
                lineTo(5.41f, 20.0f)
                lineTo(4.0f, 18.59f)
                lineTo(16.54f, 6.04f)
                lineTo(14.5f, 4.0f)
                horizontalLineTo(20.0f)
                verticalLineTo(9.5f)
                close()
            }
        }
        return _shuffleOn!!
    }

private var _shuffleOn: ImageVector? = null
