/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.UnfoldMoreDouble: ImageVector
    get() {
        if (_unfoldMoreDouble != null) {
            return _unfoldMoreDouble!!
        }
        _unfoldMoreDouble = materialIcon(name = "TwoTone.UnfoldMoreDouble") {
            materialPath {
                moveTo(12.0f, 7.83f)
                lineTo(15.17f, 11.0f)
                lineToRelative(1.41f, -1.41f)
                lineTo(12.0f, 5.0f)
                lineTo(7.41f, 9.59f)
                lineTo(8.83f, 11.0f)
                lineTo(12.0f, 7.83f)
                close()
                moveTo(12.0f, 2.83f)
                lineTo(15.17f, 6.0f)
                lineToRelative(1.41f, -1.41f)
                lineTo(12.0f, 0.0f)
                lineTo(7.41f, 4.59f)
                lineTo(8.83f, 6.0f)
                lineTo(12.0f, 2.83f)
                close()
                moveTo(12.0f, 21.17f)
                lineTo(8.83f, 18.0f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(12.0f, 24.0f)
                lineToRelative(4.59f, -4.59f)
                lineTo(15.17f, 18.0f)
                lineTo(12.0f, 21.17f)
                close()
                moveTo(12.0f, 16.17f)
                lineTo(8.83f, 13.0f)
                lineToRelative(-1.41f, 1.41f)
                lineTo(12.0f, 19.0f)
                lineToRelative(4.59f, -4.59f)
                lineTo(15.17f, 13.0f)
                lineTo(12.0f, 16.17f)
                close()
            }
        }
        return _unfoldMoreDouble!!
    }

private var _unfoldMoreDouble: ImageVector? = null
