/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.FiberPin: ImageVector
    get() {
        if (_fiberPin != null) {
            return _fiberPin!!
        }
        _fiberPin = materialIcon(name = "Outlined.FiberPin") {
            materialPath {
                moveTo(11.0f, 15.0f)
                horizontalLineToRelative(1.5f)
                lineTo(12.5f, 9.0f)
                lineTo(11.0f, 9.0f)
                verticalLineToRelative(6.0f)
                close()
                moveTo(18.75f, 9.0f)
                verticalLineToRelative(3.5f)
                lineTo(16.25f, 9.0f)
                lineTo(15.0f, 9.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.25f)
                verticalLineToRelative(-3.5f)
                lineTo(18.8f, 15.0f)
                lineTo(20.0f, 15.0f)
                lineTo(20.0f, 9.0f)
                horizontalLineToRelative(-1.25f)
                close()
                moveTo(7.5f, 9.0f)
                lineTo(4.0f, 9.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.85f, 0.0f, 1.5f, -0.65f, 1.5f, -1.5f)
                verticalLineToRelative(-1.0f)
                curveTo(9.0f, 9.65f, 8.35f, 9.0f, 7.5f, 9.0f)
                close()
                moveTo(7.5f, 11.5f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.0f)
                close()
            }
        }
        return _fiberPin!!
    }

private var _fiberPin: ImageVector? = null
