/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SwipeDown: ImageVector
    get() {
        if (_swipeDown != null) {
            return _swipeDown!!
        }
        _swipeDown = materialIcon(name = "Outlined.SwipeDown") {
            materialPath {
                moveTo(20.22f, 10.0f)
                lineToRelative(-4.15f, 0.01f)
                curveToRelative(-0.16f, -0.01f, -0.31f, 0.02f, -0.45f, 0.08f)
                lineToRelative(-0.59f, 0.26f)
                lineTo(13.2f, 6.25f)
                curveToRelative(-0.56f, -1.26f, -2.04f, -1.83f, -3.3f, -1.27f)
                reflectiveCurveToRelative(-1.83f, 2.04f, -1.27f, 3.3f)
                lineToRelative(3.3f, 7.45f)
                lineToRelative(-1.87f, 0.39f)
                curveToRelative(-0.19f, 0.05f, -0.99f, 0.27f, -1.36f, 1.21f)
                lineTo(8.0f, 19.19f)
                lineToRelative(6.78f, 2.67f)
                curveToRelative(0.49f, 0.19f, 1.05f, 0.18f, 1.53f, -0.04f)
                lineToRelative(5.99f, -2.65f)
                curveToRelative(0.89f, -0.4f, 1.37f, -1.38f, 1.13f, -2.32f)
                lineToRelative(-1.36f, -5.34f)
                curveTo(21.85f, 10.65f, 21.1f, 10.04f, 20.22f, 10.0f)
                close()
                moveTo(21.49f, 17.34f)
                lineTo(15.5f, 20.0f)
                lineToRelative(-4.92f, -1.96f)
                lineToRelative(4.18f, -0.88f)
                lineToRelative(-4.3f, -9.7f)
                curveToRelative(-0.11f, -0.25f, 0.0f, -0.55f, 0.25f, -0.66f)
                curveToRelative(0.25f, -0.11f, 0.55f, 0.0f, 0.66f, 0.25f)
                lineToRelative(2.5f, 5.65f)
                lineToRelative(1.61f, -0.71f)
                lineTo(20.13f, 12.0f)
                lineTo(21.49f, 17.34f)
                close()
                moveTo(3.8f, 12.18f)
                curveToRelative(-0.2f, -0.86f, -0.3f, -1.76f, -0.3f, -2.68f)
                curveToRelative(0.0f, -2.84f, 0.99f, -5.45f, 2.63f, -7.5f)
                lineTo(7.2f, 3.07f)
                curveTo(5.82f, 4.85f, 5.0f, 7.08f, 5.0f, 9.5f)
                curveToRelative(0.0f, 0.88f, 0.11f, 1.74f, 0.32f, 2.56f)
                lineToRelative(1.62f, -1.62f)
                lineTo(8.0f, 11.5f)
                lineTo(4.5f, 15.0f)
                lineTo(1.0f, 11.5f)
                lineToRelative(1.06f, -1.06f)
                lineTo(3.8f, 12.18f)
                close()
            }
        }
        return _swipeDown!!
    }

private var _swipeDown: ImageVector? = null
