/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.HeadsetOff: ImageVector
    get() {
        if (_headsetOff != null) {
            return _headsetOff!!
        }
        _headsetOff = materialIcon(name = "Rounded.HeadsetOff") {
            materialPath {
                moveTo(12.0f, 4.0f)
                curveToRelative(3.87f, 0.0f, 7.0f, 3.13f, 7.0f, 7.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(-0.6f, 0.0f, -1.13f, 0.27f, -1.49f, 0.68f)
                lineTo(21.0f, 18.17f)
                verticalLineTo(11.0f)
                curveToRelative(0.0f, -4.97f, -4.03f, -9.0f, -9.0f, -9.0f)
                curveTo(9.98f, 2.0f, 8.12f, 2.67f, 6.62f, 3.8f)
                lineToRelative(1.43f, 1.43f)
                curveTo(9.17f, 4.45f, 10.53f, 4.0f, 12.0f, 4.0f)
                close()
            }
            materialPath {
                moveTo(21.19f, 21.19f)
                lineTo(2.81f, 2.81f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveTo(1.0f, 3.2f, 1.0f, 3.83f, 1.39f, 4.22f)
                lineToRelative(2.63f, 2.63f)
                curveTo(3.37f, 8.09f, 3.0f, 9.5f, 3.0f, 11.0f)
                verticalLineToRelative(7.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineToRelative(-4.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.94f, 0.19f, -1.83f, 0.52f, -2.65f)
                lineTo(15.0f, 17.83f)
                verticalLineTo(18.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(0.17f)
                lineToRelative(1.0f, 1.0f)
                horizontalLineTo(13.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                reflectiveCurveToRelative(0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(6.0f)
                curveToRelative(0.36f, 0.0f, 0.68f, -0.1f, 0.97f, -0.26f)
                curveToRelative(0.38f, 0.23f, 0.89f, 0.2f, 1.22f, -0.13f)
                curveTo(21.58f, 22.22f, 21.58f, 21.58f, 21.19f, 21.19f)
                close()
            }
        }
        return _headsetOff!!
    }

private var _headsetOff: ImageVector? = null
