/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.NoteAlt: ImageVector
    get() {
        if (_noteAlt != null) {
            return _noteAlt!!
        }
        _noteAlt = materialIcon(name = "Rounded.NoteAlt") {
            materialPath {
                moveTo(19.0f, 3.0f)
                horizontalLineToRelative(-4.18f)
                curveTo(14.4f, 1.84f, 13.3f, 1.0f, 12.0f, 1.0f)
                reflectiveCurveTo(9.6f, 1.84f, 9.18f, 3.0f)
                horizontalLineTo(5.0f)
                curveTo(3.9f, 3.0f, 3.0f, 3.9f, 3.0f, 5.0f)
                verticalLineToRelative(14.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(5.0f)
                curveTo(21.0f, 3.9f, 20.1f, 3.0f, 19.0f, 3.0f)
                close()
                moveTo(12.0f, 2.75f)
                curveToRelative(0.41f, 0.0f, 0.75f, 0.34f, 0.75f, 0.75f)
                reflectiveCurveTo(12.41f, 4.25f, 12.0f, 4.25f)
                reflectiveCurveToRelative(-0.75f, -0.34f, -0.75f, -0.75f)
                reflectiveCurveTo(11.59f, 2.75f, 12.0f, 2.75f)
                close()
                moveTo(8.9f, 17.0f)
                horizontalLineTo(7.5f)
                curveTo(7.22f, 17.0f, 7.0f, 16.78f, 7.0f, 16.5f)
                verticalLineToRelative(-1.43f)
                curveToRelative(0.0f, -0.13f, 0.05f, -0.26f, 0.15f, -0.35f)
                lineToRelative(5.81f, -5.81f)
                lineToRelative(2.12f, 2.12f)
                lineToRelative(-5.83f, 5.83f)
                curveTo(9.16f, 16.95f, 9.03f, 17.0f, 8.9f, 17.0f)
                close()
                moveTo(16.85f, 9.27f)
                lineToRelative(-1.06f, 1.06f)
                lineToRelative(-2.12f, -2.12f)
                lineToRelative(1.06f, -1.06f)
                curveToRelative(0.2f, -0.2f, 0.51f, -0.2f, 0.71f, 0.0f)
                lineToRelative(1.41f, 1.41f)
                curveTo(17.05f, 8.76f, 17.05f, 9.07f, 16.85f, 9.27f)
                close()
            }
        }
        return _noteAlt!!
    }

private var _noteAlt: ImageVector? = null
