/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SwitchAccessShortcutAdd: ImageVector
    get() {
        if (_switchAccessShortcutAdd != null) {
            return _switchAccessShortcutAdd!!
        }
        _switchAccessShortcutAdd = materialIcon(name = "Rounded.SwitchAccessShortcutAdd") {
            materialPath {
                moveTo(21.0f, 18.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, 0.45f, -1.0f, 1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.0f)
                curveTo(20.0f, 17.55f, 20.45f, 18.0f, 21.0f, 18.0f)
                close()
                moveTo(7.06f, 8.94f)
                lineTo(5.0f, 8.0f)
                lineToRelative(2.06f, -0.94f)
                lineTo(8.0f, 5.0f)
                lineToRelative(0.94f, 2.06f)
                lineTo(11.0f, 8.0f)
                lineTo(8.94f, 8.94f)
                lineTo(8.0f, 11.0f)
                lineTo(7.06f, 8.94f)
                close()
                moveTo(8.0f, 21.0f)
                lineToRelative(0.94f, -2.06f)
                lineTo(11.0f, 18.0f)
                lineToRelative(-2.06f, -0.94f)
                lineTo(8.0f, 15.0f)
                lineToRelative(-0.94f, 2.06f)
                lineTo(5.0f, 18.0f)
                lineToRelative(2.06f, 0.94f)
                lineTo(8.0f, 21.0f)
                close()
                moveTo(4.37f, 12.37f)
                lineTo(3.0f, 13.0f)
                lineToRelative(1.37f, 0.63f)
                lineTo(5.0f, 15.0f)
                lineToRelative(0.63f, -1.37f)
                lineTo(7.0f, 13.0f)
                lineToRelative(-1.37f, -0.63f)
                lineTo(5.0f, 11.0f)
                lineTo(4.37f, 12.37f)
                close()
                moveTo(19.0f, 20.41f)
                curveToRelative(0.0f, 0.78f, -0.84f, 1.25f, -1.51f, 0.86f)
                curveTo(14.21f, 19.36f, 12.0f, 15.79f, 12.0f, 12.0f)
                curveToRelative(0.0f, -2.73f, 1.08f, -5.27f, 2.75f, -7.25f)
                lineToRelative(-1.9f, -1.9f)
                curveTo(12.54f, 2.54f, 12.76f, 2.0f, 13.21f, 2.0f)
                horizontalLineToRelative(5.29f)
                curveTo(18.78f, 2.0f, 19.0f, 2.22f, 19.0f, 2.5f)
                verticalLineToRelative(5.29f)
                curveToRelative(0.0f, 0.45f, -0.54f, 0.67f, -0.85f, 0.35f)
                lineToRelative(-1.97f, -1.97f)
                curveTo(14.84f, 7.82f, 14.0f, 9.88f, 14.0f, 12.0f)
                curveToRelative(0.0f, 3.13f, 1.86f, 6.01f, 4.51f, 7.55f)
                curveTo(18.81f, 19.73f, 19.0f, 20.06f, 19.0f, 20.41f)
                close()
            }
        }
        return _switchAccessShortcutAdd!!
    }

private var _switchAccessShortcutAdd: ImageVector? = null
