/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.WifiCalling3: ImageVector
    get() {
        if (_wifiCalling3 != null) {
            return _wifiCalling3!!
        }
        _wifiCalling3 = materialIcon(name = "Rounded.WifiCalling3") {
            materialPath {
                moveTo(21.54f, 4.8f)
                curveTo(20.17f, 3.67f, 18.41f, 3.0f, 16.49f, 3.0f)
                curveToRelative(-1.92f, 0.0f, -3.67f, 0.67f, -5.05f, 1.8f)
                curveToRelative(-0.34f, 0.28f, -0.36f, 0.79f, -0.05f, 1.1f)
                lineToRelative(0.01f, 0.01f)
                curveToRelative(0.27f, 0.27f, 0.7f, 0.29f, 1.0f, 0.05f)
                curveToRelative(1.12f, -0.91f, 2.54f, -1.45f, 4.09f, -1.45f)
                reflectiveCurveToRelative(2.97f, 0.55f, 4.09f, 1.45f)
                curveToRelative(0.3f, 0.24f, 0.73f, 0.23f, 1.0f, -0.05f)
                lineToRelative(0.01f, -0.01f)
                curveTo(21.9f, 5.59f, 21.88f, 5.07f, 21.54f, 4.8f)
                close()
            }
            materialPath {
                moveTo(19.45f, 8.04f)
                lineTo(19.45f, 8.04f)
                curveToRelative(0.33f, -0.33f, 0.28f, -0.88f, -0.11f, -1.15f)
                curveTo(18.54f, 6.33f, 17.55f, 6.0f, 16.49f, 6.0f)
                reflectiveCurveToRelative(-2.04f, 0.33f, -2.85f, 0.89f)
                curveToRelative(-0.38f, 0.27f, -0.44f, 0.82f, -0.11f, 1.15f)
                lineToRelative(0.0f, 0.0f)
                curveToRelative(0.25f, 0.25f, 0.65f, 0.31f, 0.94f, 0.1f)
                curveToRelative(0.57f, -0.4f, 1.27f, -0.64f, 2.02f, -0.64f)
                reflectiveCurveToRelative(1.45f, 0.24f, 2.02f, 0.64f)
                curveTo(18.8f, 8.35f, 19.2f, 8.29f, 19.45f, 8.04f)
                close()
            }
            materialPath {
                moveTo(16.49f, 8.9f)
                curveToRelative(-0.32f, 0.0f, -0.62f, 0.08f, -0.89f, 0.21f)
                curveToRelative(-0.3f, 0.15f, -0.34f, 0.56f, -0.11f, 0.79f)
                lineToRelative(0.65f, 0.65f)
                curveToRelative(0.2f, 0.2f, 0.51f, 0.2f, 0.71f, 0.0f)
                lineToRelative(0.65f, -0.65f)
                curveToRelative(0.23f, -0.23f, 0.19f, -0.64f, -0.11f, -0.79f)
                curveTo(17.12f, 8.97f, 16.81f, 8.9f, 16.49f, 8.9f)
                close()
            }
            materialPath {
                moveTo(15.63f, 14.4f)
                lineToRelative(-2.52f, 2.5f)
                curveToRelative(-2.5f, -1.43f, -4.57f, -3.5f, -6.0f, -6.0f)
                lineToRelative(2.5f, -2.52f)
                curveToRelative(0.23f, -0.24f, 0.33f, -0.57f, 0.27f, -0.9f)
                lineTo(9.13f, 3.8f)
                curveTo(9.04f, 3.34f, 8.63f, 3.0f, 8.15f, 3.0f)
                lineTo(4.0f, 3.0f)
                curveTo(3.44f, 3.0f, 2.97f, 3.47f, 3.0f, 4.03f)
                curveTo(3.17f, 6.92f, 4.05f, 9.63f, 5.43f, 12.0f)
                curveToRelative(1.58f, 2.73f, 3.85f, 4.99f, 6.57f, 6.57f)
                curveToRelative(2.37f, 1.37f, 5.08f, 2.26f, 7.97f, 2.43f)
                curveToRelative(0.56f, 0.03f, 1.03f, -0.44f, 1.03f, -1.0f)
                lineToRelative(0.0f, -4.15f)
                curveToRelative(0.0f, -0.48f, -0.34f, -0.89f, -0.8f, -0.98f)
                lineToRelative(-3.67f, -0.73f)
                curveTo(16.2f, 14.07f, 15.86f, 14.17f, 15.63f, 14.4f)
                close()
            }
        }
        return _wifiCalling3!!
    }

private var _wifiCalling3: ImageVector? = null
