/*
 * Copyright 2024 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.TextRotateUp: ImageVector
    get() {
        if (_textRotateUp != null) {
            return _textRotateUp!!
        }
        _textRotateUp = materialIcon(name = "Sharp.TextRotateUp") {
            materialPath {
                moveTo(18.0f, 4.0f)
                lineToRelative(-3.0f, 3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(13.0f)
                horizontalLineToRelative(2.0f)
                lineTo(19.0f, 7.0f)
                horizontalLineToRelative(2.0f)
                lineToRelative(-3.0f, -3.0f)
                close()
                moveTo(11.8f, 15.5f)
                verticalLineToRelative(-5.0f)
                lineToRelative(2.2f, -0.9f)
                lineTo(14.0f, 7.5f)
                lineTo(3.0f, 12.25f)
                verticalLineToRelative(1.5f)
                lineToRelative(11.0f, 4.75f)
                verticalLineToRelative(-2.1f)
                lineToRelative(-2.2f, -0.9f)
                close()
                moveTo(4.98f, 13.0f)
                lineTo(10.0f, 11.13f)
                verticalLineToRelative(3.74f)
                lineTo(4.98f, 13.0f)
                close()
            }
        }
        return _textRotateUp!!
    }

private var _textRotateUp: ImageVector? = null
